/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.core.crafting.ingredient;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.grim3212.assorted.lib.core.fluid.FluidInformation;
import com.grim3212.assorted.lib.platform.Services;
import com.grim3212.assorted.lib.util.LibCommonTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class LibFluidIngredient {
    protected final TagKey<Item> itemTag;
    protected final TagKey<Fluid> fluidTag;
    protected final long amount;
    private List<ItemStack> itemStacks;

    protected LibFluidIngredient(@Nullable TagKey<Item> itemTag, TagKey<Fluid> fluidTag) {
        this(itemTag, fluidTag, Services.FLUIDS.getBucketAmount());
    }

    public LibFluidIngredient(@Nullable TagKey<Item> itemTag, TagKey<Fluid> fluidTag, long amount) {
        this.itemTag = itemTag;
        this.fluidTag = fluidTag;
        this.amount = amount;
    }

    public TagKey<Item> getItemTag() {
        return this.itemTag;
    }

    public TagKey<Fluid> getFluidTag() {
        return this.fluidTag;
    }

    public long getAmount() {
        return this.amount;
    }

    public boolean test(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return (this.itemTag != null && stack.m_204117_(this.itemTag) || this.itemTag == null) && this.doesInputMatchFluid(stack);
    }

    private boolean doesInputMatchFluid(ItemStack stack) {
        Optional<FluidInformation> fluidInformation = Services.FLUIDS.get(stack);
        if (fluidInformation.isPresent()) {
            long extracted = Services.FLUIDS.simulateExtract(stack, this.amount);
            return extracted == this.amount && fluidInformation.get().fluid().m_205067_(this.fluidTag);
        }
        return false;
    }

    public List<ItemStack> getMatchingStacks() {
        if (this.itemStacks == null) {
            this.itemStacks = new ArrayList<ItemStack>();
            ArrayList fluids = Lists.newArrayList();
            BuiltInRegistries.f_257020_.m_206058_(this.fluidTag).forEach(f -> fluids.add((Fluid)f.m_203334_()));
            ArrayList items = Lists.newArrayList();
            BuiltInRegistries.f_257033_.m_206058_(LibCommonTags.Items.FLUID_CONTAINERS).forEach(i -> items.add((Item)i.m_203334_()));
            for (Fluid fluid : fluids) {
                for (Item itm : items) {
                    ItemStack stack = new ItemStack((ItemLike)itm);
                    Services.FLUIDS.get(stack).ifPresent(itemFluid -> {
                        if (itemFluid.fluid().m_6212_(fluid) && itemFluid.amount() >= Services.FLUIDS.getBucketAmount() && this.itemStacks.stream().noneMatch(i -> ItemStack.m_41746_((ItemStack)i, (ItemStack)stack))) {
                            this.itemStacks.add(stack);
                        }
                    });
                }
            }
        }
        return this.itemStacks;
    }

    public void invalidate() {
        this.itemStacks = null;
    }

    public static abstract class Serializer<T extends LibFluidIngredient> {
        public ResourceLocation getIdentifier() {
            return new ResourceLocation("assortedlib", "stored_fluid_ingredient");
        }

        public T read(JsonObject json) {
            TagKey itemTag = null;
            if (json.has("item")) {
                ResourceLocation itemLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"item"));
                itemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)itemLocation);
            }
            ResourceLocation fluidLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
            TagKey fluidTag = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)fluidLocation);
            long amount = Services.FLUIDS.getBucketAmount();
            if (json.has("amount")) {
                amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
            }
            if (fluidTag == null) {
                throw new JsonSyntaxException("Must set 'fluid'");
            }
            return this.create((TagKey<Item>)itemTag, (TagKey<Fluid>)fluidTag, amount);
        }

        public void write(JsonObject output, T ingredient) {
            if (((LibFluidIngredient)ingredient).itemTag != null) {
                output.addProperty("item", ((LibFluidIngredient)ingredient).itemTag.f_203868_().toString());
            }
            output.addProperty("fluid", ((LibFluidIngredient)ingredient).fluidTag.f_203868_().toString());
            if (((LibFluidIngredient)ingredient).amount > 0L) {
                output.addProperty("amount", (Number)((LibFluidIngredient)ingredient).amount);
            }
        }

        public T read(FriendlyByteBuf buf) {
            boolean hasItemTag = buf.readBoolean();
            TagKey itemTag = null;
            if (hasItemTag) {
                itemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)buf.m_130281_());
            }
            TagKey fluidTag = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)buf.m_130281_());
            long amount = buf.readLong();
            return this.create((TagKey<Item>)itemTag, (TagKey<Fluid>)fluidTag, amount);
        }

        public void write(FriendlyByteBuf buf, T ingredient) {
            if (((LibFluidIngredient)ingredient).itemTag != null) {
                buf.writeBoolean(true);
                buf.m_130085_(((LibFluidIngredient)ingredient).itemTag.f_203868_());
            } else {
                buf.writeBoolean(false);
            }
            buf.m_130085_(((LibFluidIngredient)ingredient).fluidTag.f_203868_());
            buf.writeLong(((LibFluidIngredient)ingredient).amount);
        }

        protected abstract T create(@Nullable TagKey<Item> var1, TagKey<Fluid> var2, long var3);
    }
}

