/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.core.inventory.impl;

import com.grim3212.assorted.lib.LibConstants;
import com.grim3212.assorted.lib.core.inventory.IItemStorageHandler;
import com.grim3212.assorted.lib.platform.Services;
import com.grim3212.assorted.lib.util.ITagSerializable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStackStorageHandler
implements IItemStorageHandler,
ITagSerializable<CompoundTag> {
    protected NonNullList<ItemStack> stacks;

    public ItemStackStorageHandler() {
        this(1);
    }

    public ItemStackStorageHandler(int size) {
        this.stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
    }

    public ItemStackStorageHandler(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public void setSize(int size) {
        this.stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
    }

    @Override
    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    @Override
    public int getSlots() {
        return this.stacks.size();
    }

    @Override
    @NotNull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this.stacks.get(slot);
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.m_41619_()) {
            if (!Services.INVENTORY.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41619_()) {
                this.setStackInSlot(slot, reachedLimit ? Services.INVENTORY.copyStackWithSize(stack, limit) : stack);
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
                this.onContentsChanged(slot);
            }
        }
        return reachedLimit ? Services.INVENTORY.copyStackWithSize(stack, stack.m_41613_() - limit) : ItemStack.f_41583_;
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, ItemStack.f_41583_);
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            this.setStackInSlot(slot, Services.INVENTORY.copyStackWithSize(existing, existing.m_41613_() - toExtract));
        }
        return Services.INVENTORY.copyStackWithSize(existing, toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @NotNull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.m_41741_());
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    @Override
    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            ((ItemStack)this.stacks.get(i)).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_("Size", this.stacks.size());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size());
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected void onLoad() {
    }

    @Override
    public void onContentsChanged(int slot) {
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty() || this.stacks.stream().allMatch(x -> x.m_41619_());
    }

    public void setStacks(NonNullList<ItemStack> stacks) {
        if (stacks.size() < this.stacks.size()) {
            NonNullList newStacks = NonNullList.m_122780_((int)this.stacks.size(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < stacks.size(); ++i) {
                if (i < stacks.size()) {
                    newStacks.set(i, (Object)((ItemStack)stacks.get(i)));
                    continue;
                }
                newStacks.set(i, (Object)ItemStack.f_41583_);
            }
            this.stacks = newStacks;
        } else if (stacks.size() > this.stacks.size()) {
            LibConstants.LOG.warn("Can't try to set more stacks than slots");
        } else {
            this.stacks = stacks;
        }
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }
}

