/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.core.inventory.impl;

import com.grim3212.assorted.lib.core.inventory.impl.ItemStackStorageHandler;
import com.grim3212.assorted.lib.core.inventory.locking.ILockable;
import com.grim3212.assorted.lib.core.inventory.locking.LockedStorageHandler;
import com.grim3212.assorted.lib.platform.Services;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class LockedItemStackStorageHandler
extends ItemStackStorageHandler
implements LockedStorageHandler {
    private final ILockable lockable;

    public LockedItemStackStorageHandler(ILockable lockable, int size) {
        this.stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        this.lockable = lockable;
    }

    public LockedItemStackStorageHandler(ILockable lockable, NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
        this.lockable = lockable;
    }

    private boolean codeMatches(String s) {
        return !this.lockable.isLocked() || this.lockable.getLockCode().equals(s);
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.insertItem(slot, stack, simulate, "", false);
    }

    @Override
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate, String inLockCode, boolean ignoreLock) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(slot, stack) || !this.codeMatches(inLockCode) && !ignoreLock) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.m_41619_()) {
            if (!Services.INVENTORY.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41619_()) {
                this.stacks.set(slot, (Object)(reachedLimit ? Services.INVENTORY.copyStackWithSize(stack, limit) : stack));
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? Services.INVENTORY.copyStackWithSize(stack, stack.m_41613_() - limit) : ItemStack.f_41583_;
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractItem(slot, amount, simulate, "", false);
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate, String inLockCode, boolean ignoreLock) {
        if (amount == 0 || !this.codeMatches(inLockCode) && !ignoreLock) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.f_41583_);
                this.onContentsChanged(slot);
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)Services.INVENTORY.copyStackWithSize(existing, existing.m_41613_() - toExtract));
            this.onContentsChanged(slot);
        }
        return Services.INVENTORY.copyStackWithSize(existing, toExtract);
    }
}

