/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.core.inventory.locking;

import com.grim3212.assorted.lib.core.inventory.IItemStorageHandler;
import com.grim3212.assorted.lib.core.inventory.impl.ItemStackStorageHandler;
import com.grim3212.assorted.lib.core.inventory.locking.ILockable;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StorageUtil {
    public static void writeLock(CompoundTag nbt, String lock) {
        if (!lock.isEmpty()) {
            nbt.m_128359_("Storage_Lock", lock);
        }
    }

    public static String readLock(CompoundTag nbt) {
        if (nbt == null) {
            return "";
        }
        return nbt.m_128425_("Storage_Lock", 8) ? nbt.m_128461_("Storage_Lock") : "";
    }

    public static ItemStack setCodeOnStack(String code, ItemStack stack) {
        ItemStack output = stack.m_41777_();
        StorageUtil.writeCodeToStack(code, output);
        return output;
    }

    public static void writeCodeToStack(String code, ItemStack stack) {
        if (stack.m_41782_()) {
            StorageUtil.writeLock(stack.m_41783_(), code);
        } else {
            CompoundTag tag = new CompoundTag();
            StorageUtil.writeLock(tag, code);
            stack.m_41751_(tag);
        }
    }

    public static String getCode(BlockEntity te) {
        if (te instanceof ILockable) {
            return ((ILockable)te).getLockCode();
        }
        return "";
    }

    public static String getCode(ItemStack stack) {
        if (stack.m_41782_()) {
            return StorageUtil.readLock(stack.m_41783_());
        }
        return "";
    }

    public static boolean hasCodeWithMatch(ItemStack stack, String testCode) {
        if (testCode == null || testCode.isEmpty()) {
            return true;
        }
        String code = StorageUtil.getCode(stack);
        return !code.isEmpty() && code.equals(testCode);
    }

    public static boolean hasCode(ItemStack stack) {
        String code = StorageUtil.getCode(stack);
        return !code.isEmpty();
    }

    public static void dropContents(Level level, BlockPos pos, IItemStorageHandler storageHandler) {
        for (int slot = 0; slot < storageHandler.getSlots(); ++slot) {
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)storageHandler.getStackInSlot(slot));
        }
    }

    public static int getRedstoneSignalFromContainer(@Nullable ItemStackStorageHandler itemHandler) {
        if (itemHandler == null) {
            return 0;
        }
        int $$1 = 0;
        float $$2 = 0.0f;
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            $$2 += (float)stack.m_41613_() / (float)Math.min(itemHandler.getSlotLimit(slot), stack.m_41741_());
            ++$$1;
        }
        return Mth.m_14143_((float)(($$2 /= (float)itemHandler.getSlots()) * 14.0f)) + ($$1 > 0 ? 1 : 0);
    }
}

