/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.core.inventory.slot;

import com.grim3212.assorted.lib.core.inventory.IItemStorageHandler;
import com.grim3212.assorted.lib.core.inventory.locking.LockedStorageHandler;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SlotStorageHandler
extends Slot {
    private static Container emptyInventory = new SimpleContainer(0);
    private final IItemStorageHandler itemHandler;

    public SlotStorageHandler(IItemStorageHandler itemHandler, int slotIndex, int xPosition, int yPosition) {
        super(emptyInventory, slotIndex, xPosition, yPosition);
        this.itemHandler = itemHandler;
    }

    public boolean m_5857_(@NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return this.itemHandler.isItemValid(this.m_150661_(), stack);
    }

    @NotNull
    public ItemStack m_7993_() {
        return this.getItemHandler().getStackInSlot(this.m_150661_());
    }

    public void m_5852_(@NotNull ItemStack stack) {
        this.getItemHandler().setStackInSlot(this.m_150661_(), stack);
        this.m_6654_();
    }

    public void m_219996_(ItemStack stack) {
        this.getItemHandler().setStackInSlot(this.m_150661_(), stack);
        this.m_6654_();
    }

    public void m_40234_(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
    }

    public int m_6641_() {
        return this.itemHandler.getSlotLimit(this.m_150661_());
    }

    public int m_5866_(@NotNull ItemStack stack) {
        ItemStack maxAdd = stack.m_41777_();
        int maxInput = stack.m_41741_();
        maxAdd.m_41764_(maxInput);
        IItemStorageHandler handler = this.getItemHandler();
        ItemStack currentStack = handler.getStackInSlot(this.m_150661_());
        ItemStack remainder = this.insert(maxAdd, true);
        int current = currentStack.m_41613_();
        int added = maxInput - remainder.m_41613_();
        return Math.min(this.m_6641_(), current + added);
    }

    public boolean m_8010_(Player playerIn) {
        return !this.extract(1, true).m_41619_();
    }

    @NotNull
    public ItemStack m_6201_(int amount) {
        return this.extract(amount, false);
    }

    public IItemStorageHandler getItemHandler() {
        return this.itemHandler;
    }

    public void m_6654_() {
        this.itemHandler.onContentsChanged(this.m_150661_());
    }

    protected ItemStack insert(ItemStack test, boolean simulate) {
        IItemStorageHandler iItemStorageHandler = this.getItemHandler();
        if (iItemStorageHandler instanceof LockedStorageHandler) {
            LockedStorageHandler lockedStorageHandler = (LockedStorageHandler)((Object)iItemStorageHandler);
            return lockedStorageHandler.insertItem(this.m_150661_(), test, simulate, "", true);
        }
        return this.getItemHandler().insertItem(this.m_150661_(), test, simulate);
    }

    protected ItemStack extract(int amount, boolean simulate) {
        IItemStorageHandler iItemStorageHandler = this.getItemHandler();
        if (iItemStorageHandler instanceof LockedStorageHandler) {
            LockedStorageHandler lockedStorageHandler = (LockedStorageHandler)((Object)iItemStorageHandler);
            return lockedStorageHandler.extractItem(this.m_150661_(), amount, simulate, "", true);
        }
        return this.getItemHandler().extractItem(this.m_150661_(), amount, simulate);
    }
}

