/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.grim3212.assorted.lib.core.crafting.ingredient.LibFluidIngredient;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class ForgeFluidIngredient
extends AbstractIngredient {
    public static final Serializer SERIALIZER = new Serializer();
    protected final LibFluidIngredient fluidIngredient;

    protected ForgeFluidIngredient(LibFluidIngredient fluidIngredient) {
        this(fluidIngredient.getItemTag(), fluidIngredient.getFluidTag(), (int)fluidIngredient.getAmount());
    }

    protected ForgeFluidIngredient(@Nullable TagKey<Item> itemTag, TagKey<Fluid> fluidTag) {
        this(itemTag, fluidTag, 1000);
    }

    protected ForgeFluidIngredient(@Nullable TagKey<Item> itemTag, TagKey<Fluid> fluidTag, int amount) {
        super(itemTag != null ? Stream.of(new Ingredient.TagValue(itemTag)) : Stream.of(new Ingredient.Value[0]));
        this.fluidIngredient = new LibFluidIngredient(itemTag, fluidTag, amount);
    }

    public static ForgeFluidIngredient of(@Nullable TagKey<Item> itemTag, TagKey<Fluid> fluidTag) {
        return new ForgeFluidIngredient(itemTag, fluidTag);
    }

    public static ForgeFluidIngredient of(@Nullable TagKey<Item> itemTag, TagKey<Fluid> fluidTag, int amount) {
        return new ForgeFluidIngredient(itemTag, fluidTag, amount);
    }

    public boolean test(@Nullable ItemStack input) {
        return this.fluidIngredient.test(input);
    }

    public boolean m_43947_() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    protected void invalidate() {
        this.fluidIngredient.invalidate();
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)SERIALIZER).toString());
        SERIALIZER.write(json, this.fluidIngredient);
        return json;
    }

    public ItemStack[] m_43908_() {
        return this.fluidIngredient.getMatchingStacks().toArray(new ItemStack[0]);
    }

    public static class Serializer
    extends LibFluidIngredient.Serializer<LibFluidIngredient>
    implements IIngredientSerializer<ForgeFluidIngredient> {
        public ForgeFluidIngredient parse(JsonObject json) {
            return new ForgeFluidIngredient((LibFluidIngredient)this.read(json));
        }

        public ForgeFluidIngredient parse(FriendlyByteBuf buffer) {
            return new ForgeFluidIngredient((LibFluidIngredient)this.read(buffer));
        }

        @Override
        public void write(FriendlyByteBuf buffer, ForgeFluidIngredient ingredient) {
            this.write(buffer, ingredient.fluidIngredient);
        }

        @Override
        protected LibFluidIngredient create(@Nullable TagKey<Item> itemTag, TagKey<Fluid> fluidTag, long amount) {
            return new LibFluidIngredient(itemTag, fluidTag, amount);
        }
    }
}

