/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.data;

import com.grim3212.assorted.lib.data.LibBiomeTagProvider;
import com.grim3212.assorted.lib.data.LibBlockTagProvider;
import com.grim3212.assorted.lib.data.LibItemTagProvider;
import com.grim3212.assorted.lib.platform.Services;
import com.grim3212.assorted.lib.util.DyeHelper;
import com.grim3212.assorted.lib.util.LibCommonTags;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class LibCommonTagProvider {

    public static class BiomeTagProvider
    extends LibBiomeTagProvider {
        public BiomeTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        @Override
        public void addCommonTags(Function<TagKey<Biome>, TagsProvider.TagAppender<Biome>> tagger) {
            if (!Services.PLATFORM.getPlatformName().equals("Forge")) {
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48202_, LibCommonTags.Biomes.IS_PLAINS);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48203_, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_DRY_OVERWORLD, LibCommonTags.Biomes.IS_SANDY, LibCommonTags.Biomes.IS_DESERT);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48206_, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_CONIFEROUS);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48207_, LibCommonTags.Biomes.IS_WET_OVERWORLD, LibCommonTags.Biomes.IS_SWAMP);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48209_, LibCommonTags.Biomes.IS_HOT_NETHER, LibCommonTags.Biomes.IS_DRY_NETHER);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48210_, LibCommonTags.Biomes.IS_COLD_END, LibCommonTags.Biomes.IS_DRY_END);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48211_, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48212_, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186761_, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY, LibCommonTags.Biomes.IS_WASTELAND, LibCommonTags.Biomes.IS_PLAINS);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48215_, LibCommonTags.Biomes.IS_MUSHROOM, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48222_, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_WET_OVERWORLD, LibCommonTags.Biomes.IS_DENSE_OVERWORLD);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186769_, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_WET_OVERWORLD, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48217_, LibCommonTags.Biomes.IS_WET_OVERWORLD, LibCommonTags.Biomes.IS_SANDY);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48148_, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48151_, LibCommonTags.Biomes.IS_SPOOKY, LibCommonTags.Biomes.IS_DENSE_OVERWORLD);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48152_, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_CONIFEROUS, LibCommonTags.Biomes.IS_SNOWY);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186763_, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_CONIFEROUS);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186767_, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48157_, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48158_, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_RARE, LibCommonTags.Biomes.IS_SLOPE, LibCommonTags.Biomes.IS_PLATEAU);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48159_, LibCommonTags.Biomes.IS_SANDY, LibCommonTags.Biomes.IS_DRY_OVERWORLD);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186753_, LibCommonTags.Biomes.IS_SANDY, LibCommonTags.Biomes.IS_DRY_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_SLOPE, LibCommonTags.Biomes.IS_PLATEAU);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186754_, LibCommonTags.Biomes.IS_PLAINS, LibCommonTags.Biomes.IS_PLATEAU, LibCommonTags.Biomes.IS_SLOPE);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186755_, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_CONIFEROUS, LibCommonTags.Biomes.IS_SNOWY, LibCommonTags.Biomes.IS_SLOPE);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186756_, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY, LibCommonTags.Biomes.IS_SLOPE);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186758_, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY, LibCommonTags.Biomes.IS_PEAK);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186757_, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY, LibCommonTags.Biomes.IS_PEAK);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186759_, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_PEAK);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48162_, LibCommonTags.Biomes.IS_COLD_END, LibCommonTags.Biomes.IS_DRY_END);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48163_, LibCommonTags.Biomes.IS_COLD_END, LibCommonTags.Biomes.IS_DRY_END);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48164_, LibCommonTags.Biomes.IS_COLD_END, LibCommonTags.Biomes.IS_DRY_END);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48165_, LibCommonTags.Biomes.IS_COLD_END, LibCommonTags.Biomes.IS_DRY_END);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48166_, LibCommonTags.Biomes.IS_HOT_OVERWORLD);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48168_, LibCommonTags.Biomes.IS_COLD_OVERWORLD);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48171_, LibCommonTags.Biomes.IS_COLD_OVERWORLD);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48172_, LibCommonTags.Biomes.IS_COLD_OVERWORLD);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48173_, LibCommonTags.Biomes.IS_VOID);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48176_, LibCommonTags.Biomes.IS_PLAINS, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186766_, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48179_, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48182_, LibCommonTags.Biomes.IS_COLD_OVERWORLD, LibCommonTags.Biomes.IS_SNOWY, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186762_, LibCommonTags.Biomes.IS_DENSE_OVERWORLD, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186764_, LibCommonTags.Biomes.IS_DENSE_OVERWORLD, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_186768_, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_DRY_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48194_, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_DRY_OVERWORLD, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48197_, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_WET_OVERWORLD, LibCommonTags.Biomes.IS_RARE);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_151785_, LibCommonTags.Biomes.IS_CAVE, LibCommonTags.Biomes.IS_LUSH, LibCommonTags.Biomes.IS_WET_OVERWORLD);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_151784_, LibCommonTags.Biomes.IS_CAVE, LibCommonTags.Biomes.IS_SPARSE_OVERWORLD);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48199_, LibCommonTags.Biomes.IS_HOT_NETHER, LibCommonTags.Biomes.IS_DRY_NETHER);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48200_, LibCommonTags.Biomes.IS_HOT_NETHER, LibCommonTags.Biomes.IS_DRY_NETHER);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48201_, LibCommonTags.Biomes.IS_HOT_NETHER, LibCommonTags.Biomes.IS_DRY_NETHER);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_48175_, LibCommonTags.Biomes.IS_HOT_NETHER, LibCommonTags.Biomes.IS_DRY_NETHER);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_220595_, LibCommonTags.Biomes.IS_WET_OVERWORLD, LibCommonTags.Biomes.IS_HOT_OVERWORLD, LibCommonTags.Biomes.IS_SWAMP);
                this.tagAll(tagger, (ResourceKey<Biome>)Biomes.f_220594_, LibCommonTags.Biomes.IS_CAVE, LibCommonTags.Biomes.IS_RARE, LibCommonTags.Biomes.IS_SPOOKY);
                tagger.apply(LibCommonTags.Biomes.IS_HOT).m_206428_(LibCommonTags.Biomes.IS_HOT_OVERWORLD).m_206428_(LibCommonTags.Biomes.IS_HOT_NETHER).m_176841_(LibCommonTags.Biomes.IS_HOT_END.f_203868_());
                tagger.apply(LibCommonTags.Biomes.IS_COLD).m_206428_(LibCommonTags.Biomes.IS_COLD_OVERWORLD).m_176841_(LibCommonTags.Biomes.IS_COLD_NETHER.f_203868_()).m_206428_(LibCommonTags.Biomes.IS_COLD_END);
                tagger.apply(LibCommonTags.Biomes.IS_SPARSE).m_206428_(LibCommonTags.Biomes.IS_SPARSE_OVERWORLD).m_176841_(LibCommonTags.Biomes.IS_SPARSE_NETHER.f_203868_()).m_176841_(LibCommonTags.Biomes.IS_SPARSE_END.f_203868_());
                tagger.apply(LibCommonTags.Biomes.IS_DENSE).m_206428_(LibCommonTags.Biomes.IS_DENSE_OVERWORLD).m_176841_(LibCommonTags.Biomes.IS_DENSE_NETHER.f_203868_()).m_176841_(LibCommonTags.Biomes.IS_DENSE_END.f_203868_());
                tagger.apply(LibCommonTags.Biomes.IS_WET).m_206428_(LibCommonTags.Biomes.IS_WET_OVERWORLD).m_176841_(LibCommonTags.Biomes.IS_WET_NETHER.f_203868_()).m_176841_(LibCommonTags.Biomes.IS_WET_END.f_203868_());
                tagger.apply(LibCommonTags.Biomes.IS_DRY).m_206428_(LibCommonTags.Biomes.IS_DRY_OVERWORLD).m_206428_(LibCommonTags.Biomes.IS_DRY_NETHER).m_206428_(LibCommonTags.Biomes.IS_DRY_END);
                tagger.apply(LibCommonTags.Biomes.IS_WATER).m_176841_(BiomeTags.f_207603_.f_203868_()).m_176841_(BiomeTags.f_207605_.f_203868_());
                tagger.apply(LibCommonTags.Biomes.IS_MOUNTAIN).m_206428_(LibCommonTags.Biomes.IS_PEAK).m_206428_(LibCommonTags.Biomes.IS_SLOPE);
                tagger.apply(LibCommonTags.Biomes.IS_UNDERGROUND).m_206428_(LibCommonTags.Biomes.IS_CAVE);
            }
        }
    }

    public static class ItemTagProvider
    extends LibItemTagProvider {
        public ItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup, TagsProvider<Block> blockTags) {
            super(output, lookup, blockTags);
        }

        @Override
        public void addCommonTags(Function<TagKey<Item>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tagger, BiConsumer<TagKey<Block>, TagKey<Item>> copier) {
            if (!Services.PLATFORM.getPlatformName().equals("Forge")) {
                copier.accept(LibCommonTags.Blocks.STONE, LibCommonTags.Items.STONE);
                for (DyeColor dyeColor : DyeColor.values()) {
                    TagKey<Item> dyeTag = DyeHelper.getDyeTag(dyeColor);
                    tagger.apply(LibCommonTags.Items.DYES).m_206428_(dyeTag);
                    tagger.apply(dyeTag).m_255245_((Object)DyeItem.m_41082_((DyeColor)dyeColor));
                }
                copier.accept(LibCommonTags.Blocks.BARRELS, LibCommonTags.Items.BARRELS);
                copier.accept(LibCommonTags.Blocks.BARRELS_WOODEN, LibCommonTags.Items.BARRELS_WOODEN);
                tagger.apply(LibCommonTags.Items.BONES).m_255245_((Object)Items.f_42500_);
                copier.accept(LibCommonTags.Blocks.BOOKSHELVES, LibCommonTags.Items.BOOKSHELVES);
                copier.accept(LibCommonTags.Blocks.CHESTS, LibCommonTags.Items.CHESTS);
                copier.accept(LibCommonTags.Blocks.CHESTS_ENDER, LibCommonTags.Items.CHESTS_ENDER);
                copier.accept(LibCommonTags.Blocks.CHESTS_TRAPPED, LibCommonTags.Items.CHESTS_TRAPPED);
                copier.accept(LibCommonTags.Blocks.CHESTS_WOODEN, LibCommonTags.Items.CHESTS_WOODEN);
                copier.accept(LibCommonTags.Blocks.COBBLESTONE, LibCommonTags.Items.COBBLESTONE);
                tagger.apply(LibCommonTags.Items.DUSTS).m_206428_(LibCommonTags.Items.DUSTS_GLOWSTONE);
                tagger.apply(LibCommonTags.Items.DUSTS).m_206428_(LibCommonTags.Items.DUSTS_PRISMARINE);
                tagger.apply(LibCommonTags.Items.DUSTS).m_206428_(LibCommonTags.Items.DUSTS_REDSTONE);
                tagger.apply(LibCommonTags.Items.DUSTS_GLOWSTONE).m_255245_((Object)Items.f_42525_);
                tagger.apply(LibCommonTags.Items.DUSTS_PRISMARINE).m_255245_((Object)Items.f_42695_);
                tagger.apply(LibCommonTags.Items.DUSTS_REDSTONE).m_255245_((Object)Items.f_42451_);
                tagger.apply(LibCommonTags.Items.EGGS).m_255245_((Object)Items.f_42521_);
                copier.accept(LibCommonTags.Blocks.END_STONES, LibCommonTags.Items.END_STONES);
                tagger.apply(LibCommonTags.Items.ENDER_PEARLS).m_255245_((Object)Items.f_42584_);
                tagger.apply(LibCommonTags.Items.FEATHERS).m_255245_((Object)Items.f_42402_);
                copier.accept(LibCommonTags.Blocks.FENCE_GATES, LibCommonTags.Items.FENCE_GATES);
                copier.accept(LibCommonTags.Blocks.FENCE_GATES_WOODEN, LibCommonTags.Items.FENCE_GATES_WOODEN);
                copier.accept(LibCommonTags.Blocks.FENCES, LibCommonTags.Items.FENCES);
                copier.accept(LibCommonTags.Blocks.FENCES_NETHER_BRICK, LibCommonTags.Items.FENCES_NETHER_BRICK);
                copier.accept(LibCommonTags.Blocks.FENCES_WOODEN, LibCommonTags.Items.FENCES_WOODEN);
                List<TagKey> gemTags = Arrays.asList(LibCommonTags.Items.GEMS_AMETHYST, LibCommonTags.Items.GEMS_DIAMOND, LibCommonTags.Items.GEMS_EMERALD, LibCommonTags.Items.GEMS_LAPIS, LibCommonTags.Items.GEMS_PRISMARINE, LibCommonTags.Items.GEMS_QUARTZ);
                for (TagKey gemTag : gemTags) {
                    tagger.apply(LibCommonTags.Items.GEMS).m_206428_(gemTag);
                }
                tagger.apply(LibCommonTags.Items.GEMS_AMETHYST).m_255245_((Object)Items.f_151049_);
                tagger.apply(LibCommonTags.Items.GEMS_DIAMOND).m_255245_((Object)Items.f_42415_);
                tagger.apply(LibCommonTags.Items.GEMS_EMERALD).m_255245_((Object)Items.f_42616_);
                tagger.apply(LibCommonTags.Items.GEMS_LAPIS).m_255245_((Object)Items.f_42534_);
                tagger.apply(LibCommonTags.Items.GEMS_PRISMARINE).m_255245_((Object)Items.f_42696_);
                tagger.apply(LibCommonTags.Items.GEMS_QUARTZ).m_255245_((Object)Items.f_42692_);
                copier.accept(LibCommonTags.Blocks.GRAVEL, LibCommonTags.Items.GRAVEL);
                tagger.apply(LibCommonTags.Items.GUNPOWDER).m_255245_((Object)Items.f_42403_);
                List<TagKey> ingotTags = Arrays.asList(LibCommonTags.Items.INGOTS_BRICK, LibCommonTags.Items.INGOTS_COPPER, LibCommonTags.Items.INGOTS_GOLD, LibCommonTags.Items.INGOTS_IRON, LibCommonTags.Items.INGOTS_NETHERITE, LibCommonTags.Items.INGOTS_NETHER_BRICK);
                for (TagKey tagKey : ingotTags) {
                    tagger.apply(LibCommonTags.Items.INGOTS).m_206428_(tagKey);
                }
                tagger.apply(LibCommonTags.Items.INGOTS_BRICK).m_255245_((Object)Items.f_42460_);
                tagger.apply(LibCommonTags.Items.INGOTS_COPPER).m_255245_((Object)Items.f_151052_);
                tagger.apply(LibCommonTags.Items.INGOTS_GOLD).m_255245_((Object)Items.f_42417_);
                tagger.apply(LibCommonTags.Items.INGOTS_IRON).m_255245_((Object)Items.f_42416_);
                tagger.apply(LibCommonTags.Items.INGOTS_NETHERITE).m_255245_((Object)Items.f_42418_);
                tagger.apply(LibCommonTags.Items.INGOTS_NETHER_BRICK).m_255245_((Object)Items.f_42691_);
                tagger.apply(LibCommonTags.Items.LEATHER).m_255245_((Object)Items.f_42454_);
                tagger.apply(LibCommonTags.Items.NETHER_STARS).m_255245_((Object)Items.f_42686_);
                copier.accept(LibCommonTags.Blocks.NETHERRACK, LibCommonTags.Items.NETHERRACK);
                tagger.apply(LibCommonTags.Items.NUGGETS).m_206428_(LibCommonTags.Items.NUGGETS_GOLD);
                tagger.apply(LibCommonTags.Items.NUGGETS).m_206428_(LibCommonTags.Items.NUGGETS_IRON);
                tagger.apply(LibCommonTags.Items.NUGGETS_IRON).m_255245_((Object)Items.f_42749_);
                tagger.apply(LibCommonTags.Items.NUGGETS_GOLD).m_255245_((Object)Items.f_42587_);
                copier.accept(LibCommonTags.Blocks.OBSIDIAN, LibCommonTags.Items.OBSIDIAN);
                copier.accept(LibCommonTags.Blocks.ORES, LibCommonTags.Items.ORES);
                copier.accept(LibCommonTags.Blocks.ORES_COAL, LibCommonTags.Items.ORES_COAL);
                copier.accept(LibCommonTags.Blocks.ORES_COPPER, LibCommonTags.Items.ORES_COPPER);
                copier.accept(LibCommonTags.Blocks.ORES_DIAMOND, LibCommonTags.Items.ORES_DIAMOND);
                copier.accept(LibCommonTags.Blocks.ORES_EMERALD, LibCommonTags.Items.ORES_EMERALD);
                copier.accept(LibCommonTags.Blocks.ORES_GOLD, LibCommonTags.Items.ORES_GOLD);
                copier.accept(LibCommonTags.Blocks.ORES_IRON, LibCommonTags.Items.ORES_IRON);
                copier.accept(LibCommonTags.Blocks.ORES_LAPIS, LibCommonTags.Items.ORES_LAPIS);
                copier.accept(LibCommonTags.Blocks.ORES_QUARTZ, LibCommonTags.Items.ORES_QUARTZ);
                copier.accept(LibCommonTags.Blocks.ORES_REDSTONE, LibCommonTags.Items.ORES_REDSTONE);
                copier.accept(LibCommonTags.Blocks.ORES_NETHERITE_SCRAP, LibCommonTags.Items.ORES_NETHERITE_SCRAP);
                tagger.apply(LibCommonTags.Items.RAW_MATERIALS).m_206428_(LibCommonTags.Items.RAW_MATERIALS_COPPER);
                tagger.apply(LibCommonTags.Items.RAW_MATERIALS).m_206428_(LibCommonTags.Items.RAW_MATERIALS_GOLD);
                tagger.apply(LibCommonTags.Items.RAW_MATERIALS).m_206428_(LibCommonTags.Items.RAW_MATERIALS_IRON);
                tagger.apply(LibCommonTags.Items.RAW_MATERIALS_COPPER).m_255245_((Object)Items.f_151051_);
                tagger.apply(LibCommonTags.Items.RAW_MATERIALS_GOLD).m_255245_((Object)Items.f_151053_);
                tagger.apply(LibCommonTags.Items.RAW_MATERIALS_IRON).m_255245_((Object)Items.f_151050_);
                tagger.apply(LibCommonTags.Items.RODS).m_206428_(LibCommonTags.Items.RODS_WOODEN);
                tagger.apply(LibCommonTags.Items.RODS).m_206428_(LibCommonTags.Items.RODS_BLAZE);
                tagger.apply(LibCommonTags.Items.RODS_BLAZE).m_255245_((Object)Items.f_42585_);
                tagger.apply(LibCommonTags.Items.RODS_WOODEN).m_255245_((Object)Items.f_42398_);
                tagger.apply(LibCommonTags.Items.SHEARS).m_255245_((Object)Items.f_42574_);
                tagger.apply(LibCommonTags.Items.SLIMEBALLS).m_255245_((Object)Items.f_42518_);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS, LibCommonTags.Items.STORAGE_BLOCKS);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_AMETHYST, LibCommonTags.Items.STORAGE_BLOCKS_AMETHYST);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_COAL, LibCommonTags.Items.STORAGE_BLOCKS_COAL);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_COPPER, LibCommonTags.Items.STORAGE_BLOCKS_COPPER);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_DIAMOND, LibCommonTags.Items.STORAGE_BLOCKS_DIAMOND);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_EMERALD, LibCommonTags.Items.STORAGE_BLOCKS_EMERALD);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_GOLD, LibCommonTags.Items.STORAGE_BLOCKS_GOLD);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_IRON, LibCommonTags.Items.STORAGE_BLOCKS_IRON);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_LAPIS, LibCommonTags.Items.STORAGE_BLOCKS_LAPIS);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_QUARTZ, LibCommonTags.Items.STORAGE_BLOCKS_QUARTZ);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_REDSTONE, LibCommonTags.Items.STORAGE_BLOCKS_REDSTONE);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_COPPER, LibCommonTags.Items.STORAGE_BLOCKS_RAW_COPPER);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_GOLD, LibCommonTags.Items.STORAGE_BLOCKS_RAW_GOLD);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_IRON, LibCommonTags.Items.STORAGE_BLOCKS_RAW_IRON);
                copier.accept(LibCommonTags.Blocks.STORAGE_BLOCKS_NETHERITE, LibCommonTags.Items.STORAGE_BLOCKS_NETHERITE);
                tagger.apply(LibCommonTags.Items.STRING).m_255245_((Object)Items.f_42401_);
                tagger.apply(LibCommonTags.Items.TOOLS_SWORDS).m_255179_((Object[])new Item[]{Items.f_42420_, Items.f_42425_, Items.f_42383_, Items.f_42430_, Items.f_42388_, Items.f_42393_});
                tagger.apply(LibCommonTags.Items.TOOLS_AXES).m_255179_((Object[])new Item[]{Items.f_42423_, Items.f_42428_, Items.f_42386_, Items.f_42433_, Items.f_42391_, Items.f_42396_});
                tagger.apply(LibCommonTags.Items.TOOLS_PICKAXES).m_255179_((Object[])new Item[]{Items.f_42422_, Items.f_42427_, Items.f_42385_, Items.f_42432_, Items.f_42390_, Items.f_42395_});
                tagger.apply(LibCommonTags.Items.TOOLS_SHOVELS).m_255179_((Object[])new Item[]{Items.f_42421_, Items.f_42426_, Items.f_42384_, Items.f_42431_, Items.f_42389_, Items.f_42394_});
                tagger.apply(LibCommonTags.Items.TOOLS_HOES).m_255179_((Object[])new Item[]{Items.f_42424_, Items.f_42429_, Items.f_42387_, Items.f_42434_, Items.f_42392_, Items.f_42397_});
                tagger.apply(LibCommonTags.Items.TOOLS_SHIELDS).m_255245_((Object)Items.f_42740_);
                tagger.apply(LibCommonTags.Items.TOOLS_BOWS).m_255245_((Object)Items.f_42411_);
                tagger.apply(LibCommonTags.Items.TOOLS_CROSSBOWS).m_255245_((Object)Items.f_42717_);
                tagger.apply(LibCommonTags.Items.TOOLS_FISHING_RODS).m_255245_((Object)Items.f_42523_);
                tagger.apply(LibCommonTags.Items.TOOLS_TRIDENTS).m_255245_((Object)Items.f_42713_);
                List<TagKey> toolTags = Arrays.asList(LibCommonTags.Items.TOOLS_SWORDS, LibCommonTags.Items.TOOLS_AXES, LibCommonTags.Items.TOOLS_PICKAXES, LibCommonTags.Items.TOOLS_SHOVELS, LibCommonTags.Items.TOOLS_HOES, LibCommonTags.Items.TOOLS_SHIELDS, LibCommonTags.Items.TOOLS_BOWS, LibCommonTags.Items.TOOLS_CROSSBOWS, LibCommonTags.Items.TOOLS_FISHING_RODS, LibCommonTags.Items.TOOLS_TRIDENTS);
                for (TagKey toolTag : toolTags) {
                    tagger.apply(LibCommonTags.Items.TOOLS).m_206428_(toolTag);
                }
                tagger.apply(LibCommonTags.Items.ARMORS_HELMETS).m_255179_((Object[])new Item[]{Items.f_42407_, Items.f_42354_, Items.f_42464_, Items.f_42468_, Items.f_42476_, Items.f_42472_, Items.f_42480_});
                tagger.apply(LibCommonTags.Items.ARMORS_CHESTPLATES).m_255179_((Object[])new Item[]{Items.f_42408_, Items.f_42465_, Items.f_42469_, Items.f_42477_, Items.f_42473_, Items.f_42481_});
                tagger.apply(LibCommonTags.Items.ARMORS_LEGGINGS).m_255179_((Object[])new Item[]{Items.f_42462_, Items.f_42466_, Items.f_42470_, Items.f_42478_, Items.f_42474_, Items.f_42482_});
                tagger.apply(LibCommonTags.Items.ARMORS_BOOTS).m_255179_((Object[])new Item[]{Items.f_42463_, Items.f_42467_, Items.f_42471_, Items.f_42479_, Items.f_42475_, Items.f_42483_});
                List<TagKey> list = Arrays.asList(LibCommonTags.Items.ARMORS_HELMETS, LibCommonTags.Items.ARMORS_CHESTPLATES, LibCommonTags.Items.ARMORS_LEGGINGS, LibCommonTags.Items.ARMORS_BOOTS);
                for (TagKey armorTag : list) {
                    tagger.apply(LibCommonTags.Items.ARMORS).m_206428_(armorTag);
                }
                copier.accept(LibCommonTags.Blocks.GLASS, LibCommonTags.Items.GLASS);
                copier.accept(LibCommonTags.Blocks.GLASS_TINTED, LibCommonTags.Items.GLASS_TINTED);
                copier.accept(LibCommonTags.Blocks.GLASS_PANES, LibCommonTags.Items.GLASS_PANES);
                this.copyColored(LibCommonTags.Blocks.GLASS, LibCommonTags.Items.GLASS, copier);
                this.copyColored(LibCommonTags.Blocks.GLASS_PANES, LibCommonTags.Items.GLASS_PANES, copier);
                tagger.apply(LibCommonTags.Items.CROPS).m_206428_(LibCommonTags.Items.CROPS_BEETROOT).m_206428_(LibCommonTags.Items.CROPS_CARROT).m_206428_(LibCommonTags.Items.CROPS_NETHER_WART).m_206428_(LibCommonTags.Items.CROPS_POTATO).m_206428_(LibCommonTags.Items.CROPS_WHEAT);
                tagger.apply(LibCommonTags.Items.CROPS_BEETROOT).m_255245_((Object)Items.f_42732_);
                tagger.apply(LibCommonTags.Items.CROPS_CARROT).m_255245_((Object)Items.f_42619_);
                tagger.apply(LibCommonTags.Items.CROPS_NETHER_WART).m_255245_((Object)Items.f_42588_);
                tagger.apply(LibCommonTags.Items.CROPS_POTATO).m_255245_((Object)Items.f_42620_);
                tagger.apply(LibCommonTags.Items.CROPS_WHEAT).m_255245_((Object)Items.f_42405_);
            }
            copier.accept(LibCommonTags.Blocks.CONCRETE, LibCommonTags.Items.CONCRETE);
            copier.accept(LibCommonTags.Blocks.CONCRETE_POWDER, LibCommonTags.Items.CONCRETE_POWDER);
            copier.accept(LibCommonTags.Blocks.CARPET, LibCommonTags.Items.CARPET);
            tagger.apply(LibCommonTags.Items.FLUID_CONTAINERS).m_255179_((Object[])new Item[]{Items.f_42446_, Items.f_42447_, Items.f_42448_});
            tagger.apply(LibCommonTags.Items.BUCKETS_MILK).m_255245_((Object)Items.f_42455_);
        }

        private void copyColored(TagKey<Block> blockGroup, TagKey<Item> itemGroup, BiConsumer<TagKey<Block>, TagKey<Item>> copier) {
            String blockPre = blockGroup.f_203868_().m_135815_().toUpperCase(Locale.ENGLISH) + "_";
            String itemPre = itemGroup.f_203868_().m_135815_().toUpperCase(Locale.ENGLISH) + "_";
            for (DyeColor color : DyeColor.values()) {
                TagKey<Block> from = this.getCommonBlockTag(blockPre + color.m_41065_());
                TagKey<Item> to = this.getCommonItemTag(itemPre + color.m_41065_());
                copier.accept(from, to);
            }
            copier.accept(this.getCommonBlockTag(blockPre + "colorless"), this.getCommonItemTag(itemPre + "colorless"));
        }

        private TagKey<Block> getCommonBlockTag(String name) {
            try {
                name = name.toUpperCase(Locale.ENGLISH);
                return (TagKey)LibCommonTags.Blocks.class.getDeclaredField(name).get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new IllegalStateException(LibCommonTags.Blocks.class.getName() + " is missing tag name: " + name);
            }
        }

        private TagKey<Item> getCommonItemTag(String name) {
            try {
                name = name.toUpperCase(Locale.ENGLISH);
                return (TagKey)LibCommonTags.Items.class.getDeclaredField(name).get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new IllegalStateException(LibCommonTags.Items.class.getName() + " is missing tag name: " + name);
            }
        }
    }

    public static class BlockTagProvider
    extends LibBlockTagProvider {
        public BlockTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup) {
            super(packOutput, lookup);
        }

        @Override
        public void addCommonTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagger) {
            if (!Services.PLATFORM.getPlatformName().equals("Forge")) {
                tagger.apply(LibCommonTags.Blocks.BARRELS).m_206428_(LibCommonTags.Blocks.BARRELS_WOODEN);
                tagger.apply(LibCommonTags.Blocks.BARRELS_WOODEN).m_255245_((Object)Blocks.f_50618_);
                tagger.apply(LibCommonTags.Blocks.BOOKSHELVES).m_255245_((Object)Blocks.f_50078_);
                tagger.apply(LibCommonTags.Blocks.CHESTS).m_206428_(LibCommonTags.Blocks.CHESTS_ENDER);
                tagger.apply(LibCommonTags.Blocks.CHESTS).m_206428_(LibCommonTags.Blocks.CHESTS_TRAPPED);
                tagger.apply(LibCommonTags.Blocks.CHESTS).m_206428_(LibCommonTags.Blocks.CHESTS_WOODEN);
                tagger.apply(LibCommonTags.Blocks.CHESTS_ENDER).m_255245_((Object)Blocks.f_50265_);
                tagger.apply(LibCommonTags.Blocks.CHESTS_TRAPPED).m_255245_((Object)Blocks.f_50325_);
                tagger.apply(LibCommonTags.Blocks.CHESTS_WOODEN).m_255179_((Object[])new Block[]{Blocks.f_50087_, Blocks.f_50325_});
                tagger.apply(LibCommonTags.Blocks.COBBLESTONE).m_255179_((Object[])new Block[]{Blocks.f_50652_, Blocks.f_50227_, Blocks.f_50079_, Blocks.f_152551_});
                tagger.apply(LibCommonTags.Blocks.END_STONES).m_255245_((Object)Blocks.f_50259_);
                tagger.apply(LibCommonTags.Blocks.FENCE_GATES).m_206428_(LibCommonTags.Blocks.FENCE_GATES_WOODEN);
                tagger.apply(LibCommonTags.Blocks.FENCE_GATES_WOODEN).m_255179_((Object[])new Block[]{Blocks.f_50192_, Blocks.f_50474_, Blocks.f_50475_, Blocks.f_50476_, Blocks.f_50477_, Blocks.f_50478_, Blocks.f_50665_, Blocks.f_50666_, Blocks.f_220850_});
                tagger.apply(LibCommonTags.Blocks.FENCES).m_206428_(LibCommonTags.Blocks.FENCES_WOODEN);
                tagger.apply(LibCommonTags.Blocks.FENCES).m_206428_(LibCommonTags.Blocks.FENCES_NETHER_BRICK);
                tagger.apply(LibCommonTags.Blocks.FENCES_NETHER_BRICK).m_255245_((Object)Blocks.f_50198_);
                tagger.apply(LibCommonTags.Blocks.FENCES_WOODEN).m_176841_(BlockTags.f_13098_.f_203868_());
                tagger.apply(LibCommonTags.Blocks.GRAVEL).m_255245_((Object)Blocks.f_49994_);
                tagger.apply(LibCommonTags.Blocks.NETHERRACK).m_255245_((Object)Blocks.f_50134_);
                tagger.apply(LibCommonTags.Blocks.OBSIDIAN).m_255245_((Object)Blocks.f_50080_);
                List<TagKey> oreTags = Arrays.asList(LibCommonTags.Blocks.ORES_COAL, LibCommonTags.Blocks.ORES_COPPER, LibCommonTags.Blocks.ORES_DIAMOND, LibCommonTags.Blocks.ORES_EMERALD, LibCommonTags.Blocks.ORES_GOLD, LibCommonTags.Blocks.ORES_IRON, LibCommonTags.Blocks.ORES_LAPIS, LibCommonTags.Blocks.ORES_REDSTONE, LibCommonTags.Blocks.ORES_QUARTZ, LibCommonTags.Blocks.ORES_NETHERITE_SCRAP);
                for (TagKey oreTag : oreTags) {
                    tagger.apply(LibCommonTags.Blocks.ORES).m_206428_(oreTag);
                }
                tagger.apply(LibCommonTags.Blocks.ORES_COAL).m_176841_(BlockTags.f_144262_.f_203868_());
                tagger.apply(LibCommonTags.Blocks.ORES_COPPER).m_176841_(BlockTags.f_144264_.f_203868_());
                tagger.apply(LibCommonTags.Blocks.ORES_DIAMOND).m_176841_(BlockTags.f_144259_.f_203868_());
                tagger.apply(LibCommonTags.Blocks.ORES_EMERALD).m_176841_(BlockTags.f_144263_.f_203868_());
                tagger.apply(LibCommonTags.Blocks.ORES_GOLD).m_176841_(BlockTags.f_13043_.f_203868_());
                tagger.apply(LibCommonTags.Blocks.ORES_IRON).m_176841_(BlockTags.f_144258_.f_203868_());
                tagger.apply(LibCommonTags.Blocks.ORES_LAPIS).m_176841_(BlockTags.f_144261_.f_203868_());
                tagger.apply(LibCommonTags.Blocks.ORES_QUARTZ).m_255245_((Object)Blocks.f_50331_);
                tagger.apply(LibCommonTags.Blocks.ORES_REDSTONE).m_176841_(BlockTags.f_144260_.f_203868_());
                tagger.apply(LibCommonTags.Blocks.ORES_NETHERITE_SCRAP).m_255245_((Object)Blocks.f_50722_);
                tagger.apply(LibCommonTags.Blocks.STONE).m_255179_((Object[])new Block[]{Blocks.f_50334_, Blocks.f_50228_, Blocks.f_50122_, Blocks.f_50226_, Blocks.f_50069_, Blocks.f_50387_, Blocks.f_50281_, Blocks.f_50175_, Blocks.f_152550_, Blocks.f_152555_, Blocks.f_152596_, Blocks.f_152496_});
                List<TagKey> storageTags = Arrays.asList(LibCommonTags.Blocks.STORAGE_BLOCKS_AMETHYST, LibCommonTags.Blocks.STORAGE_BLOCKS_COAL, LibCommonTags.Blocks.STORAGE_BLOCKS_COPPER, LibCommonTags.Blocks.STORAGE_BLOCKS_DIAMOND, LibCommonTags.Blocks.STORAGE_BLOCKS_EMERALD, LibCommonTags.Blocks.STORAGE_BLOCKS_GOLD, LibCommonTags.Blocks.STORAGE_BLOCKS_IRON, LibCommonTags.Blocks.STORAGE_BLOCKS_LAPIS, LibCommonTags.Blocks.STORAGE_BLOCKS_QUARTZ, LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_COPPER, LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_GOLD, LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_IRON, LibCommonTags.Blocks.STORAGE_BLOCKS_REDSTONE, LibCommonTags.Blocks.STORAGE_BLOCKS_NETHERITE);
                for (TagKey storageTag : storageTags) {
                    tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS).m_206428_(storageTag);
                }
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_AMETHYST).m_255245_((Object)Blocks.f_152490_);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_COAL).m_255245_((Object)Blocks.f_50353_);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_COPPER).m_255245_((Object)Blocks.f_152504_);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_DIAMOND).m_255245_((Object)Blocks.f_50090_);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_EMERALD).m_255245_((Object)Blocks.f_50268_);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_GOLD).m_255245_((Object)Blocks.f_50074_);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_IRON).m_255245_((Object)Blocks.f_50075_);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_LAPIS).m_255245_((Object)Blocks.f_50060_);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_QUARTZ).m_255245_((Object)Blocks.f_50333_);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_COPPER).m_255245_((Object)Blocks.f_152599_);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_GOLD).m_255245_((Object)Blocks.f_152600_);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_RAW_IRON).m_255245_((Object)Blocks.f_152598_);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_REDSTONE).m_255245_((Object)Blocks.f_50330_);
                tagger.apply(LibCommonTags.Blocks.STORAGE_BLOCKS_NETHERITE).m_255245_((Object)Blocks.f_50721_);
                this.addColored(arg_0 -> tagger.apply(LibCommonTags.Blocks.STAINED_GLASS).m_255245_(arg_0), LibCommonTags.Blocks.GLASS, "{color}_stained_glass", tagger);
                this.addColored(arg_0 -> tagger.apply(LibCommonTags.Blocks.STAINED_GLASS_PANES).m_255245_(arg_0), LibCommonTags.Blocks.GLASS_PANES, "{color}_stained_glass_pane", tagger);
                tagger.apply(LibCommonTags.Blocks.GLASS).m_206428_(LibCommonTags.Blocks.GLASS_COLORLESS).m_176841_(LibCommonTags.Blocks.STAINED_GLASS.f_203868_()).m_206428_(LibCommonTags.Blocks.GLASS_TINTED);
                tagger.apply(LibCommonTags.Blocks.GLASS_COLORLESS).m_255245_((Object)Blocks.f_50058_);
                tagger.apply(LibCommonTags.Blocks.GLASS_TINTED).m_255245_((Object)Blocks.f_152498_);
                tagger.apply(LibCommonTags.Blocks.GLASS_PANES).m_206428_(LibCommonTags.Blocks.GLASS_PANES_COLORLESS).m_176841_(LibCommonTags.Blocks.STAINED_GLASS_PANES.f_203868_());
                tagger.apply(LibCommonTags.Blocks.GLASS_PANES_COLORLESS).m_255245_((Object)Blocks.f_50185_);
            }
            DyeHelper.CONCRETE_BY_DYE.entrySet().stream().forEach(x -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagger.apply(LibCommonTags.Blocks.CONCRETE)).m_255245_((Object)((Block)x.getValue())));
            DyeHelper.CONCRETE_POWDER_BY_DYE.entrySet().stream().forEach(x -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagger.apply(LibCommonTags.Blocks.CONCRETE_POWDER)).m_255245_((Object)((Block)x.getValue())));
            DyeHelper.CARPET_BY_DYE.entrySet().stream().forEach(x -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagger.apply(LibCommonTags.Blocks.CARPET)).m_255245_((Object)((Block)x.getValue())));
        }

        private void addColored(Consumer<Block> consumer, TagKey<Block> group, String pattern, Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagger) {
            String prefix = group.f_203868_().m_135815_().toUpperCase(Locale.ENGLISH) + "_";
            for (DyeColor color : DyeColor.values()) {
                ResourceLocation key = new ResourceLocation("minecraft", pattern.replace("{color}", color.m_41065_()));
                TagKey<Block> tag = this.getCommonTag(prefix + color.m_41065_());
                Block block = (Block)Services.PLATFORM.getRegistry(Registries.f_256747_).getValue(key).get();
                if (block == null || block == Blocks.f_50016_) {
                    throw new IllegalStateException("Unknown block: " + key.toString());
                }
                tagger.apply(tag).m_255245_((Object)block);
                consumer.accept(block);
            }
        }

        private TagKey<Block> getCommonTag(String name) {
            try {
                name = name.toUpperCase(Locale.ENGLISH);
                return (TagKey)LibCommonTags.Blocks.class.getDeclaredField(name).get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new IllegalStateException(LibCommonTags.Blocks.class.getName() + " is missing tag name: " + name);
            }
        }
    }
}

