/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.fluid;

import com.grim3212.assorted.lib.core.fluid.FluidInformation;
import com.grim3212.assorted.lib.core.fluid.IFluidVariantHandler;
import com.grim3212.assorted.lib.platform.ForgeFluidManager;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;

public class ForgeFluidVariantHandlerDelegate
implements IFluidVariantHandler {
    private final FluidType delegate;

    public ForgeFluidVariantHandlerDelegate(FluidType delegate) {
        this.delegate = delegate;
    }

    @Override
    public Component getName(FluidInformation fluidInformation) {
        return this.delegate.getDescription(ForgeFluidManager.buildFluidStack(fluidInformation));
    }

    @Override
    public Optional<SoundEvent> getFillSound(FluidInformation variant) {
        return Optional.ofNullable(this.delegate.getSound(ForgeFluidManager.buildFluidStack(variant), SoundActions.BUCKET_FILL));
    }

    @Override
    public Optional<SoundEvent> getEmptySound(FluidInformation variant) {
        return Optional.ofNullable(this.delegate.getSound(ForgeFluidManager.buildFluidStack(variant), SoundActions.BUCKET_EMPTY));
    }

    @Override
    public int getLuminance(FluidInformation variant) {
        return this.delegate.getLightLevel(ForgeFluidManager.buildFluidStack(variant));
    }

    @Override
    public int getTemperature(FluidInformation variant) {
        return this.delegate.getTemperature(ForgeFluidManager.buildFluidStack(variant));
    }

    @Override
    public int getViscosity(FluidInformation variant) {
        return this.delegate.getViscosity(ForgeFluidManager.buildFluidStack(variant));
    }

    @Override
    public int getDensity(FluidInformation variant) {
        return this.delegate.getDensity(ForgeFluidManager.buildFluidStack(variant));
    }

    @Override
    public int getTintColor(FluidInformation variant) {
        return IClientFluidTypeExtensions.of((FluidType)this.delegate).getTintColor(ForgeFluidManager.buildFluidStack(variant));
    }

    @Override
    public Optional<ResourceLocation> getStillTexture(FluidInformation variant) {
        return Optional.ofNullable(IClientFluidTypeExtensions.of((FluidType)this.delegate).getStillTexture(ForgeFluidManager.buildFluidStack(variant)));
    }

    @Override
    public Optional<ResourceLocation> getFlowingTexture(FluidInformation variant) {
        return Optional.ofNullable(IClientFluidTypeExtensions.of((FluidType)this.delegate).getFlowingTexture(ForgeFluidManager.buildFluidStack(variant)));
    }
}

