/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.inventory;

import com.grim3212.assorted.lib.core.inventory.IItemStorageHandler;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeWrappedItemHandler
implements IItemStorageHandler {
    private final IItemHandler storage;
    private final BlockEntity entity;

    public ForgeWrappedItemHandler(@Nullable BlockEntity entity, @NotNull IItemHandler storage) {
        this.storage = storage;
        this.entity = entity;
    }

    @Override
    public int getSlots() {
        return this.storage.getSlots();
    }

    @Override
    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.storage.getStackInSlot(slot);
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.storage.insertItem(slot, stack, simulate);
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.storage.extractItem(slot, amount, simulate);
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.storage.getSlotLimit(slot);
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.storage.isItemValid(slot, stack);
    }

    @Override
    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        IItemHandler iItemHandler = this.storage;
        if (iItemHandler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)iItemHandler;
            modifiable.setStackInSlot(slot, stack);
        }
    }

    @Override
    public void onContentsChanged(int slot) {
        if (this.entity != null) {
            this.entity.m_6596_();
        }
    }
}

