/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.mixin.client.model;

import com.grim3212.assorted.lib.client.model.data.ForgeBlockModelDataPlatformDelegate;
import com.grim3212.assorted.lib.client.model.data.IBlockModelData;
import com.grim3212.assorted.lib.core.block.IBlockEntityWithModelData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelDataManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ModelDataManager.class}, remap=false)
public abstract class ModelDataManagerMixin {
    @Redirect(method={"refreshAt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BlockEntity;getModelData()Lnet/minecraftforge/client/model/data/ModelData;"))
    private ModelData getModelDataRetrieval(BlockEntity blockEntity) {
        if (blockEntity instanceof IBlockEntityWithModelData) {
            IBlockEntityWithModelData blockEntityWithModelData = (IBlockEntityWithModelData)blockEntity;
            IBlockModelData blockModelData = blockEntityWithModelData.getBlockModelData();
            if (blockModelData == null) {
                return ModelData.EMPTY;
            }
            if (!(blockModelData instanceof ForgeBlockModelDataPlatformDelegate)) {
                throw new IllegalStateException("Block model data is not compatible with the current platform.");
            }
            ForgeBlockModelDataPlatformDelegate platformDelegate = (ForgeBlockModelDataPlatformDelegate)blockModelData;
            return platformDelegate.getDelegate();
        }
        return blockEntity.getModelData();
    }
}

