/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.google.common.collect.Maps;
import com.grim3212.assorted.lib.client.events.ClientTickHandler;
import com.grim3212.assorted.lib.client.model.loader.ForgePlatformModelLoaderPlatformDelegate;
import com.grim3212.assorted.lib.client.model.loaders.IModelSpecificationLoader;
import com.grim3212.assorted.lib.client.render.IBEWLR;
import com.grim3212.assorted.lib.client.screen.LibScreenFactory;
import com.grim3212.assorted.lib.platform.services.IClientHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ForgeClientHelper
implements IClientHelper {
    private static final Map<String, Registrations> registrationsMap = Maps.newConcurrentMap();
    private static final Map<Item, BlockEntityWithoutLevelRenderer> bewlrs = Maps.newConcurrentMap();

    @Override
    public <T extends AbstractContainerMenu, S extends Screen> void registerScreen(Supplier<MenuType<? extends T>> menuType, LibScreenFactory<T, S> factory) {
        ForgeClientHelper.getRegistration().menuTypes.put(menuType::get, factory);
    }

    @Override
    public void registerAdditionalModel(List<ResourceLocation> modelLocations) {
        ForgeClientHelper.getRegistration().extraModels.addAll(modelLocations);
    }

    @Override
    public void addReloadListener(ResourceLocation identifier, PreparableReloadListener reloadListener) {
        ForgeClientHelper.getRegistration().clientReloadListeners.add(reloadListener);
    }

    @Override
    public void registerBEWLR(Consumer<IBEWLR> register) {
        ForgeClientHelper.getRegistration().blockEntityWithoutLevelInitializers.add(register);
    }

    @Override
    public <E extends BlockEntity> void registerBlockEntityRenderer(Supplier<? extends BlockEntityType<? extends E>> entityType, BlockEntityRendererProvider<E> entityRendererFactory) {
        ForgeClientHelper.getRegistration().blockEntityRenderers.put(entityType, entityRendererFactory);
    }

    @Override
    public <E extends Entity> void registerEntityRenderer(Supplier<? extends EntityType<? extends E>> entityType, EntityRendererProvider<E> entityRendererFactory) {
        ForgeClientHelper.getRegistration().entityRenderers.put(entityType, entityRendererFactory);
    }

    @Override
    public void registerEntityLayer(ModelLayerLocation modelLayerLocation, Supplier<LayerDefinition> layerDefinition) {
        ForgeClientHelper.getRegistration().entityLayers.put(modelLayerLocation, layerDefinition);
    }

    @Override
    public void registerBlockColor(BlockColor color, Supplier<List<Block>> blocks) {
        ForgeClientHelper.getRegistration().blockColors.put(color, blocks);
    }

    @Override
    public void registerItemColor(ItemColor color, Supplier<List<Item>> items) {
        ForgeClientHelper.getRegistration().itemColors.put(color, items);
    }

    @Override
    public BlockColors getBlockColors() {
        return Minecraft.m_91087_().m_91298_();
    }

    @Override
    public ItemColors getItemColors() {
        return Minecraft.m_91087_().getItemColors();
    }

    @Override
    public void registerModelLoader(ResourceLocation name, IModelSpecificationLoader<?> modelLoader) {
        ForgeClientHelper.getRegistration().modelLoaders.put(name, modelLoader);
    }

    @Override
    public void registerItemProperty(Supplier<Item> item, ResourceLocation location, ClampedItemPropertyFunction itemPropertyFunction) {
        ForgeClientHelper.getRegistration().itemProperties.put(item, (Pair<ResourceLocation, ClampedItemPropertyFunction>)Pair.of((Object)location, (Object)itemPropertyFunction));
    }

    @Override
    public void registerRenderType(Supplier<Block> block, RenderType renderType) {
        ForgeClientHelper.getRegistration().renderTypes.put(block, renderType);
    }

    @Override
    public void registerKeyMapping(KeyMapping keyMapping) {
        ForgeClientHelper.getRegistration().keyMappings.add(keyMapping);
    }

    @Override
    public void registerClientTickStart(ClientTickHandler handler) {
        MinecraftForge.EVENT_BUS.addListener(orig -> {
            if (orig.phase == TickEvent.Phase.START) {
                handler.handle(Minecraft.m_91087_());
            }
        });
    }

    @Override
    public void registerClientTickEnd(ClientTickHandler handler) {
        MinecraftForge.EVENT_BUS.addListener(orig -> {
            if (orig.phase == TickEvent.Phase.END) {
                handler.handle(Minecraft.m_91087_());
            }
        });
    }

    @Override
    public <T extends ParticleOptions> void registerParticle(Supplier<ParticleType<T>> type, Function<SpriteSet, ParticleProvider<T>> particleFactory) {
        ForgeClientHelper.getRegistration().particleProviders.put(type, particleFactory::apply);
    }

    @Override
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static Registrations getRegistration() {
        String modId = ModLoadingContext.get().getActiveContainer().getModId();
        if (registrationsMap.containsKey(modId)) {
            return registrationsMap.get(modId);
        }
        Registrations newRegistration = new Registrations();
        registrationsMap.put(modId, newRegistration);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)newRegistration);
        return newRegistration;
    }

    public static Optional<BlockEntityWithoutLevelRenderer> getRenderer(Item item) {
        return Optional.ofNullable(bewlrs.get(item));
    }

    public static class Registrations {
        private final Map<Supplier<BlockEntityType<?>>, BlockEntityRendererProvider<?>> blockEntityRenderers = new HashMap();
        private final Map<Supplier<EntityType<?>>, EntityRendererProvider<?>> entityRenderers = new HashMap();
        private final Map<ModelLayerLocation, Supplier<LayerDefinition>> entityLayers = new HashMap<ModelLayerLocation, Supplier<LayerDefinition>>();
        private final Map<BlockColor, Supplier<List<Block>>> blockColors = new HashMap<BlockColor, Supplier<List<Block>>>();
        private final Map<ItemColor, Supplier<List<Item>>> itemColors = new HashMap<ItemColor, Supplier<List<Item>>>();
        private final Map<Supplier<Item>, Pair<ResourceLocation, ClampedItemPropertyFunction>> itemProperties = new HashMap<Supplier<Item>, Pair<ResourceLocation, ClampedItemPropertyFunction>>();
        private final Map<Supplier<Block>, RenderType> renderTypes = new HashMap<Supplier<Block>, RenderType>();
        private final List<KeyMapping> keyMappings = new ArrayList<KeyMapping>();
        private final List<ResourceLocation> extraModels = new ArrayList<ResourceLocation>();
        private final List<Consumer<IBEWLR>> blockEntityWithoutLevelInitializers = Collections.synchronizedList(new ArrayList());
        private final List<PreparableReloadListener> clientReloadListeners = new ArrayList<PreparableReloadListener>();
        private final Map<ResourceLocation, IModelSpecificationLoader<?>> modelLoaders = new HashMap();
        private final Map<Supplier<ParticleType<?>>, Function<SpriteSet, ParticleProvider<?>>> particleProviders = new HashMap();
        private final Map<Supplier<MenuType<?>>, LibScreenFactory<?, ?>> menuTypes = new HashMap();

        @SubscribeEvent
        public void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            for (Map.Entry<Supplier<BlockEntityType<?>>, BlockEntityRendererProvider<?>> entry : this.blockEntityRenderers.entrySet()) {
                event.registerBlockEntityRenderer(entry.getKey().get(), entry.getValue());
            }
            for (Map.Entry<Supplier<BlockEntityType<?>>, BlockEntityRendererProvider<?>> entry : this.entityRenderers.entrySet()) {
                event.registerEntityRenderer((EntityType)entry.getKey().get(), (EntityRendererProvider)entry.getValue());
            }
        }

        @SubscribeEvent
        public void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            for (Map.Entry<ModelLayerLocation, Supplier<LayerDefinition>> entry : this.entityLayers.entrySet()) {
                event.registerLayerDefinition(entry.getKey(), entry.getValue());
            }
        }

        @SubscribeEvent
        public void registerBlockColors(RegisterColorHandlersEvent.Block event) {
            for (Map.Entry<BlockColor, Supplier<List<Block>>> entry : this.blockColors.entrySet()) {
                event.register(entry.getKey(), (Block[])entry.getValue().get().toArray(Block[]::new));
            }
        }

        @SubscribeEvent
        public void registerItemColors(RegisterColorHandlersEvent.Item event) {
            for (Map.Entry<ItemColor, Supplier<List<Item>>> entry : this.itemColors.entrySet()) {
                event.register(entry.getKey(), (ItemLike[])entry.getValue().get().toArray(ItemLike[]::new));
            }
        }

        @SubscribeEvent
        public void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                for (Map.Entry<Supplier<Item>, Pair<ResourceLocation, ClampedItemPropertyFunction>> entry : this.itemProperties.entrySet()) {
                    ItemProperties.register((Item)entry.getKey().get(), (ResourceLocation)((ResourceLocation)entry.getValue().getFirst()), (ItemPropertyFunction)((ItemPropertyFunction)entry.getValue().getSecond()));
                }
            });
            for (Map.Entry<Supplier<Block>, RenderType> entry : this.renderTypes.entrySet()) {
                ItemBlockRenderTypes.setRenderLayer((Block)entry.getKey().get(), (RenderType)entry.getValue());
            }
            for (Map.Entry<Supplier<Object>, Object> entry : this.menuTypes.entrySet()) {
                this.registerMenu(((Supplier<Object>)entry.getKey())::get, (LibScreenFactory)entry.getValue());
            }
            this.blockEntityWithoutLevelInitializers.forEach(callback -> callback.accept((item, renderer) -> bewlrs.put(item, renderer)));
        }

        private <T extends AbstractContainerMenu, S extends Screen> void registerMenu(Supplier<MenuType<? extends T>> menuType, LibScreenFactory<T, S> factory) {
            MenuScreens.m_96206_(menuType.get(), factory::create);
        }

        @SubscribeEvent
        public void registerKeyMapping(RegisterKeyMappingsEvent event) {
            for (KeyMapping key : this.keyMappings) {
                event.register(key);
            }
        }

        @SubscribeEvent
        public void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
            for (ResourceLocation location : this.extraModels) {
                event.register(location);
            }
        }

        @SubscribeEvent
        public void registerAdditionalModels(RegisterClientReloadListenersEvent event) {
            for (PreparableReloadListener reloadListener : this.clientReloadListeners) {
                event.registerReloadListener(reloadListener);
            }
        }

        @SubscribeEvent
        public void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
            for (Map.Entry<ResourceLocation, IModelSpecificationLoader<?>> entry : this.modelLoaders.entrySet()) {
                event.register(entry.getKey().m_135815_(), new ForgePlatformModelLoaderPlatformDelegate(entry.getValue()));
            }
        }

        @SubscribeEvent
        public void registerParticles(RegisterParticleProvidersEvent event) {
            for (Map.Entry<Supplier<ParticleType<?>>, Function<SpriteSet, ParticleProvider<?>>> entry : this.particleProviders.entrySet()) {
                event.register(entry.getKey().get(), sprites -> (ParticleProvider)((Function)entry.getValue()).apply(sprites));
            }
        }
    }
}

