/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.grim3212.assorted.lib.client.model.data.ForgeBlockModelDataPlatformDelegate;
import com.grim3212.assorted.lib.client.model.data.ForgeModelDataMapBuilderPlatformDelegate;
import com.grim3212.assorted.lib.client.model.data.ForgeModelPropertyPlatformDelegate;
import com.grim3212.assorted.lib.client.model.data.IBlockModelData;
import com.grim3212.assorted.lib.client.model.data.IModelDataBuilder;
import com.grim3212.assorted.lib.client.model.data.IModelDataKey;
import com.grim3212.assorted.lib.client.model.loader.ForgeBakedModelDelegate;
import com.grim3212.assorted.lib.platform.services.IClientModelHelper;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public class ForgeClientModelHelper
implements IClientModelHelper {
    private static final RandomSource RANDOM_SOURCE = new LegacyRandomSource(0L);

    @Override
    public void requestModelDataRefresh(BlockEntity blockEntity) {
        if (blockEntity.m_58904_() != null && blockEntity.m_58904_().getModelDataManager() != null) {
            blockEntity.m_58904_().getModelDataManager().requestRefresh(blockEntity);
        }
    }

    @Override
    public IBlockModelData empty() {
        return new ForgeBlockModelDataPlatformDelegate(ModelData.EMPTY);
    }

    @Override
    @NotNull
    public IModelDataBuilder createNewModelDataBuilder() {
        return new ForgeModelDataMapBuilderPlatformDelegate();
    }

    @Override
    @NotNull
    public <T> IModelDataKey<T> createNewModelDataKey() {
        return new ForgeModelPropertyPlatformDelegate(new ModelProperty());
    }

    @Override
    public UnbakedModel getUnbakedModel(ResourceLocation unbakedModel) {
        return Minecraft.m_91087_().m_91304_().getModelBakery().m_119341_(unbakedModel);
    }

    @Override
    public BakedModel adaptToPlatform(BakedModel bakedModel) {
        if (bakedModel instanceof ForgeBakedModelDelegate) {
            return bakedModel;
        }
        return new ForgeBakedModelDelegate(bakedModel);
    }

    @Override
    public boolean canRenderInType(BlockState blockState, RenderType renderType) {
        return Minecraft.m_91087_().m_91289_().m_110910_(blockState).getRenderTypes(blockState, RANDOM_SOURCE, ModelData.EMPTY).contains(renderType);
    }

    @Override
    public boolean canRenderInType(FluidState fluidState, RenderType renderType) {
        return ItemBlockRenderTypes.m_109287_((FluidState)fluidState) == renderType;
    }

    @Override
    @NotNull
    public Collection<RenderType> getRenderTypesFor(BakedModel model, BlockState state, RandomSource rand, IBlockModelData data) {
        if (!(data instanceof ForgeBlockModelDataPlatformDelegate)) {
            throw new IllegalArgumentException("data must be an instance of ForgeBlockModelData");
        }
        ForgeBlockModelDataPlatformDelegate delegate = (ForgeBlockModelDataPlatformDelegate)data;
        return model.getRenderTypes(state, rand, delegate.getDelegate()).asList();
    }

    @Override
    @NotNull
    public Collection<RenderType> getRenderTypesFor(BakedModel model, ItemStack stack, boolean isFabulous) {
        return model.getRenderTypes(stack, isFabulous);
    }

    @Override
    public RenderType getItemUnlitUnsortedTranslucentRenderType() {
        return ForgeRenderTypes.ITEM_UNSORTED_UNLIT_TRANSLUCENT.get();
    }

    @Override
    public RenderType getItemUnsortedTranslucentRenderType() {
        return ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get();
    }
}

