/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.grim3212.assorted.lib.LibConstants;
import com.grim3212.assorted.lib.config.ConfigurationType;
import com.grim3212.assorted.lib.config.ForgeDelegateConfigurationBuilder;
import com.grim3212.assorted.lib.config.IConfigurationBuilder;
import com.grim3212.assorted.lib.platform.services.IConfigHelper;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ForgeConfigHelper
implements IConfigHelper {
    @Override
    public IConfigurationBuilder createBuilder(ConfigurationType type, String name) {
        return new ForgeDelegateConfigurationBuilder(forgeConfigSpec -> {
            String configName = String.format("%s.toml", name);
            ModConfig config = new ModConfig(ForgeConfigHelper.remapType(type), (IConfigSpec)forgeConfigSpec, ModLoadingContext.get().getActiveContainer(), configName);
            LibConstants.LOG.info(String.format("Building config '%s' for %s", configName, ModLoadingContext.get().getActiveContainer().getModId()));
            ModLoadingContext.get().getActiveContainer().addConfig(config);
        });
    }

    private static ModConfig.Type remapType(ConfigurationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigurationType.CLIENT_ONLY -> ModConfig.Type.CLIENT;
            case ConfigurationType.NOT_SYNCED -> ModConfig.Type.COMMON;
            case ConfigurationType.SYNCED -> ModConfig.Type.SERVER;
        };
    }
}

