/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.grim3212.assorted.lib.core.inventory.IInventoryBlockEntity;
import com.grim3212.assorted.lib.core.inventory.IInventoryItem;
import com.grim3212.assorted.lib.core.inventory.IItemStorageHandler;
import com.grim3212.assorted.lib.core.inventory.IPlatformInventoryStorageHandler;
import com.grim3212.assorted.lib.inventory.ForgeItemStorageHandler;
import com.grim3212.assorted.lib.inventory.ForgePlatformInventoryStorageHandlerSided;
import com.grim3212.assorted.lib.inventory.ForgePlatformInventoryStorageHandlerUnsided;
import com.grim3212.assorted.lib.inventory.ForgeWrappedItemHandler;
import com.grim3212.assorted.lib.platform.services.IInventoryHelper;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeInventoryHelper
implements IInventoryHelper {
    @Override
    public boolean canItemStacksStack(@NotNull ItemStack a, @NotNull ItemStack b) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b);
    }

    @Override
    public ItemStack copyStackWithSize(@NotNull ItemStack itemStack, int size) {
        return ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)size);
    }

    @Override
    public Optional<IItemStorageHandler> getItemStorageHandler(ItemStack stack) {
        IInventoryItem itemStackStorage;
        IPlatformInventoryStorageHandler storageHandler;
        LazyOptional capability = stack.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (capability.isPresent()) {
            IItemHandler itemHandler = (IItemHandler)capability.resolve().get();
            if (itemHandler instanceof ForgeItemStorageHandler) {
                ForgeItemStorageHandler forgeItemStorageHandler = (ForgeItemStorageHandler)itemHandler;
                return Optional.of(forgeItemStorageHandler.getStorage());
            }
            return Optional.of(new ForgeWrappedItemHandler(null, itemHandler));
        }
        Item forgeItemStorageHandler = stack.m_41720_();
        if (forgeItemStorageHandler instanceof IInventoryItem && (storageHandler = (itemStackStorage = (IInventoryItem)forgeItemStorageHandler).getStorageHandler(stack)) != null) {
            return Optional.of(storageHandler.getItemStorageHandler(null));
        }
        return Optional.empty();
    }

    @Override
    public Optional<IItemStorageHandler> getItemStorageHandler(BlockEntity blockEntity, @Nullable Direction direction) {
        IInventoryBlockEntity inventoryBlockEntity;
        IPlatformInventoryStorageHandler storageHandler;
        LazyOptional capability = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction);
        if (capability.isPresent()) {
            IItemHandler itemHandler = (IItemHandler)capability.resolve().get();
            if (itemHandler instanceof ForgeItemStorageHandler) {
                ForgeItemStorageHandler forgeItemStorageHandler = (ForgeItemStorageHandler)itemHandler;
                return Optional.of(forgeItemStorageHandler.getStorage());
            }
            return Optional.of(new ForgeWrappedItemHandler(blockEntity, itemHandler));
        }
        if (blockEntity instanceof IInventoryBlockEntity && (storageHandler = (inventoryBlockEntity = (IInventoryBlockEntity)blockEntity).getStorageHandler()) != null) {
            return Optional.of(storageHandler.getItemStorageHandler(direction));
        }
        return Optional.empty();
    }

    @Override
    public IPlatformInventoryStorageHandler createStorageInventoryHandler(IItemStorageHandler handler) {
        return new ForgePlatformInventoryStorageHandlerUnsided(handler);
    }

    @Override
    public IPlatformInventoryStorageHandler createSidedStorageInventoryHandler(Function<Direction, IItemStorageHandler> handler) {
        return new ForgePlatformInventoryStorageHandlerSided(handler);
    }
}

