/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.grim3212.assorted.lib.LibConstants;
import com.grim3212.assorted.lib.platform.services.INetworkHelper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ForgeNetworkHelper
implements INetworkHelper {
    private static final Map<Class<?>, INetworkHelper.MessageHandler<?>> messageHandlers = new ConcurrentHashMap();
    private static final Map<String, Integer> idCounter = new ConcurrentHashMap<String, Integer>();
    private static NetworkEvent.Context replyContext;

    @Override
    public <MSG> void register(INetworkHelper.MessageHandler<MSG> handler) {
        messageHandlers.put(handler.messageType(), handler);
        String modId = handler.id().m_135827_();
        SimpleChannel channel = Channels.get(modId);
        channel.registerMessage(ForgeNetworkHelper.nextId(modId), handler.messageType(), handler.encoder(), handler.decoder(), (message, contextSupplier) -> {
            NetworkDirection expectedDirection;
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            NetworkDirection networkDirection = expectedDirection = handler.side() == INetworkHelper.MessageBoundSide.CLIENT ? NetworkDirection.PLAY_TO_CLIENT : NetworkDirection.PLAY_TO_SERVER;
            if (context.getDirection() != expectedDirection) {
                LibConstants.LOG.warn("Received {} on incorrect side. Expected on {}", (Object)handler.id(), (Object)context.getDirection());
                return;
            }
            context.enqueueWork(() -> {
                replyContext = context;
                ServerPlayer player = context.getSender();
                handler.messageConsumer().accept(message, (Player)player);
                replyContext = null;
            });
            context.setPacketHandled(true);
        });
    }

    @Override
    public <MSG> void sendToNearby(Level world, BlockPos pos, MSG toSend) {
        if (world instanceof ServerLevel) {
            INetworkHelper.MessageHandler<?> handler = messageHandlers.get(toSend.getClass());
            ServerLevel ws = (ServerLevel)world;
            SimpleChannel channel = Channels.get(handler.id().m_135827_());
            ws.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).stream().filter(p -> p.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 4096.0).forEach(p -> channel.send(PacketDistributor.PLAYER.with(() -> p), toSend));
        }
    }

    @Override
    public <MSG> void sendToNearby(Level world, Entity entity, MSG toSend) {
        this.sendToNearby(world, entity.m_20183_(), toSend);
    }

    @Override
    public <MSG> void sendTo(Player player, MSG toSend) {
        INetworkHelper.MessageHandler<?> handler = messageHandlers.get(toSend.getClass());
        SimpleChannel channel = Channels.get(handler.id().m_135827_());
        channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), toSend);
    }

    @Override
    public <MSG> void sendToServer(MSG toSend) {
        INetworkHelper.MessageHandler<?> handler = messageHandlers.get(toSend.getClass());
        SimpleChannel channel = Channels.get(handler.id().m_135827_());
        channel.sendToServer(toSend);
    }

    private static int nextId(String modId) {
        return idCounter.compute(modId, (key, prev) -> prev != null ? prev + 1 : 0);
    }

    class Channels {
        private static final String PROTOCOL = "7";
        private static final Map<String, SimpleChannel> channels = new ConcurrentHashMap<String, SimpleChannel>();

        Channels() {
        }

        public static SimpleChannel get(String modId) {
            return channels.computeIfAbsent(modId, key -> {
                ResourceLocation channelName = new ResourceLocation(key, "channel");
                return NetworkRegistry.newSimpleChannel((ResourceLocation)channelName, () -> PROTOCOL, PROTOCOL::equals, PROTOCOL::equals);
            });
        }
    }
}

