/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.grim3212.assorted.lib.dist.Dist;
import com.grim3212.assorted.lib.platform.ForgeRegistryWrapper;
import com.grim3212.assorted.lib.platform.services.IPlatformHelper;
import com.grim3212.assorted.lib.registry.ILoaderRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkHooks;

public class ForgePlatformHelper
implements IPlatformHelper {
    public static Map<ResourceLocation, TabRegister> tabsToRegister = new HashMap<ResourceLocation, TabRegister>();

    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public String getCommonTagPrefix() {
        return "forge";
    }

    @Override
    public void openMenu(ServerPlayer player, MenuProvider provider, Consumer<FriendlyByteBuf> extraDataWriter) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, extraDataWriter);
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isProduction() {
        return FMLLoader.isProduction();
    }

    @Override
    public boolean isFakePlayer(Player player) {
        return player instanceof FakePlayer;
    }

    @Override
    public double getPlayerReachDistance(Player player) {
        return player.getReachDistance();
    }

    @Override
    public Dist getCurrentDistribution() {
        return switch (FMLEnvironment.dist) {
            default -> throw new IncompatibleClassChangeError();
            case net.minecraftforge.api.distmarker.Dist.CLIENT -> Dist.CLIENT;
            case net.minecraftforge.api.distmarker.Dist.DEDICATED_SERVER -> Dist.DEDICATED_SERVER;
        };
    }

    @Override
    public boolean isPhysicalClient() {
        return this.getCurrentDistribution() == Dist.CLIENT;
    }

    @Override
    public <T> ILoaderRegistry<T> getRegistry(ResourceKey<? extends Registry<T>> key) {
        return ForgeRegistryWrapper.getRegistry(key);
    }

    @Override
    public void registerCreativeTab(ResourceLocation id, Component title, Supplier<ItemStack> icon, Supplier<List<ItemStack>> displayStacks) {
        tabsToRegister.put(id, new TabRegister(id, title, icon, displayStacks));
    }

    @Override
    public void addReloadListener(ResourceLocation identifier, PreparableReloadListener reloadListener) {
        MinecraftForge.EVENT_BUS.addListener(event -> event.addListener(reloadListener));
    }

    @Override
    public EntityType<?> getRandomDungeonEntity(RandomSource random) {
        return DungeonHooks.getRandomDungeonMob((RandomSource)random);
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BiFunction<BlockPos, BlockState, T> builder, Block ... blocks) {
        return BlockEntityType.Builder.m_155273_(builder::apply, (Block[])blocks).m_58966_(null);
    }

    @Override
    public <T extends AbstractContainerMenu> MenuType<T> createMenuType(IPlatformHelper.MenuFactory<T> factory) {
        return IForgeMenuType.create(factory::create);
    }

    @Override
    public int getFuelTime(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, null);
    }

    @Override
    public boolean isTieredTool(ItemStack stack, Tiers minTier, IPlatformHelper.ToolType toolType) {
        Item item = stack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem itemTier = (TieredItem)item;
            if (stack.m_41720_().canPerformAction(stack, this.getToolActionForType(toolType))) {
                if (TierSortingRegistry.isTierSorted((Tier)itemTier.m_43314_())) {
                    return TierSortingRegistry.getTiersLowerThan((Tier)itemTier.m_43314_()).contains(minTier);
                }
                return IPlatformHelper.super.isTieredTool(stack, minTier, toolType);
            }
        }
        return false;
    }

    private ToolAction getToolActionForType(IPlatformHelper.ToolType type) {
        switch (type) {
            case PICKAXE: {
                return ToolActions.PICKAXE_DIG;
            }
            case SHOVEL: {
                return ToolActions.SHOVEL_DIG;
            }
            case AXE: {
                return ToolActions.AXE_DIG;
            }
            case HOE: {
                return ToolActions.HOE_DIG;
            }
        }
        return null;
    }

    public record TabRegister(ResourceLocation id, Component title, Supplier<ItemStack> icon, Supplier<List<ItemStack>> displayStacks) {
    }
}

