/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.grim3212.assorted.lib.registry.ILoaderRegistry;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class ForgeRegistryWrapper<T>
implements ILoaderRegistry<T> {
    private final ForgeRegistry<T> forgeRegistry;

    private ForgeRegistryWrapper(ForgeRegistry<T> forgeRegistry) {
        this.forgeRegistry = forgeRegistry;
    }

    public static <T, V> ILoaderRegistry<T> getRegistry(ResourceKey<? extends Registry<T>> key) {
        ForgeRegistryWrapper<T> registryWrapper;
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(key.m_135782_());
        ForgeRegistryWrapper<T> castRegistry = registryWrapper = new ForgeRegistryWrapper<T>(registry);
        return castRegistry;
    }

    @Override
    public Stream<T> getValues() {
        return StreamSupport.stream(this.forgeRegistry.spliterator(), false);
    }

    @Override
    public Optional<T> getValue(ResourceLocation resourceLocation) {
        Object value = this.forgeRegistry.getValue(resourceLocation);
        return Optional.ofNullable(value);
    }

    @Override
    public boolean containsKey(ResourceLocation resourceLocation) {
        return this.forgeRegistry.containsKey(resourceLocation);
    }

    @Override
    public boolean contains(T entry) {
        return this.forgeRegistry.containsValue(entry);
    }

    @Override
    public ResourceLocation getRegistryName(T entry) {
        return this.forgeRegistry.getResourceKey(entry).map(ResourceKey::m_135782_).orElse(this.forgeRegistry.getDefaultKey());
    }
}

