/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.grim3212.assorted.lib.platform.services.IWorldGenHelper;
import com.grim3212.assorted.lib.worldgen.BiomeModification;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ForgeWorldGenHelper
implements IWorldGenHelper {
    private static final List<BiomeModification> biomeModifications = new ArrayList<BiomeModification>();

    @Override
    public void addFeatureToBiomes(IWorldGenHelper.BiomePredicate biomePredicate, GenerationStep.Decoration step, ResourceLocation placedFeatureIdentifier) {
        ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)placedFeatureIdentifier);
        biomeModifications.add(new BiomeModification(biomePredicate, step, (ResourceKey<PlacedFeature>)resourceKey));
    }

    public static void modifyBiome(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            for (BiomeModification biomeModification : biomeModifications) {
                ResourceLocation location = biome.m_203543_().map(ResourceKey::m_135782_).orElse(null);
                if (location == null || !biomeModification.getBiomePredicate().test(location, biome)) continue;
                Registry placedFeatures = ServerLifecycleHooks.getCurrentServer().m_206579_().m_175515_(Registries.f_256988_);
                placedFeatures.m_203636_(biomeModification.getConfiguredFeatureKey()).ifPresent(placedFeature -> builder.getGenerationSettings().m_255419_(biomeModification.getStep(), (Holder)placedFeature));
            }
        }
    }
}

