/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform;

import com.grim3212.assorted.lib.LibConstants;
import com.grim3212.assorted.lib.platform.services.IConditionHelper;
import com.grim3212.assorted.lib.platform.services.IConfigHelper;
import com.grim3212.assorted.lib.platform.services.IEventHelper;
import com.grim3212.assorted.lib.platform.services.IFluidManager;
import com.grim3212.assorted.lib.platform.services.IIngredientHelper;
import com.grim3212.assorted.lib.platform.services.IInventoryHelper;
import com.grim3212.assorted.lib.platform.services.ILevelPropertyAccessor;
import com.grim3212.assorted.lib.platform.services.INetworkHelper;
import com.grim3212.assorted.lib.platform.services.IPlatformHelper;
import com.grim3212.assorted.lib.platform.services.IRegistryFactory;
import com.grim3212.assorted.lib.platform.services.IWorldGenHelper;
import java.util.ServiceLoader;

public class Services {
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);
    public static final IConfigHelper CONFIG = Services.load(IConfigHelper.class);
    public static final IRegistryFactory REGISTRY_FACTORY = Services.load(IRegistryFactory.class);
    public static final INetworkHelper NETWORK = Services.load(INetworkHelper.class);
    public static final ILevelPropertyAccessor LEVEL_PROPERTIES = Services.load(ILevelPropertyAccessor.class);
    public static final IEventHelper EVENTS = Services.load(IEventHelper.class);
    public static final IFluidManager FLUIDS = Services.load(IFluidManager.class);
    public static final IConditionHelper CONDITIONS = Services.load(IConditionHelper.class);
    public static final IIngredientHelper INGREDIENTS = Services.load(IIngredientHelper.class);
    public static final IWorldGenHelper WORLD_GEN = Services.load(IWorldGenHelper.class);
    public static final IInventoryHelper INVENTORY = Services.load(IInventoryHelper.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        LibConstants.LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

