/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.platform.services;

import com.grim3212.assorted.lib.dist.Dist;
import com.grim3212.assorted.lib.mixin.world.level.MonsterRoomFeatureAccessor;
import com.grim3212.assorted.lib.registry.ILoaderRegistry;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public interface IPlatformHelper {
    public String getPlatformName();

    public String getCommonTagPrefix();

    public void openMenu(ServerPlayer var1, MenuProvider var2, Consumer<FriendlyByteBuf> var3);

    public boolean isModLoaded(String var1);

    public boolean isFakePlayer(Player var1);

    public double getPlayerReachDistance(Player var1);

    public Dist getCurrentDistribution();

    public boolean isPhysicalClient();

    public boolean isProduction();

    public <T> ILoaderRegistry<T> getRegistry(ResourceKey<? extends Registry<T>> var1);

    public void registerCreativeTab(ResourceLocation var1, Component var2, Supplier<ItemStack> var3, Supplier<List<ItemStack>> var4);

    public void addReloadListener(ResourceLocation var1, PreparableReloadListener var2);

    default public EntityType<?> getRandomDungeonEntity(RandomSource random) {
        return (EntityType)Util.m_214670_((Object[])MonsterRoomFeatureAccessor.getMOBS(), (RandomSource)random);
    }

    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BiFunction<BlockPos, BlockState, T> var1, Block ... var2);

    public <T extends AbstractContainerMenu> MenuType<T> createMenuType(MenuFactory<T> var1);

    public int getFuelTime(ItemStack var1);

    default public boolean isTieredTool(ItemStack stack, Tiers minTier, ToolType toolType) {
        TieredItem itemTier;
        Item item = stack.m_41720_();
        if (item instanceof TieredItem && (itemTier = (TieredItem)item).m_43314_().m_6604_() >= minTier.m_6604_()) {
            switch (toolType) {
                case PICKAXE: {
                    return itemTier instanceof PickaxeItem;
                }
                case SHOVEL: {
                    return itemTier instanceof ShovelItem;
                }
                case AXE: {
                    return itemTier instanceof AxeItem;
                }
                case HOE: {
                    return itemTier instanceof HoeItem;
                }
            }
        }
        return false;
    }

    public static enum ToolType {
        PICKAXE,
        SHOVEL,
        AXE,
        HOE;

    }

    @FunctionalInterface
    public static interface MenuFactory<T extends AbstractContainerMenu> {
        public T create(int var1, Inventory var2, FriendlyByteBuf var3);
    }
}

