/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.util;

import com.google.common.collect.Maps;
import com.grim3212.assorted.lib.platform.Services;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class DyeHelper {
    public static final Map<DyeColor, Block> WOOL_BY_DYE = (Map)Util.m_137469_((Object)Maps.newEnumMap(DyeColor.class), map -> {
        map.put(DyeColor.WHITE, Blocks.f_50041_);
        map.put(DyeColor.ORANGE, Blocks.f_50042_);
        map.put(DyeColor.MAGENTA, Blocks.f_50096_);
        map.put(DyeColor.LIGHT_BLUE, Blocks.f_50097_);
        map.put(DyeColor.YELLOW, Blocks.f_50098_);
        map.put(DyeColor.LIME, Blocks.f_50099_);
        map.put(DyeColor.PINK, Blocks.f_50100_);
        map.put(DyeColor.GRAY, Blocks.f_50101_);
        map.put(DyeColor.LIGHT_GRAY, Blocks.f_50102_);
        map.put(DyeColor.CYAN, Blocks.f_50103_);
        map.put(DyeColor.PURPLE, Blocks.f_50104_);
        map.put(DyeColor.BLUE, Blocks.f_50105_);
        map.put(DyeColor.BROWN, Blocks.f_50106_);
        map.put(DyeColor.GREEN, Blocks.f_50107_);
        map.put(DyeColor.RED, Blocks.f_50108_);
        map.put(DyeColor.BLACK, Blocks.f_50109_);
    });
    public static final Map<DyeColor, Block> CONCRETE_BY_DYE = (Map)Util.m_137469_((Object)Maps.newEnumMap(DyeColor.class), map -> {
        map.put(DyeColor.WHITE, Blocks.f_50542_);
        map.put(DyeColor.ORANGE, Blocks.f_50543_);
        map.put(DyeColor.MAGENTA, Blocks.f_50544_);
        map.put(DyeColor.LIGHT_BLUE, Blocks.f_50545_);
        map.put(DyeColor.YELLOW, Blocks.f_50494_);
        map.put(DyeColor.LIME, Blocks.f_50495_);
        map.put(DyeColor.PINK, Blocks.f_50496_);
        map.put(DyeColor.GRAY, Blocks.f_50497_);
        map.put(DyeColor.LIGHT_GRAY, Blocks.f_50498_);
        map.put(DyeColor.CYAN, Blocks.f_50499_);
        map.put(DyeColor.PURPLE, Blocks.f_50500_);
        map.put(DyeColor.BLUE, Blocks.f_50501_);
        map.put(DyeColor.BROWN, Blocks.f_50502_);
        map.put(DyeColor.GREEN, Blocks.f_50503_);
        map.put(DyeColor.RED, Blocks.f_50504_);
        map.put(DyeColor.BLACK, Blocks.f_50505_);
    });
    public static final Map<DyeColor, Block> CONCRETE_POWDER_BY_DYE = (Map)Util.m_137469_((Object)Maps.newEnumMap(DyeColor.class), map -> {
        map.put(DyeColor.WHITE, Blocks.f_50506_);
        map.put(DyeColor.ORANGE, Blocks.f_50507_);
        map.put(DyeColor.MAGENTA, Blocks.f_50508_);
        map.put(DyeColor.LIGHT_BLUE, Blocks.f_50509_);
        map.put(DyeColor.YELLOW, Blocks.f_50510_);
        map.put(DyeColor.LIME, Blocks.f_50511_);
        map.put(DyeColor.PINK, Blocks.f_50512_);
        map.put(DyeColor.GRAY, Blocks.f_50513_);
        map.put(DyeColor.LIGHT_GRAY, Blocks.f_50514_);
        map.put(DyeColor.CYAN, Blocks.f_50515_);
        map.put(DyeColor.PURPLE, Blocks.f_50516_);
        map.put(DyeColor.BLUE, Blocks.f_50517_);
        map.put(DyeColor.BROWN, Blocks.f_50518_);
        map.put(DyeColor.GREEN, Blocks.f_50519_);
        map.put(DyeColor.RED, Blocks.f_50573_);
        map.put(DyeColor.BLACK, Blocks.f_50574_);
    });
    public static final Map<DyeColor, Block> CARPET_BY_DYE = (Map)Util.m_137469_((Object)Maps.newEnumMap(DyeColor.class), map -> {
        map.put(DyeColor.WHITE, Blocks.f_50336_);
        map.put(DyeColor.ORANGE, Blocks.f_50337_);
        map.put(DyeColor.MAGENTA, Blocks.f_50338_);
        map.put(DyeColor.LIGHT_BLUE, Blocks.f_50339_);
        map.put(DyeColor.YELLOW, Blocks.f_50340_);
        map.put(DyeColor.LIME, Blocks.f_50341_);
        map.put(DyeColor.PINK, Blocks.f_50342_);
        map.put(DyeColor.GRAY, Blocks.f_50343_);
        map.put(DyeColor.LIGHT_GRAY, Blocks.f_50344_);
        map.put(DyeColor.CYAN, Blocks.f_50345_);
        map.put(DyeColor.PURPLE, Blocks.f_50346_);
        map.put(DyeColor.BLUE, Blocks.f_50347_);
        map.put(DyeColor.BROWN, Blocks.f_50348_);
        map.put(DyeColor.GREEN, Blocks.f_50349_);
        map.put(DyeColor.RED, Blocks.f_50350_);
        map.put(DyeColor.BLACK, Blocks.f_50351_);
    });
    public static final List<Map<DyeColor, Block>> BLOCKS_BY_DYE = Arrays.asList(WOOL_BY_DYE, CONCRETE_BY_DYE, CONCRETE_POWDER_BY_DYE, CARPET_BY_DYE);

    public static TagKey<Item> getDyeTag(DyeColor color) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(Services.PLATFORM.getCommonTagPrefix(), "dyes/" + color.m_41065_()));
    }

    public static DyeColor getColor(ItemStack stack) {
        if (stack.m_41720_() instanceof DyeItem) {
            return ((DyeItem)stack.m_41720_()).m_41089_();
        }
        for (int x = 0; x < DyeColor.BLACK.m_41060_(); ++x) {
            DyeColor color = DyeColor.m_41053_((int)x);
            if (!stack.m_204117_(DyeHelper.getDyeTag(color))) continue;
            return color;
        }
        return null;
    }

    public static String[] getDyeNames() {
        DyeColor[] states = DyeColor.values();
        String[] names = new String[states.length];
        for (int i = 0; i < states.length; ++i) {
            names[i] = states[i].name();
        }
        return names;
    }
}

