/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.util;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class NBTHelper {
    public static boolean hasTag(ItemStack itemStack, String keyName) {
        return !itemStack.m_41619_() && itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_(keyName);
    }

    public static void removeTag(ItemStack itemStack, String keyName) {
        if (itemStack.m_41783_() != null) {
            itemStack.m_41783_().m_128473_(keyName);
        }
    }

    private static void initCompoundNBT(ItemStack itemStack) {
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
    }

    private static void initCompoundNBT(CompoundTag compound) {
        if (compound == null) {
            compound = new CompoundTag();
        }
    }

    public static CompoundTag getTag(CompoundTag compound, String keyName) {
        if (compound == null || !compound.m_128441_(keyName)) {
            return new CompoundTag();
        }
        return compound.m_128469_(keyName);
    }

    public static CompoundTag getTag(ItemStack stack, String keyName) {
        NBTHelper.initCompoundNBT(stack);
        if (!stack.m_41783_().m_128441_(keyName)) {
            NBTHelper.putTag(stack, keyName, new CompoundTag());
        }
        return stack.m_41783_().m_128469_(keyName);
    }

    public static void putTag(ItemStack stack, String keyName, CompoundTag compound) {
        NBTHelper.initCompoundNBT(stack);
        stack.m_41783_().m_128365_(keyName, (Tag)compound);
    }

    public static String getString(CompoundTag compound, String keyName) {
        NBTHelper.initCompoundNBT(compound);
        if (compound == null || !compound.m_128441_(keyName)) {
            NBTHelper.putString(compound, keyName, "");
        }
        return compound.m_128461_(keyName);
    }

    public static void putString(CompoundTag compound, String keyName, String keyValue) {
        NBTHelper.initCompoundNBT(compound);
        compound.m_128359_(keyName, keyValue);
    }

    public static String getString(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.m_41783_().m_128441_(keyName)) {
            NBTHelper.putString(itemStack, keyName, "");
        }
        return itemStack.m_41783_().m_128461_(keyName);
    }

    public static void putString(ItemStack itemStack, String keyName, String keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128359_(keyName, keyValue);
    }

    public static ItemStack putStringItemStack(ItemStack itemStack, String keyName, String keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128359_(keyName, keyValue);
        return itemStack;
    }

    public static boolean getBoolean(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.m_41783_().m_128441_(keyName)) {
            NBTHelper.putBoolean(itemStack, keyName, false);
        }
        return itemStack.m_41783_().m_128471_(keyName);
    }

    public static void putBoolean(ItemStack itemStack, String keyName, boolean keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128379_(keyName, keyValue);
    }

    public static ItemStack putBooleanItemStack(ItemStack itemStack, String keyName, boolean keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128379_(keyName, keyValue);
        return itemStack;
    }

    public static byte getByte(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.m_41783_().m_128441_(keyName)) {
            NBTHelper.putByte(itemStack, keyName, (byte)0);
        }
        return itemStack.m_41783_().m_128445_(keyName);
    }

    public static void putByte(ItemStack itemStack, String keyName, byte keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128344_(keyName, keyValue);
    }

    public static ItemStack putByteItemStack(ItemStack itemStack, String keyName, byte keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128344_(keyName, keyValue);
        return itemStack;
    }

    public static short getShort(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.m_41783_().m_128441_(keyName)) {
            NBTHelper.putShort(itemStack, keyName, (short)0);
        }
        return itemStack.m_41783_().m_128448_(keyName);
    }

    public static void putShort(ItemStack itemStack, String keyName, short keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128376_(keyName, keyValue);
    }

    public static ItemStack putShortItemStack(ItemStack itemStack, String keyName, short keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128376_(keyName, keyValue);
        return itemStack;
    }

    public static int getInt(CompoundTag compound, String keyName) {
        NBTHelper.initCompoundNBT(compound);
        if (compound == null || !compound.m_128441_(keyName)) {
            NBTHelper.putInt(compound, keyName, 0);
        }
        return compound.m_128451_(keyName);
    }

    public static void putInt(CompoundTag compound, String keyName, int keyValue) {
        NBTHelper.initCompoundNBT(compound);
        compound.m_128405_(keyName, keyValue);
    }

    public static int getInt(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.m_41783_().m_128441_(keyName)) {
            NBTHelper.putInt(itemStack, keyName, 0);
        }
        return itemStack.m_41783_().m_128451_(keyName);
    }

    public static int getInt(ItemStack itemStack, String keyName, int fallback) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.m_41783_().m_128441_(keyName)) {
            NBTHelper.putInt(itemStack, keyName, fallback);
        }
        return itemStack.m_41783_().m_128451_(keyName);
    }

    public static void putInt(ItemStack itemStack, String keyName, int keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128405_(keyName, keyValue);
    }

    public static ItemStack putIntItemStack(ItemStack itemStack, String keyName, int keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128405_(keyName, keyValue);
        return itemStack;
    }

    public static long getLong(CompoundTag compound, String keyName) {
        NBTHelper.initCompoundNBT(compound);
        if (compound == null || !compound.m_128441_(keyName)) {
            NBTHelper.putLong(compound, keyName, 0L);
        }
        return compound.m_128454_(keyName);
    }

    public static void putLong(CompoundTag compound, String keyName, long keyValue) {
        NBTHelper.initCompoundNBT(compound);
        compound.m_128356_(keyName, keyValue);
    }

    public static long getLong(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.m_41783_().m_128441_(keyName)) {
            NBTHelper.putLong(itemStack, keyName, 0L);
        }
        return itemStack.m_41783_().m_128454_(keyName);
    }

    public static void putLong(ItemStack itemStack, String keyName, long keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128356_(keyName, keyValue);
    }

    public static ItemStack putLongItemStack(ItemStack itemStack, String keyName, long keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128356_(keyName, keyValue);
        return itemStack;
    }

    public static float getFloat(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.m_41783_().m_128441_(keyName)) {
            NBTHelper.putFloat(itemStack, keyName, 0.0f);
        }
        return itemStack.m_41783_().m_128457_(keyName);
    }

    public static void putFloat(ItemStack itemStack, String keyName, float keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128350_(keyName, keyValue);
    }

    public static ItemStack putFloatItemStack(ItemStack itemStack, String keyName, float keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128350_(keyName, keyValue);
        return itemStack;
    }

    public static double getDouble(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.m_41783_().m_128441_(keyName)) {
            NBTHelper.putDouble(itemStack, keyName, 0.0);
        }
        return itemStack.m_41783_().m_128459_(keyName);
    }

    public static void putDouble(ItemStack itemStack, String keyName, double keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128347_(keyName, keyValue);
    }

    public static ItemStack putDoubleItemStack(ItemStack itemStack, String keyName, double keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128347_(keyName, keyValue);
        return itemStack;
    }

    public static BlockPos getBlockPos(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.m_41783_().m_128441_(keyName)) {
            NBTHelper.putBlockPos(itemStack, keyName, new BlockPos(0, 0, 0));
        }
        int[] pos = itemStack.m_41783_().m_128465_(keyName);
        return new BlockPos(pos[0], pos[1], pos[2]);
    }

    public static BlockPos getBlockPos(CompoundTag tag, String keyName) {
        NBTHelper.initCompoundNBT(tag);
        if (!tag.m_128441_(keyName)) {
            NBTHelper.putBlockPos(tag, keyName, new BlockPos(0, 0, 0));
        }
        int[] pos = tag.m_128465_(keyName);
        return new BlockPos(pos[0], pos[1], pos[2]);
    }

    public static void putBlockPos(CompoundTag tag, String keyName, BlockPos keyValue) {
        NBTHelper.initCompoundNBT(tag);
        tag.m_128385_(keyName, new int[]{keyValue.m_123341_(), keyValue.m_123342_(), keyValue.m_123343_()});
    }

    public static void putBlockPos(ItemStack itemStack, String keyName, BlockPos keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128385_(keyName, new int[]{keyValue.m_123341_(), keyValue.m_123342_(), keyValue.m_123343_()});
    }

    public static ItemStack putBlockPosItemStack(ItemStack itemStack, String keyName, BlockPos keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.m_41783_().m_128385_(keyName, new int[]{keyValue.m_123341_(), keyValue.m_123342_(), keyValue.m_123343_()});
        return itemStack;
    }
}

