/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.lib.worldgen;

import com.grim3212.assorted.lib.platform.ForgeWorldGenHelper;
import com.mojang.serialization.Codec;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class LibForgeWorldGen {
    @Nullable
    private static Codec<ForgeBiomeModifier> libBiomeModifierCodec = null;

    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(event -> event.register(ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, registry -> {
            libBiomeModifierCodec = Codec.unit((Object)ForgeBiomeModifier.INSTANCE);
            registry.register(new ResourceLocation("assortedlib", "lib_biome_modifier"), (Object)libBiomeModifierCodec);
        }));
    }

    private static class ForgeBiomeModifier
    implements BiomeModifier {
        private static final ForgeBiomeModifier INSTANCE = new ForgeBiomeModifier();

        private ForgeBiomeModifier() {
        }

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            ForgeWorldGenHelper.modifyBiome(biome, phase, builder);
        }

        public Codec<? extends BiomeModifier> codec() {
            if (libBiomeModifierCodec != null) {
                return libBiomeModifierCodec;
            }
            return Codec.unit((Object)INSTANCE);
        }
    }
}

