/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.hexlands.util;

import net.minecraft.core.BlockPos;

public record Hex(int q, int r, double size) {
    private static final double SQRT_3 = 1.7320508075688772;

    public static Hex blockToHex(double x, double z, double size) {
        double q = Hex.blockToHexQ(x, size);
        double r = Hex.blockToHexR(x, z, size);
        return Hex.hexRound(q, r, size);
    }

    private static double blockToHexQ(double x, double size) {
        return 0.6666666666666666 * x / size;
    }

    private static double blockToHexR(double x, double z, double size) {
        return (-0.3333333333333333 * x + 0.5773502691896257 * z) / size;
    }

    private static int axialToCube(int q, int r) {
        return -q - r;
    }

    private static double axialToCube(double q, double r) {
        return -q - r;
    }

    private static BlockPos hexToBlock(int q, int r, double size) {
        double x = Hex.hexToBlockX(q, size);
        double z = Hex.hexToBlockZ(q, r, size);
        return new BlockPos((int)Math.round(x), 0, (int)Math.round(z));
    }

    private static double hexToBlockX(double q, double size) {
        return size * (1.5 * q);
    }

    private static double hexToBlockZ(double q, double r, double size) {
        return size * (0.8660254037844386 * q + 1.7320508075688772 * r);
    }

    private static Hex hexRound(double q, double r, double size) {
        double s = Hex.axialToCube(q, r);
        int rq = (int)Math.round(q);
        int rr = (int)Math.round(r);
        int rs = (int)Math.round(s);
        double dq = Math.abs((double)rq - q);
        double dr = Math.abs((double)rr - r);
        double ds = Math.abs((double)rs - s);
        if (dq > dr && dq > ds) {
            rq = Hex.axialToCube(rr, rs);
        } else if (dr > ds && dr > dq) {
            rr = Hex.axialToCube(rq, rs);
        }
        return new Hex(rq, rr, size);
    }

    public static Hex adjacent(int q, int r, double fq, double fr, double size) {
        double s = Hex.axialToCube(q, r);
        double fs = Hex.axialToCube(fq, fr);
        double dq = (double)q - fq;
        double dr = (double)r - fr;
        double ds = s - fs;
        double qr = Math.abs(dq - dr);
        double rs = Math.abs(dr - ds);
        double sq = Math.abs(ds - dq);
        if (qr >= rs && qr >= sq) {
            return dr > dq ? new Hex(q + 1, r - 1, size) : new Hex(q - 1, r + 1, size);
        }
        if (rs >= sq) {
            return dr > ds ? new Hex(q, r - 1, size) : new Hex(q, r + 1, size);
        }
        return ds > dq ? new Hex(q + 1, r, size) : new Hex(q - 1, r, size);
    }

    private static double radius(int q, int r, double fq, double fr) {
        double s = Hex.axialToCube(q, r);
        double fs = Hex.axialToCube(fq, fr);
        double dq = (double)q - fq;
        double dr = (double)r - fr;
        double ds = s - fs;
        double qr = Math.abs(dq - dr);
        double rs = Math.abs(dr - ds);
        double sq = Math.abs(ds - dq);
        return 0.5 * (qr + rs + sq);
    }

    public BlockPos center() {
        return Hex.hexToBlock(this.q, this.r, this.size);
    }

    public double radius(double x, double z) {
        double fq = Hex.blockToHexQ(x, this.size);
        double fr = Hex.blockToHexR(x, z, this.size);
        return Hex.radius(this.q, this.r, fq, fr);
    }

    public Hex adjacent(double x, double z) {
        double fq = Hex.blockToHexQ(x, this.size);
        double fr = Hex.blockToHexR(x, z, this.size);
        return Hex.adjacent(this.q, this.r, fq, fr, this.size);
    }

    public double x() {
        return Hex.hexToBlockX(this.q, this.size);
    }

    public double z() {
        return Hex.hexToBlockZ(this.q, this.r, this.size);
    }

    @Override
    public int hashCode() {
        return this.q * 31 + this.r;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hex hex = (Hex)o;
        return this.q == hex.q && this.r == hex.r;
    }

    @Override
    public String toString() {
        return "Hex{q=" + this.q + ", r=" + this.r + "}";
    }
}

