/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.hexlands.world;

import com.alcatrazescapee.hexlands.util.Hex;
import com.alcatrazescapee.hexlands.util.HexSettings;
import com.alcatrazescapee.hexlands.world.HexRandomState;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import org.jetbrains.annotations.Nullable;

public class HexChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<HexChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(c -> c.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(c -> c.settings), (App)HexSettings.CODEC.fieldOf("hex_settings").forGetter(c -> c.hexSettings)).apply((Applicative)instance, HexChunkGenerator::new));
    private final Holder<NoiseGeneratorSettings> settings;
    private final HexSettings hexSettings;
    private final Supplier<Aquifer.FluidPicker> stupidMojangGlobalFluidPicker;

    public HexChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings, HexSettings hexSettings) {
        super(biomeSource, settings);
        this.settings = settings;
        this.hexSettings = hexSettings;
        this.stupidMojangGlobalFluidPicker = Suppliers.memoize(() -> {
            NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)settings.m_203334_();
            Aquifer.FluidStatus lavaAtNeg54 = new Aquifer.FluidStatus(-54, Blocks.f_49991_.m_49966_());
            int seaLevel = noiseGeneratorSettings.f_64444_();
            Aquifer.FluidStatus waterAtSeaLevel = new Aquifer.FluidStatus(seaLevel, noiseGeneratorSettings.f_64441_());
            return (x, y, z) -> y < Math.min(-54, seaLevel) ? lavaAtNeg54 : waterAtSeaLevel;
        });
    }

    protected Codec<HexChunkGenerator> m_6909_() {
        return CODEC;
    }

    public void m_214194_(WorldGenRegion level, StructureManager structureManager, RandomState randomState, ChunkAccess chunk) {
        super.m_214194_(level, structureManager, randomState, chunk);
        NoiseChunk noiseChunk = this.getOrCreateNoiseChunk(chunk, randomState, structureManager, Blender.m_190202_((WorldGenRegion)level));
        this.applyAtHexBorders(chunk, randomState, noiseChunk, (cursor, placed) -> {
            Block block;
            int y;
            for (y = placed.minY; y <= placed.borderMinY; ++y) {
                block = chunk.m_8055_((BlockPos)cursor.m_142448_(y)).m_60734_();
                if (block == Blocks.f_50752_) continue;
                chunk.m_6978_((BlockPos)cursor, placed.borderMinState, false);
            }
            for (y = placed.borderMinY + 1; y < placed.borderMaxY; ++y) {
                chunk.m_6978_((BlockPos)cursor.m_142448_(y), Blocks.f_50016_.m_49966_(), false);
            }
            for (y = placed.borderMaxY; y <= placed.maxY; ++y) {
                block = chunk.m_8055_((BlockPos)cursor.m_142448_(y)).m_60734_();
                if (block == Blocks.f_50752_) continue;
                chunk.m_6978_((BlockPos)cursor, placed.borderMaxState, false);
            }
        });
    }

    public int m_214096_(int x, int z, Heightmap.Types type, LevelHeightAccessor level, RandomState state) {
        HexRandomState.modify(state, (NoiseGeneratorSettings)this.settings.m_203334_(), this.hexSettings);
        return super.m_214096_(x, z, type, level, state);
    }

    public void m_213600_(List<String> tooltips, RandomState state, BlockPos pos) {
        double hexScale = this.hexSettings.biomeScale();
        double hexSize = this.hexSettings.hexSize() * hexScale;
        Hex hex = Hex.blockToHex((double)pos.m_123341_() * hexScale, (double)pos.m_123343_() * hexScale, hexSize);
        PlacedHex placed = this.placeHex(hex, state, null, pos.m_123342_());
        tooltips.add(String.format("Hex (%d, %d) at %s : H%d B%d-%d", hex.q(), hex.r(), placed.biome().m_203439_().map(ResourceKey::m_135782_, e -> "[unregistered biome]"), (int)placed.preliminaryHeight, placed.borderMinY, placed.borderMaxY));
        super.m_213600_(tooltips, state, pos);
    }

    private void applyAtHexBorders(ChunkAccess chunk, RandomState state, NoiseChunk noiseChunk, ColumnApplier applier) {
        HashMap<Hex, PlacedHex> cachedBiomesByHex = new HashMap<Hex, PlacedHex>();
        ChunkPos chunkPos = chunk.m_7697_();
        int blockX = chunkPos.m_45604_();
        int blockZ = chunkPos.m_45605_();
        double hexScale = this.hexSettings.biomeScale();
        double hexSize = this.hexSettings.hexSize() * hexScale;
        double hexBorder = this.hexSettings.hexBorderThreshold();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                int x = blockX + localX;
                int z = blockZ + localZ;
                Hex hex = Hex.blockToHex((double)x * hexScale, (double)z * hexScale, hexSize);
                Hex adjacentHex = hex.adjacent((double)x * hexScale, (double)z * hexScale);
                PlacedHex placed = cachedBiomesByHex.computeIfAbsent(hex, k -> this.placeHex((Hex)k, state, noiseChunk, 0));
                if (!(hex.radius((double)x * hexScale, (double)z * hexScale) >= hexBorder)) continue;
                PlacedHex adjacentPlacedHex = cachedBiomesByHex.computeIfAbsent(adjacentHex, k -> this.placeHex((Hex)k, state, noiseChunk, 0));
                if (placed.biome == adjacentPlacedHex.biome) continue;
                cursor.m_142451_(x).m_142443_(z);
                applier.apply(cursor, placed);
            }
        }
    }

    private PlacedHex placeHex(Hex hex, RandomState state, @Nullable NoiseChunk noiseChunk, int backupSurfaceY) {
        BlockPos center = hex.center();
        double hexScale = this.hexSettings.biomeScale();
        int quartX = QuartPos.m_175400_((int)((int)((double)center.m_123341_() / hexScale)));
        int quartZ = QuartPos.m_175400_((int)((int)((double)center.m_123343_() / hexScale)));
        NoiseSettings noiseSettings = ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_();
        HexRandomState hexRandomState = HexRandomState.modify(state, (NoiseGeneratorSettings)this.settings.m_203334_(), this.hexSettings);
        double preliminaryHeight = noiseChunk != null ? (double)noiseChunk.m_198256_((int)((double)center.m_123341_() / hexScale), (int)((double)center.m_123343_() / hexScale)) : (double)backupSurfaceY;
        Holder biome = this.f_62137_.m_203407_(quartX, QuartPos.m_175400_((int)((int)preliminaryHeight)), quartZ, hexRandomState.hexSampler());
        XoroshiroRandomSource random = new XoroshiroRandomSource((long)hex.q() * 178293412341L, (long)hex.r() * 7520351231L);
        int minY = noiseSettings.f_158688_();
        int maxY = noiseSettings.f_158688_() + noiseSettings.f_64508_() - 1;
        int borderMinY = this.hexSettings.bottomBorder().map(arg_0 -> HexChunkGenerator.lambda$placeHex$10((RandomSource)random, arg_0)).orElse(minY - 1);
        int borderMaxY = this.hexSettings.topBorder().map(arg_0 -> HexChunkGenerator.lambda$placeHex$11((RandomSource)random, arg_0)).orElse(maxY + 1);
        BlockState minBorderState = this.hexSettings.bottomBorder().map(HexSettings.BorderSettings::state).orElse(Blocks.f_50016_.m_49966_());
        BlockState maxBorderState = this.hexSettings.topBorder().map(HexSettings.BorderSettings::state).orElse(Blocks.f_50016_.m_49966_());
        return new PlacedHex(hex, (Holder<Biome>)biome, preliminaryHeight, minY, maxY, borderMinY, borderMaxY, minBorderState, maxBorderState);
    }

    private NoiseChunk getOrCreateNoiseChunk(ChunkAccess chunk, RandomState state, StructureManager structureManager, Blender blender) {
        return chunk.m_223012_(c -> NoiseChunk.m_224352_((ChunkAccess)c, (RandomState)state, (DensityFunctions.BeardifierOrMarker)Beardifier.m_223937_((StructureManager)structureManager, (ChunkPos)c.m_7697_()), (NoiseGeneratorSettings)((NoiseGeneratorSettings)this.settings.m_203334_()), (Aquifer.FluidPicker)this.stupidMojangGlobalFluidPicker.get(), (Blender)blender));
    }

    private static /* synthetic */ Integer lambda$placeHex$11(RandomSource random, HexSettings.BorderSettings border) {
        return border.sample(random);
    }

    private static /* synthetic */ Integer lambda$placeHex$10(RandomSource random, HexSettings.BorderSettings border) {
        return border.sample(random);
    }

    @FunctionalInterface
    static interface ColumnApplier {
        public void apply(BlockPos.MutableBlockPos var1, PlacedHex var2);
    }

    record PlacedHex(Hex hex, Holder<Biome> biome, double preliminaryHeight, int minY, int maxY, int borderMinY, int borderMaxY, BlockState borderMinState, BlockState borderMaxState) {
    }
}

