/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.hexlands.world;

import com.alcatrazescapee.hexlands.mixin.RandomStateAccessor;
import com.alcatrazescapee.hexlands.platform.XPlatform;
import com.alcatrazescapee.hexlands.util.Hex;
import com.alcatrazescapee.hexlands.util.HexSettings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.serialization.MapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.concurrent.ExecutionException;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.RandomState;

public record HexRandomState(RandomState state, NoiseRouter hexRouter, Climate.Sampler hexSampler) {
    private static final Cache<RandomState, HexRandomState> RANDOM_STATE_EXTENSIONS = CacheBuilder.newBuilder().concurrencyLevel(4).weakKeys().build();

    public static HexRandomState modify(RandomState state, NoiseGeneratorSettings settings, HexSettings hexSettings) {
        try {
            return (HexRandomState)RANDOM_STATE_EXTENSIONS.get((Object)state, () -> {
                DensityFunction.Visitor visitor = f -> {
                    if (HexRandomState.isNoiseDensityFunction(f)) {
                        return HexRandomState.sampleHexRelative(hexSettings, f);
                    }
                    return f;
                };
                NoiseRouter router = state.m_224578_();
                NoiseRouter hexRouter = new NoiseRouter(router.f_209378_(), router.f_209379_(), router.f_209380_(), router.f_209381_(), HexRandomState.sampleHexCenter(hexSettings, router.f_209384_()), HexRandomState.sampleHexCenter(hexSettings, router.f_224392_()), HexRandomState.sampleHexCenter(hexSettings, router.f_209386_()), HexRandomState.sampleHexCenter(hexSettings, router.f_209387_()), HexRandomState.sampleHexCenter(hexSettings, router.f_209388_()), HexRandomState.sampleHexCenter(hexSettings, router.f_209389_()), router.f_209390_().m_207456_(visitor), router.f_209391_().m_207456_(visitor), router.f_209392_(), router.f_209393_(), router.f_209394_());
                Climate.Sampler hexSampler = new Climate.Sampler(hexRouter.f_209384_(), hexRouter.f_224392_(), hexRouter.f_209386_(), hexRouter.f_209387_(), hexRouter.f_209388_(), hexRouter.f_209389_(), settings.f_224370_());
                XPlatform.INSTANCE.copyFabricCachedClimateSamplerSeed(state.m_224579_(), hexSampler);
                RandomStateAccessor mutableState = (RandomStateAccessor)state;
                mutableState.setRouter(hexRouter);
                mutableState.setSampler(hexSampler);
                return new HexRandomState(state, hexRouter, hexSampler);
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to inject HexRandomState into RandomState", e);
        }
    }

    private static boolean isNoiseDensityFunction(DensityFunction f) {
        return f instanceof DensityFunctions.Noise || f instanceof DensityFunctions.Shift || f instanceof DensityFunctions.ShiftedNoise;
    }

    private static DensityFunction sampleHexCenter(HexSettings hexSettings, DensityFunction function) {
        return new PointMapped(function, function.m_207402_(), function.m_207401_(), point -> {
            double scale = hexSettings.biomeScale();
            double size = hexSettings.hexSize() * scale;
            Hex hex = Hex.blockToHex((double)point.m_207115_() * scale, (double)point.m_207113_() * scale, size);
            BlockPos center = hex.center();
            return new DensityFunction.SinglePointContext(center.m_123341_(), point.m_207114_(), center.m_123343_());
        });
    }

    private static DensityFunction sampleHexRelative(HexSettings hexSettings, DensityFunction function) {
        return new PointMapped(function, function.m_207402_(), function.m_207401_(), point -> {
            double scale = hexSettings.biomeScale();
            double size = hexSettings.hexSize();
            Hex hex = Hex.blockToHex((double)point.m_207115_() * scale, (double)point.m_207113_() * scale, size * scale);
            BlockPos center = hex.center();
            double deltaX = (double)point.m_207115_() - (double)center.m_123341_() / scale;
            double deltaZ = (double)point.m_207113_() - (double)center.m_123343_() / scale;
            return new DensityFunction.SinglePointContext(center.m_123341_() + (int)deltaX, point.m_207114_(), center.m_123343_() + (int)deltaZ);
        });
    }

    static final class PointMapped
    extends Record
    implements DensityFunction.SimpleFunction {
        private final DensityFunction wrapped;
        private final double minValue;
        private final double maxValue;
        private final UnaryOperator<DensityFunction.FunctionContext> point;

        PointMapped(DensityFunction wrapped, double minValue, double maxValue, UnaryOperator<DensityFunction.FunctionContext> point) {
            this.wrapped = wrapped;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.point = point;
        }

        public double m_207386_(DensityFunction.FunctionContext context) {
            return this.wrapped.m_207386_((DensityFunction.FunctionContext)this.point.apply(context));
        }

        public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
            return new PointMapped(this.wrapped.m_207456_(visitor), this.minValue, this.maxValue, this.point);
        }

        public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
            return KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)this));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PointMapped.class, "wrapped;minValue;maxValue;point", "wrapped", "minValue", "maxValue", "point"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PointMapped.class, "wrapped;minValue;maxValue;point", "wrapped", "minValue", "maxValue", "point"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PointMapped.class, "wrapped;minValue;maxValue;point", "wrapped", "minValue", "maxValue", "point"}, this, o);
        }

        public DensityFunction wrapped() {
            return this.wrapped;
        }

        public double m_207402_() {
            return this.minValue;
        }

        public double m_207401_() {
            return this.maxValue;
        }

        public UnaryOperator<DensityFunction.FunctionContext> point() {
            return this.point;
        }
    }
}

