/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.simplequests;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.simplequests.SimpleQuests;
import io.github.flemmli97.simplequests.config.ConfigHandler;
import io.github.flemmli97.simplequests.datapack.QuestsManager;
import io.github.flemmli97.simplequests.gui.QuestCategoryGui;
import io.github.flemmli97.simplequests.gui.QuestGui;
import io.github.flemmli97.simplequests.player.PlayerData;
import io.github.flemmli97.simplequests.player.QuestProgress;
import io.github.flemmli97.simplequests.quest.Quest;
import io.github.flemmli97.simplequests.quest.QuestCategory;
import io.github.flemmli97.simplequests.quest.QuestEntry;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class QuestCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"simplequests").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"show").requires(src -> SimpleQuests.getHandler().hasPerm((class_2168)src, "simplequests.command.show"))).executes(QuestCommand::show)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"category", (ArgumentType)class_2232.method_9441()).requires(src -> SimpleQuests.getHandler().hasPerm((class_2168)src, "simplequests.command.show.category", true))).suggests(QuestCommand::questCategories).executes(QuestCommand::showCategory)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"accept").requires(src -> SimpleQuests.getHandler().hasPerm((class_2168)src, "simplequests.command.accept"))).then(class_2170.method_9244((String)"quest", (ArgumentType)class_2232.method_9441()).suggests(QuestCommand::quests).executes(QuestCommand::accept)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"submit").requires(src -> SimpleQuests.getHandler().hasPerm((class_2168)src, "simplequests.command.submit"))).executes(QuestCommand::submit)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.string()).requires(src -> SimpleQuests.getHandler().hasPerm((class_2168)src, "simplequests.command.submit.type", true))).executes(QuestCommand::submitType)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(src -> SimpleQuests.getHandler().hasPerm((class_2168)src, "simplequests.command.reload", true))).executes(QuestCommand::reload))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"resetCooldown").requires(src -> SimpleQuests.getHandler().hasPerm((class_2168)src, "simplequests.command.resetCooldown", true))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).executes(QuestCommand::resetCooldown)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"resetAll").requires(src -> SimpleQuests.getHandler().hasPerm((class_2168)src, "simplequests.command.resetAll", true))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).executes(QuestCommand::resetAll)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"current").requires(src -> SimpleQuests.getHandler().hasPerm((class_2168)src, "simplequests.command.current"))).executes(QuestCommand::current))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(src -> SimpleQuests.getHandler().hasPerm((class_2168)src, "simplequests.command.reset"))).then(class_2170.method_9244((String)"quest", (ArgumentType)class_2232.method_9441()).suggests(QuestCommand::activequests).executes(QuestCommand::reset)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unlock").requires(src -> SimpleQuests.getHandler().hasPerm((class_2168)src, "simplequests.command.unlock", true))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"quest", (ArgumentType)class_2232.method_9441()).suggests(QuestCommand::lockedQuests).executes(QuestCommand::unlock)))));
    }

    private static int show(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        if (QuestsManager.instance().categories().size() == 1) {
            QuestGui.openGui((class_1657)player, QuestsManager.instance().categories().get(0), false);
        }
        QuestCategoryGui.openGui((class_1657)player);
        return 1;
    }

    private static int showCategory(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        class_2960 id = class_2232.method_9443(ctx, (String)"category");
        QuestCategory category = QuestsManager.instance().getQuestCategory(id);
        if (category == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)String.format(ConfigHandler.lang.get("simplequests.quest.category.noexist"), id)));
            return 0;
        }
        QuestGui.openGui((class_1657)player, category, false);
        return 1;
    }

    private static int accept(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        class_2960 id = class_2232.method_9443(ctx, (String)"quest");
        Quest quest = QuestsManager.instance().getAllQuests().get(id);
        if (quest == null) {
            ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43471((String)String.format(ConfigHandler.lang.get("simplequests.quest.noexist"), id)), false);
            return 0;
        }
        if (PlayerData.get(player).acceptQuest(quest)) {
            return 1;
        }
        return 0;
    }

    private static int current(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        List<QuestProgress> quests = PlayerData.get(player).getCurrentQuest();
        if (!quests.isEmpty()) {
            quests.forEach(prog -> {
                ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43471((String)String.format(ConfigHandler.lang.get("simplequests.current"), prog.getQuest().getTask())).method_27692(class_124.field_1065), false);
                List<String> finished = prog.finishedTasks();
                prog.getQuest().entries.entrySet().stream().filter(e -> !finished.contains(e.getKey())).forEach(e -> ((class_2168)ctx.getSource()).method_9226((class_2561)((QuestEntry)e.getValue()).translation(((class_2168)ctx.getSource()).method_9211()).method_27692(class_124.field_1061), false));
            });
            return 1;
        }
        ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.current.no")).method_27692(class_124.field_1079), false);
        return 0;
    }

    private static int submit(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        if (PlayerData.get(player).submit("", true)) {
            return 1;
        }
        return 0;
    }

    private static int submitType(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        String type = StringArgumentType.getString(ctx, (String)"type");
        if (PlayerData.get(player).submit(type, true)) {
            return 1;
        }
        return 0;
    }

    private static int reload(CommandContext<class_2168> ctx) {
        ConfigHandler.reloadConfigs();
        ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.reload")), true);
        return 1;
    }

    private static int reset(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        class_2960 res = class_2232.method_9443(ctx, (String)"quest");
        PlayerData.get(player).reset(res, false);
        return 1;
    }

    private static int resetCooldown(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int i = 0;
        for (class_3222 player : class_2186.method_9312(ctx, (String)"target")) {
            PlayerData.get(player).resetCooldown();
            ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43469((String)ConfigHandler.lang.get("simplequests.reset.cooldown"), (Object[])new Object[]{player.method_5477()}).method_27692(class_124.field_1079), true);
            ++i;
        }
        return i;
    }

    private static int resetAll(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int i = 0;
        for (class_3222 player : class_2186.method_9312(ctx, (String)"target")) {
            PlayerData.get(player).resetAll();
            ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43469((String)ConfigHandler.lang.get("simplequests.reset.all"), (Object[])new Object[]{player.method_5477()}).method_27692(class_124.field_1079), true);
            ++i;
        }
        return i;
    }

    private static int unlock(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2960 res = class_2232.method_9443(ctx, (String)"quest");
        if (!QuestsManager.instance().getAllQuests().containsKey(res)) {
            ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43469((String)ConfigHandler.lang.get("simplequests.unlock.fail"), (Object[])new Object[]{res}), true);
            return 0;
        }
        int i = 0;
        for (class_3222 player : class_2186.method_9312(ctx, (String)"target")) {
            PlayerData.get(player).unlockQuest(res);
            ((class_2168)ctx.getSource()).method_9226((class_2561)class_2561.method_43469((String)ConfigHandler.lang.get("simplequests.unlock"), (Object[])new Object[]{player.method_5477(), res}), true);
            ++i;
        }
        return i;
    }

    public static CompletableFuture<Suggestions> quests(CommandContext<class_2168> context, SuggestionsBuilder build) throws CommandSyntaxException {
        return class_2172.method_9265(QuestCommand.acceptableQuests(((class_2168)context.getSource()).method_9207()), (SuggestionsBuilder)build);
    }

    public static CompletableFuture<Suggestions> activequests(CommandContext<class_2168> context, SuggestionsBuilder build) throws CommandSyntaxException {
        return class_2172.method_9265(PlayerData.get(((class_2168)context.getSource()).method_9207()).getCurrentQuest().stream().map(prog -> prog.getQuest().id.toString()).toList(), (SuggestionsBuilder)build);
    }

    private static List<String> acceptableQuests(class_3222 player) {
        return QuestsManager.instance().getAllQuests().entrySet().stream().filter(e -> PlayerData.get(player).canAcceptQuest((Quest)e.getValue()) == PlayerData.AcceptType.ACCEPT).map(e -> ((class_2960)e.getKey()).toString()).collect(Collectors.toList());
    }

    public static CompletableFuture<Suggestions> lockedQuests(CommandContext<class_2168> context, SuggestionsBuilder build) throws CommandSyntaxException {
        return class_2172.method_9265((Iterable)QuestsManager.instance().getAllQuests().entrySet().stream().filter(e -> ((Quest)e.getValue()).needsUnlock).map(e -> ((class_2960)e.getKey()).toString()).collect(Collectors.toList()), (SuggestionsBuilder)build);
    }

    public static CompletableFuture<Suggestions> questCategories(CommandContext<class_2168> context, SuggestionsBuilder build) throws CommandSyntaxException {
        return class_2172.method_9265((Iterable)QuestsManager.instance().getCategories().keySet().stream().map(class_2960::toString).collect(Collectors.toList()), (SuggestionsBuilder)build);
    }
}

