/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.simplequests.datapack;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import io.github.flemmli97.simplequests.SimpleQuests;
import io.github.flemmli97.simplequests.quest.Quest;
import io.github.flemmli97.simplequests.quest.QuestCategory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

public class QuestsManager
extends class_4080<ResourceResult> {
    public static final String CATEGORY_LOCATION = "simplequests_categories";
    public static final String QUEST_LOCATION = "simplequests";
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private static final Gson GSON = new GsonBuilder().create();
    private static final QuestsManager INSTANCE = new QuestsManager();
    private Map<class_2960, QuestCategory> categories;
    private Map<class_2960, QuestCategory> selectableCategories;
    private List<QuestCategory> categoryView;
    private Map<class_2960, Quest> questMap;
    private Map<QuestCategory, Map<class_2960, Quest>> quests;
    private Map<QuestCategory, Set<Quest>> dailyQuests;

    public static QuestsManager instance() {
        return INSTANCE;
    }

    protected ResourceResult prepare(class_3300 resourceManager, class_3695 profiler) {
        return new ResourceResult(this.readFiles(resourceManager, CATEGORY_LOCATION), this.readFiles(resourceManager, QUEST_LOCATION));
    }

    private Map<class_2960, JsonElement> readFiles(class_3300 resourceManager, String directory) {
        int i = directory.length() + 1;
        HashMap map = Maps.newHashMap();
        resourceManager.method_14488(directory, file -> file.method_12832().endsWith(".json")).forEach((fileRes, resource) -> {
            String path = fileRes.method_12832();
            class_2960 id = new class_2960(fileRes.method_12836(), path.substring(i, path.length() - PATH_SUFFIX_LENGTH));
            try (BufferedReader reader = resource.method_43039();){
                JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonElement.class);
                if (jsonElement != null) {
                    JsonElement jsonElement2 = map.put(id, jsonElement);
                    if (jsonElement2 != null) {
                        throw new IllegalStateException("Duplicate data file ignored with ID " + id);
                    }
                } else {
                    SimpleQuests.logger.error("Couldn't load data file {} from {} as it's null or empty", (Object)id, fileRes);
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                SimpleQuests.logger.error("Couldn't parse data file {} from {}", new Object[]{id, fileRes, e});
            }
        });
        return map;
    }

    public void apply(ResourceResult result, class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder categoryBuilder = new ImmutableMap.Builder();
        categoryBuilder.put((Object)QuestCategory.DEFAULT_CATEGORY.id, (Object)QuestCategory.DEFAULT_CATEGORY);
        result.categories.forEach((res, el) -> {
            JsonObject obj;
            if (el.isJsonObject() && !(obj = el.getAsJsonObject()).keySet().isEmpty()) {
                categoryBuilder.put(res, (Object)QuestCategory.of(res, obj));
            }
        });
        categoryBuilder.orderEntriesByValue(QuestCategory::compareTo);
        this.categories = categoryBuilder.build();
        this.selectableCategories = (Map)this.categories.entrySet().stream().filter(e -> ((QuestCategory)e.getValue()).canBeSelected).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        this.categoryView = this.categories.values().stream().toList();
        HashMap<QuestCategory, ImmutableMap.Builder> map = new HashMap<QuestCategory, ImmutableMap.Builder>();
        result.quests.forEach((res, el) -> {
            if (el.isJsonObject()) {
                try {
                    JsonObject obj = el.getAsJsonObject();
                    if (!obj.keySet().isEmpty()) {
                        String cat = class_3518.method_15253((JsonObject)obj, (String)"category", (String)"");
                        QuestCategory questCategory = QuestCategory.DEFAULT_CATEGORY;
                        if (!cat.isEmpty() && (questCategory = this.categories.get(new class_2960(cat))) == null) {
                            throw new JsonSyntaxException("Quest category of " + cat + " for quest " + res + " doesn't exist!");
                        }
                        Quest quest = Quest.of(res, questCategory, el.getAsJsonObject());
                        map.computeIfAbsent(questCategory, c -> new ImmutableMap.Builder()).put(res, (Object)quest);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        map.forEach((category, builder) -> builder.orderEntriesByValue(Quest::compareTo));
        this.quests = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((ImmutableMap.Builder)e.getValue()).build()));
        this.questMap = (Map)this.quests.values().stream().flatMap(m -> m.entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap daily = new HashMap();
        this.quests.forEach((cat, q) -> daily.put(cat, q.values().stream().filter(quest -> quest.isDailyQuest).collect(Collectors.toSet())));
        this.dailyQuests = ImmutableMap.copyOf(daily);
    }

    public Map<class_2960, Quest> getAllQuests() {
        return this.questMap;
    }

    public Map<class_2960, Quest> getQuestsForCategoryID(class_2960 res) {
        QuestCategory category = this.getQuestCategory(res);
        if (category == null) {
            throw new IllegalArgumentException("No such category for " + res);
        }
        return this.getQuestsForCategory(category);
    }

    public Map<class_2960, Quest> getQuestsForCategory(QuestCategory category) {
        return this.quests.getOrDefault(category, Map.of());
    }

    public Set<Quest> getDailyQuests() {
        return this.getDailyQuests(QuestCategory.DEFAULT_CATEGORY);
    }

    public Set<Quest> getDailyQuests(QuestCategory category) {
        return this.dailyQuests.getOrDefault(category, Set.of());
    }

    public QuestCategory getQuestCategory(class_2960 res) {
        if (res.equals((Object)QuestCategory.DEFAULT_CATEGORY.id)) {
            return QuestCategory.DEFAULT_CATEGORY;
        }
        return this.categories.get(res);
    }

    public Map<class_2960, QuestCategory> getSelectableCategories() {
        return this.selectableCategories;
    }

    public Map<class_2960, QuestCategory> getCategories() {
        return this.categories;
    }

    public List<QuestCategory> categories() {
        return this.categoryView;
    }

    protected record ResourceResult(Map<class_2960, JsonElement> categories, Map<class_2960, JsonElement> quests) {
    }
}

