/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.simplequests.datapack.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.flemmli97.simplequests.quest.Quest;
import io.github.flemmli97.simplequests.quest.QuestCategory;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class QuestProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<class_2960, QuestCategory> categories = new HashMap<class_2960, QuestCategory>();
    private final Map<class_2960, Quest> quests = new HashMap<class_2960, Quest>();
    protected final class_2403 gen;
    protected final boolean full;

    public QuestProvider(class_2403 gen, boolean full) {
        this.gen = gen;
        this.full = full;
    }

    protected abstract void add();

    public void method_10319(class_7403 cache) {
        this.add();
        this.categories.forEach((res, builder) -> {
            Path path = this.gen.method_10313().resolve("data/" + res.method_12836() + "/simplequests_categories/" + res.method_12832() + ".json");
            try {
                JsonObject obj = builder.serialize(this.full);
                class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save quest category {}", (Object)path, (Object)e);
            }
        });
        this.quests.forEach((res, builder) -> {
            Path path = this.gen.method_10313().resolve("data/" + res.method_12836() + "/simplequests/" + res.method_12832() + ".json");
            try {
                JsonObject obj = builder.serialize(false, this.full);
                class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save quest {}", (Object)path, (Object)e);
            }
        });
    }

    public String method_10321() {
        return "Quests";
    }

    public void addQuest(Quest.Builder builder) {
        Comparable<Quest> prev;
        Quest quest = builder.build();
        if (quest.category != QuestCategory.DEFAULT_CATEGORY) {
            prev = this.categories.get(quest.category.id);
            if (prev != null && prev != quest.category) {
                throw new IllegalStateException("Category with " + quest.category.id + " already registered. Try reusing the category instead of creating a new one.");
            }
            this.categories.put(quest.category.id, quest.category);
        }
        if ((prev = this.quests.get(quest.id)) != null) {
            throw new IllegalStateException("Quest with " + quest.id + " already registered");
        }
        this.quests.put(quest.id, quest);
    }
}

