/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.simplequests.gui;

import io.github.flemmli97.simplequests.SimpleQuests;
import io.github.flemmli97.simplequests.config.ConfigHandler;
import io.github.flemmli97.simplequests.datapack.QuestsManager;
import io.github.flemmli97.simplequests.gui.QuestGui;
import io.github.flemmli97.simplequests.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.simplequests.gui.inv.SeparateInv;
import io.github.flemmli97.simplequests.quest.QuestCategory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;

public class QuestCategoryGui
extends ServerOnlyScreenHandler<Object> {
    public static int ENTRY_PER_PAGE = 12;
    private int page;
    private int maxPages;
    private List<class_2960> categories;
    private final class_3222 player;

    protected QuestCategoryGui(int syncId, class_1661 playerInventory) {
        super(syncId, playerInventory, 6, null);
        if (!(playerInventory.field_7546 instanceof class_3222)) {
            throw new IllegalStateException("This is a server side container");
        }
        this.player = (class_3222)playerInventory.field_7546;
    }

    public static void openGui(class_1657 player) {
        class_3908 fac = new class_3908(){

            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new QuestCategoryGui(syncId, inv);
            }

            public class_2561 method_5476() {
                return class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.gui.main"));
            }
        };
        player.method_17355(fac);
    }

    private class_1799 ofCategory(int i, QuestCategory category, class_3222 player) {
        class_1799 stack = category.getIcon();
        stack.method_7977((class_2561)category.getName().method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1065)));
        class_2499 lore = new class_2499();
        for (String comp : category.description) {
            lore.add((Object)class_2519.method_23256((String)comp));
        }
        stack.method_7911("display").method_10566("Lore", (class_2520)lore);
        stack.method_7911("SimpleQuests").method_10582("QuestCategory", category.id.toString());
        return stack;
    }

    public static class_1799 emptyFiller() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8871);
        stack.method_7977((class_2561)class_2561.method_43470((String)""));
        return stack;
    }

    private static void playSongToPlayer(class_3222 player, class_3414 event, float vol, float pitch) {
        player.field_13987.method_14364((class_2596)new class_2767(event, class_3419.field_15248, player.method_19538().field_1352, player.method_19538().field_1351, player.method_19538().field_1350, vol, pitch, player.method_6051().method_43055()));
    }

    @Override
    protected void fillInventoryWith(class_1657 player, SeparateInv inv, Object additionalData) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        Map<class_2960, QuestCategory> categoryMap = QuestsManager.instance().getSelectableCategories();
        this.categories = new ArrayList<class_2960>(categoryMap.keySet());
        this.categories.removeIf(res -> QuestsManager.instance().getQuestsForCategory((QuestCategory)categoryMap.get(res)).isEmpty());
        this.maxPages = (this.categories.size() - 1) / ENTRY_PER_PAGE;
        int id = 0;
        for (int i = 0; i < 54; ++i) {
            class_1799 stack;
            if (i == 8 && this.categories.size() > ENTRY_PER_PAGE) {
                class_1799 close = new class_1799((class_1935)class_1802.field_8107);
                close.method_7977((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.gui.next")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1068)));
                inv.updateStack(i, close);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                inv.updateStack(i, QuestCategoryGui.emptyFiller());
                continue;
            }
            if (i % 9 != 1 && i % 9 != 4 && i % 9 != 7 || id >= this.categories.size() || (stack = this.ofCategory(i, categoryMap.get(this.categories.get(id)), serverPlayer)).method_7960()) continue;
            inv.updateStack(i, this.ofCategory(i, categoryMap.get(this.categories.get(id)), serverPlayer));
            ++id;
        }
    }

    private void flipPage() {
        Map<class_2960, QuestCategory> categoryMap = QuestsManager.instance().getSelectableCategories();
        int id = this.page * ENTRY_PER_PAGE;
        for (int i = 0; i < 54; ++i) {
            class_1799 stack;
            if (i == 0) {
                stack = QuestCategoryGui.emptyFiller();
                if (this.page > 0) {
                    stack = new class_1799((class_1935)class_1802.field_8107);
                    stack.method_7977((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.gui.previous")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1068)));
                }
                ((class_1735)this.field_7761.get(i)).method_7673(stack);
                continue;
            }
            if (i == 8) {
                stack = QuestCategoryGui.emptyFiller();
                if (this.page < this.maxPages) {
                    stack = new class_1799((class_1935)class_1802.field_8107);
                    stack.method_7977((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.gui.next")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1068)));
                }
                ((class_1735)this.field_7761.get(i)).method_7673(stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((class_1735)this.field_7761.get(i)).method_7673(QuestCategoryGui.emptyFiller());
                continue;
            }
            if (i % 9 != 1 && i % 9 != 4 && i % 9 != 7) continue;
            if (id < this.categories.size()) {
                ((class_1735)this.field_7761.get(i)).method_7673(this.ofCategory(i, categoryMap.get(this.categories.get(id)), this.player));
                ++id;
                continue;
            }
            ((class_1735)this.field_7761.get(i)).method_7673(class_1799.field_8037);
        }
        this.method_7623();
    }

    @Override
    protected boolean handleSlotClicked(class_3222 player, int index, class_1735 slot, int clickType) {
        if (index == 0) {
            --this.page;
            this.flipPage();
            QuestCategoryGui.playSongToPlayer(player, class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 8) {
            ++this.page;
            this.flipPage();
            QuestCategoryGui.playSongToPlayer(player, class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        class_1799 stack = slot.method_7677();
        if (!stack.method_7985()) {
            return false;
        }
        class_2487 tag = stack.method_7969().method_10562("SimpleQuests");
        if (!tag.method_10545("QuestCategory")) {
            return false;
        }
        class_2960 id = new class_2960(tag.method_10558("QuestCategory"));
        QuestCategory category = QuestsManager.instance().getQuestCategory(id);
        if (category == null) {
            SimpleQuests.logger.error("No such category " + id);
            return false;
        }
        player.method_7346();
        player.method_5682().execute(() -> QuestGui.openGui((class_1657)player, category));
        return true;
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return this.page > 0 && slot == 0 || this.page < this.maxPages && slot == 8 || slot < 45 && slot > 8 && (slot % 9 == 1 || slot % 9 == 4 || slot % 9 == 7);
    }
}

