/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.simplequests.gui;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.simplequests.SimpleQuests;
import io.github.flemmli97.simplequests.config.ConfigHandler;
import io.github.flemmli97.simplequests.datapack.QuestsManager;
import io.github.flemmli97.simplequests.gui.ConfirmScreenHandler;
import io.github.flemmli97.simplequests.gui.QuestCategoryGui;
import io.github.flemmli97.simplequests.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.simplequests.gui.inv.SeparateInv;
import io.github.flemmli97.simplequests.player.PlayerData;
import io.github.flemmli97.simplequests.quest.Quest;
import io.github.flemmli97.simplequests.quest.QuestCategory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_5250;

public class QuestGui
extends ServerOnlyScreenHandler<Pair<QuestCategory, Boolean>> {
    public static int QUEST_PER_PAGE = 12;
    private int page;
    private int maxPages;
    private List<class_2960> quests;
    private final class_3222 player;
    private final QuestCategory category;
    private final boolean canGoBack;
    private Map<Integer, Quest> updateList;
    private final List<Integer> toremove = new ArrayList<Integer>();

    protected QuestGui(int syncId, class_1661 playerInventory, Pair<QuestCategory, Boolean> data) {
        super(syncId, playerInventory, 6, data);
        this.category = (QuestCategory)data.getFirst();
        this.canGoBack = (Boolean)data.getSecond();
        if (!(playerInventory.field_7546 instanceof class_3222)) {
            throw new IllegalStateException("This is a server side container");
        }
        this.player = (class_3222)playerInventory.field_7546;
    }

    public static void openGui(class_1657 player, QuestCategory category) {
        QuestGui.openGui(player, category, true);
    }

    public static void openGui(class_1657 player, final QuestCategory category, final boolean canGoBack) {
        class_3908 fac = new class_3908(){

            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new QuestGui(syncId, inv, (Pair<QuestCategory, Boolean>)Pair.of((Object)category, (Object)canGoBack));
            }

            public class_2561 method_5476() {
                return category == null || category == QuestCategory.DEFAULT_CATEGORY ? class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.gui.main")) : category.getName();
            }
        };
        player.method_17355(fac);
    }

    private class_1799 ofQuest(int i, Quest quest, class_3222 player) {
        PlayerData data = PlayerData.get(player);
        PlayerData.AcceptType type = data.canAcceptQuest(quest);
        class_1799 stack = type == PlayerData.AcceptType.ACCEPT ? quest.getIcon() : new class_1799((class_1935)class_1802.field_8529);
        stack.method_7977((class_2561)quest.getTask().method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1065)));
        class_2499 lore = new class_2499();
        if (data.isActive(quest)) {
            stack.method_7978(class_1893.field_9119, 1);
            stack.method_30268(class_1799.class_5422.field_25768);
        }
        if (type == PlayerData.AcceptType.DELAY) {
            lore.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43469((String)ConfigHandler.lang.get(type.langKey()), (Object[])new Object[]{data.formattedCooldown(quest)}).method_27692(class_124.field_1079))));
            this.updateList.put(i, quest);
        }
        for (class_5250 comp : quest.getFormattedGuiTasks(player)) {
            lore.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)comp.method_10862(comp.method_10866().method_10978(Boolean.valueOf(false))))));
        }
        stack.method_7911("display").method_10566("Lore", (class_2520)lore);
        stack.method_7911("SimpleQuests").method_10582("Quest", quest.id.toString());
        return stack;
    }

    public static class_1799 emptyFiller() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8871);
        stack.method_7977((class_2561)class_2561.method_43470((String)""));
        return stack;
    }

    private static void playSongToPlayer(class_3222 player, class_3414 event, float vol, float pitch) {
        player.field_13987.method_14364((class_2596)new class_2767(event, class_3419.field_15248, player.method_19538().field_1352, player.method_19538().field_1351, player.method_19538().field_1350, vol, pitch, player.method_6051().method_43055()));
    }

    @Override
    protected void fillInventoryWith(class_1657 player, SeparateInv inv, Pair<QuestCategory, Boolean> data) {
        this.updateList = new HashMap<Integer, Quest>();
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        Map<class_2960, Quest> questMap = QuestsManager.instance().getQuestsForCategory((QuestCategory)data.getFirst());
        this.quests = new ArrayList<class_2960>(questMap.keySet());
        this.quests.removeIf(res -> {
            PlayerData.AcceptType type = PlayerData.get(serverPlayer).canAcceptQuest((Quest)questMap.get(res));
            return type == PlayerData.AcceptType.REQUIREMENTS || type == PlayerData.AcceptType.ONETIME || type == PlayerData.AcceptType.DAILYFULL || type == PlayerData.AcceptType.LOCKED;
        });
        this.maxPages = (this.quests.size() - 1) / QUEST_PER_PAGE;
        int id = 0;
        for (int i = 0; i < 54; ++i) {
            class_1799 stack;
            if (i == 8 && this.quests.size() > QUEST_PER_PAGE) {
                class_1799 close = new class_1799((class_1935)class_1802.field_8107);
                close.method_7977((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.gui.next")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1068)));
                inv.updateStack(i, close);
                continue;
            }
            if (((Boolean)data.getSecond()).booleanValue() && i == 45) {
                stack = new class_1799((class_1935)class_1802.field_8626);
                stack.method_7977((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.gui.button.main")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1068)));
                inv.updateStack(i, stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                inv.updateStack(i, QuestGui.emptyFiller());
                continue;
            }
            if (i % 9 != 1 && i % 9 != 4 && i % 9 != 7 || id >= this.quests.size() || (stack = this.ofQuest(i, questMap.get(this.quests.get(id)), serverPlayer)).method_7960()) continue;
            inv.updateStack(i, this.ofQuest(i, questMap.get(this.quests.get(id)), serverPlayer));
            ++id;
        }
    }

    private void flipPage() {
        this.updateList.clear();
        Map<class_2960, Quest> questMap = QuestsManager.instance().getQuestsForCategory(this.category);
        int id = this.page * QUEST_PER_PAGE;
        for (int i = 0; i < 54; ++i) {
            class_1799 stack;
            if (i == 0) {
                stack = QuestGui.emptyFiller();
                if (this.page > 0) {
                    stack = new class_1799((class_1935)class_1802.field_8107);
                    stack.method_7977((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.gui.previous")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1068)));
                }
                ((class_1735)this.field_7761.get(i)).method_7673(stack);
                continue;
            }
            if (i == 8) {
                stack = QuestGui.emptyFiller();
                if (this.page < this.maxPages) {
                    stack = new class_1799((class_1935)class_1802.field_8107);
                    stack.method_7977((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.gui.next")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1068)));
                }
                ((class_1735)this.field_7761.get(i)).method_7673(stack);
                continue;
            }
            if (this.canGoBack && i == 45) {
                stack = new class_1799((class_1935)class_1802.field_8626);
                stack.method_7977((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.gui.button.main")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1068)));
                ((class_1735)this.field_7761.get(i)).method_7673(stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((class_1735)this.field_7761.get(i)).method_7673(QuestGui.emptyFiller());
                continue;
            }
            if (i % 9 != 1 && i % 9 != 4 && i % 9 != 7) continue;
            if (id < this.quests.size()) {
                ((class_1735)this.field_7761.get(i)).method_7673(this.ofQuest(i, questMap.get(this.quests.get(id)), this.player));
                ++id;
                continue;
            }
            ((class_1735)this.field_7761.get(i)).method_7673(class_1799.field_8037);
        }
        this.method_7623();
    }

    @Override
    protected boolean handleSlotClicked(class_3222 player, int index, class_1735 slot, int clickType) {
        if (index == 0) {
            --this.page;
            this.flipPage();
            QuestGui.playSongToPlayer(player, class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 8) {
            ++this.page;
            this.flipPage();
            QuestGui.playSongToPlayer(player, class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (this.canGoBack && index == 45) {
            player.method_7346();
            player.method_5682().execute(() -> QuestCategoryGui.openGui((class_1657)player));
            QuestGui.playSongToPlayer(player, class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        class_1799 stack = slot.method_7677();
        if (!stack.method_7985()) {
            return false;
        }
        class_2487 tag = stack.method_7969().method_10562("SimpleQuests");
        if (!tag.method_10545("Quest")) {
            return false;
        }
        if (stack.method_7909() == class_1802.field_8529) {
            QuestGui.playSongToPlayer(player, class_3417.field_15008, 1.0f, 1.0f);
            return false;
        }
        class_2960 id = new class_2960(tag.method_10558("Quest"));
        Quest quest = QuestsManager.instance().getQuestsForCategory(this.category).get(id);
        if (quest == null) {
            SimpleQuests.logger.error("No such quest " + id);
            return false;
        }
        boolean remove = stack.method_7942();
        ConfirmScreenHandler.openConfirmScreen(player, b -> {
            if (b.booleanValue()) {
                player.method_7346();
                if (remove) {
                    PlayerData.get(player).reset(quest.id, true);
                    QuestGui.playSongToPlayer(player, class_3417.field_14727, 1.0f, 1.2f);
                } else if (PlayerData.get(player).acceptQuest(quest)) {
                    QuestGui.playSongToPlayer(player, class_3417.field_14622, 1.0f, 1.2f);
                } else {
                    QuestGui.playSongToPlayer(player, class_3417.field_15008, 1.0f, 1.0f);
                }
            } else {
                player.method_7346();
                player.method_5682().execute(() -> QuestGui.openGui((class_1657)player, this.category, this.canGoBack));
                QuestGui.playSongToPlayer(player, class_3417.field_15008, 1.0f, 1.0f);
            }
        }, remove ? "simplequests.gui.reset" : "simplequests.gui.confirm");
        return true;
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return this.page > 0 && slot == 0 || this.page < this.maxPages && slot == 8 || this.canGoBack && slot == 45 || slot < 45 && slot > 8 && (slot % 9 == 1 || slot % 9 == 4 || slot % 9 == 7);
    }

    public void update() {
        PlayerData data = PlayerData.get(this.player);
        this.toremove.removeIf(i -> {
            ((class_1735)this.field_7761.get(i.intValue())).method_7673(this.ofQuest((int)i, this.updateList.get(i), this.player));
            this.updateList.remove(i);
            return true;
        });
        this.updateList.forEach((i, q) -> {
            class_1799 stack = ((class_1735)this.field_7761.get(i.intValue())).method_7677();
            class_2499 tag = stack.method_7911("display").method_10554("Lore", 8);
            String delay = data.formattedCooldown((Quest)q);
            tag.method_10606(0, (class_2520)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43469((String)ConfigHandler.lang.get(PlayerData.AcceptType.DELAY.langKey()), (Object[])new Object[]{delay}).method_27692(class_124.field_1079))));
            if (delay.equals("0s")) {
                this.toremove.add((Integer)i);
            }
        });
    }
}

