/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.simplequests.player;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.simplequests.api.SimpleQuestAPI;
import io.github.flemmli97.simplequests.config.ConfigHandler;
import io.github.flemmli97.simplequests.datapack.QuestsManager;
import io.github.flemmli97.simplequests.player.QuestProgress;
import io.github.flemmli97.simplequests.player.SimpleQuestDataGet;
import io.github.flemmli97.simplequests.quest.Quest;
import io.github.flemmli97.simplequests.quest.QuestEntry;
import io.github.flemmli97.simplequests.quest.QuestEntryImpls;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_47;
import net.minecraft.class_52;

public class PlayerData {
    public static final DateTimeFormatter time = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final class_3222 player;
    private List<QuestProgress> currentQuests = new ArrayList<QuestProgress>();
    private Map<class_2960, Long> cooldownTracker = new HashMap<class_2960, Long>();
    private List<QuestProgress> tickables = new ArrayList<QuestProgress>();
    private Set<class_2960> unlockTracker = new HashSet<class_2960>();
    private long resetTick = -1L;
    private LocalDateTime questTrackerTime = LocalDateTime.now();
    private final Map<class_2960, Integer> dailyQuestsTracker = new HashMap<class_2960, Integer>();
    private int interactionCooldown;

    public static PlayerData get(class_3222 player) {
        return ((SimpleQuestDataGet)player).simpleQuestPlayerData();
    }

    public PlayerData(class_3222 player) {
        this.player = player;
    }

    public boolean acceptQuest(Quest quest) {
        int maxConcurrent = quest.category.getMaxConcurrentQuests();
        if (maxConcurrent > 0 && this.currentQuests.stream().filter(p -> !p.getQuest().isDailyQuest && !quest.category.sameCategoryOnly || p.getQuest().category == quest.category).toList().size() >= maxConcurrent) {
            this.player.method_43496((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.active.full")).method_27692(class_124.field_1079));
            return false;
        }
        if (this.isActive(quest)) {
            this.player.method_43496((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.active")).method_27692(class_124.field_1079));
            return false;
        }
        AcceptType type = this.canAcceptQuest(quest);
        if (type != AcceptType.ACCEPT) {
            if (type == AcceptType.DELAY) {
                this.player.method_43496((class_2561)class_2561.method_43471((String)String.format(ConfigHandler.lang.get(type.langKey()), this.formattedCooldown(quest))).method_27692(class_124.field_1079));
            } else {
                this.player.method_43496((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get(type.langKey())).method_27692(class_124.field_1079));
            }
            return false;
        }
        this.currentQuests.add(new QuestProgress(quest, this));
        this.player.method_43496((class_2561)class_2561.method_43469((String)ConfigHandler.lang.get("simplequests.accept"), (Object[])new Object[]{quest.getFormatted(this.player.method_5682(), new class_124[0])}).method_27692(class_124.field_1077));
        return true;
    }

    public boolean submit(String trigger, boolean sendFailMessage) {
        if (this.currentQuests.isEmpty()) {
            if (sendFailMessage) {
                this.player.method_43496((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.current.no")).method_27692(class_124.field_1079));
            }
            return false;
        }
        boolean any = false;
        ArrayList<QuestProgress> completed = new ArrayList<QuestProgress>();
        for (QuestProgress prog : this.currentQuests) {
            switch (prog.submit(this.player, trigger)) {
                case COMPLETE: {
                    this.completeQuest(prog);
                    completed.add(prog);
                    any = true;
                    break;
                }
                case PARTIAL: {
                    this.player.field_6002.method_43128(null, this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), class_3417.field_14815, this.player.method_5634(), 1.5f, 1.0f);
                    break;
                }
                case NOTHING: {
                    if (!sendFailMessage) break;
                    this.player.field_6002.method_43128(null, this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), class_3417.field_15008, this.player.method_5634(), 1.5f, 1.0f);
                }
            }
        }
        this.currentQuests.removeAll(completed);
        return any;
    }

    public <T extends QuestEntry> void tryFullFill(Class<T> clss, SimpleQuestAPI.QuestEntryPredicate<T> pred, BiConsumer<QuestProgress, Pair<String, T>> onFullfill) {
        this.tryFullFill(clss, pred, onFullfill, "");
    }

    public <T extends QuestEntry> void tryFullFill(Class<T> clss, SimpleQuestAPI.QuestEntryPredicate<T> pred, BiConsumer<QuestProgress, Pair<String, T>> onFullfill, String trigger) {
        ArrayList completed = new ArrayList();
        this.currentQuests.forEach(prog -> {
            Set<Pair<String, Pair>> fulfilled = prog.tryFullFill(clss, pred);
            if (!fulfilled.isEmpty()) {
                this.player.field_6002.method_43128(null, this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), class_3417.field_14709, this.player.method_5634(), 1.5f, 1.0f);
                fulfilled.forEach(p -> onFullfill.accept((QuestProgress)prog, (Pair)p));
            }
            if (prog.isCompleted(trigger)) {
                this.completeQuest((QuestProgress)prog);
                completed.add(prog);
            }
        });
        this.currentQuests.removeAll(completed);
    }

    public void onKill(class_1309 entity) {
        this.tryFullFill(QuestEntryImpls.KillEntry.class, QuestProgress.createKillPredicate(this.player, entity), (prog, p) -> this.player.method_43496((class_2561)class_2561.method_43469((String)ConfigHandler.lang.get("simplequests.kill"), (Object[])new Object[]{((QuestEntryImpls.KillEntry)p.getSecond()).translation(this.player.method_5682())}).method_27692(class_124.field_1077)));
    }

    public void onInteractWith(class_1297 entity) {
        if (this.interactionCooldown > 0) {
            return;
        }
        this.interactionCooldown = 2;
        this.tryFullFill(QuestEntryImpls.EntityInteractEntry.class, QuestProgress.createInteractionPredicate(this.player, entity), (prog, p) -> this.player.method_43496((class_2561)class_2561.method_43469((String)ConfigHandler.lang.get("simplequests.task"), (Object[])new Object[]{((QuestEntryImpls.EntityInteractEntry)p.getSecond()).translation(this.player.method_5682())}).method_27692(class_124.field_1077)));
    }

    public void onBlockInteract(class_2338 pos, boolean use) {
        this.tryFullFill(QuestEntryImpls.BlockInteractEntry.class, QuestProgress.createBlockInteractionPredicate(this.player, pos, use), (prog, p) -> this.player.method_43496((class_2561)class_2561.method_43469((String)ConfigHandler.lang.get("simplequests.task"), (Object[])new Object[]{((QuestEntryImpls.BlockInteractEntry)p.getSecond()).translation(this.player.method_5682())}).method_27692(class_124.field_1077)));
    }

    public void onItemCrafted(class_1799 stack, int amount, String trigger) {
        this.tryFullFill(QuestEntryImpls.CraftingEntry.class, QuestProgress.createCraftingPredicate(this.player, stack, amount), (prog, p) -> this.player.method_43496((class_2561)class_2561.method_43469((String)ConfigHandler.lang.get("simplequests.task"), (Object[])new Object[]{((QuestEntryImpls.CraftingEntry)p.getSecond()).translation(this.player.method_5682())}).method_27692(class_124.field_1077)));
    }

    private void completeQuest(QuestProgress prog) {
        class_52 lootTable = this.player.method_5682().method_3857().method_367(prog.getQuest().loot);
        class_174.field_24479.method_27993(this.player, prog.getQuest().loot);
        class_47.class_48 builder = new class_47.class_48(this.player.method_14220()).method_312(class_181.field_24424, (Object)this.player.method_19538()).method_312(class_181.field_1231, (Object)class_1282.field_5846).method_312(class_181.field_1226, (Object)this.player).method_303(this.player.method_7292());
        ObjectArrayList loot = lootTable.method_319(builder.method_309(class_173.field_1173));
        loot.forEach(stack -> {
            class_1542 itemEntity;
            boolean bl = this.player.method_31548().method_7394(stack);
            if (!(bl && stack.method_7960() || (itemEntity = this.player.method_7328(stack, false)) == null)) {
                itemEntity.method_6975();
                itemEntity.method_6984(this.player.method_5667());
            }
        });
        if (!prog.getQuest().command.isEmpty()) {
            this.player.method_5682().method_3734().method_44252(this.player.method_5671(), prog.getQuest().command);
        }
        this.cooldownTracker.put(prog.getQuest().id, this.player.field_6002.method_8510());
        this.unlockTracker.add(prog.getQuest().id);
        this.player.field_6002.method_43128(null, this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), class_3417.field_14709, this.player.method_5634(), 1.5f, 1.0f);
        this.player.method_43496((class_2561)class_2561.method_43471((String)String.format(ConfigHandler.lang.get("simplequests.finish"), prog.getQuest().getTask())).method_27692(class_124.field_1077));
        if (!prog.getQuest().neededParentQuests.isEmpty() && prog.getQuest().redoParent) {
            prog.getQuest().neededParentQuests.forEach(res -> {
                Quest quest = QuestsManager.instance().getAllQuests().get(res);
                if (quest != null) {
                    this.unlockTracker.remove(quest.id);
                }
            });
        }
    }

    public void reset(class_2960 res, boolean forced) {
        this.reset(res, forced, true);
    }

    public void reset(class_2960 res, boolean forced, boolean sendMsg) {
        if (this.currentQuests.isEmpty()) {
            if (sendMsg) {
                this.player.method_43496((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.current.no")).method_27692(class_124.field_1079));
            }
            return;
        }
        QuestProgress prog = null;
        for (QuestProgress p : this.currentQuests) {
            if (!p.getQuest().id.equals((Object)res)) continue;
            prog = p;
            break;
        }
        if (prog == null) {
            if (sendMsg) {
                this.player.method_43496((class_2561)class_2561.method_43471((String)String.format(ConfigHandler.lang.get("simplequests.reset.notfound"), res)).method_27692(class_124.field_1079));
            }
            return;
        }
        if (!forced && this.resetTick == -1L) {
            this.resetTick = this.player.field_6002.method_8510();
            if (sendMsg) {
                this.player.method_43496((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.reset.confirm")).method_27692(class_124.field_1079));
            }
            return;
        }
        if (forced || this.player.field_6002.method_8510() - this.resetTick < 600L) {
            if (sendMsg) {
                this.player.method_43496((class_2561)class_2561.method_43471((String)String.format(ConfigHandler.lang.get("simplequests.reset"), prog.getQuest().getTask())).method_27692(class_124.field_1079));
            }
            this.currentQuests.remove(prog);
        }
        this.resetTick = -1L;
    }

    public List<QuestProgress> getCurrentQuest() {
        return this.currentQuests;
    }

    public boolean isActive(Quest quest) {
        return this.currentQuests.stream().anyMatch(prog -> prog.getQuest().id.equals((Object)quest.id));
    }

    public AcceptType canAcceptQuest(Quest quest) {
        if (quest.isDailyQuest || quest.needsUnlock && !this.unlockTracker.contains(quest.id)) {
            return AcceptType.LOCKED;
        }
        if (!quest.unlockCondition.method_8914(this.player, (class_1297)this.player) || !quest.neededParentQuests.isEmpty() && !this.unlockTracker.containsAll(quest.neededParentQuests)) {
            return AcceptType.REQUIREMENTS;
        }
        if (quest.repeatDaily > 0 && this.dailyQuestsTracker.getOrDefault(quest.id, 0) >= quest.repeatDaily) {
            return AcceptType.DAILYFULL;
        }
        if (quest.repeatDelay < 0 && this.cooldownTracker.containsKey(quest.id)) {
            return AcceptType.ONETIME;
        }
        if (this.cooldownTracker.containsKey(quest.id)) {
            return quest.repeatDelay == 0 || Math.abs(this.player.field_6002.method_8510() - this.cooldownTracker.get(quest.id)) > (long)quest.repeatDelay ? AcceptType.ACCEPT : AcceptType.DELAY;
        }
        return AcceptType.ACCEPT;
    }

    public class_3222 getPlayer() {
        return this.player;
    }

    public void addTickableProgress(QuestProgress progress) {
        if (!this.tickables.contains(progress)) {
            this.tickables.add(progress);
        }
    }

    public void removeQuestProgress(QuestProgress progress) {
        this.tickables.remove(progress);
    }

    public void unlockQuest(class_2960 quest) {
        this.unlockTracker.add(quest);
    }

    public void lockQuest(class_2960 quest) {
        this.unlockTracker.remove(quest);
    }

    public void tick() {
        --this.interactionCooldown;
        ArrayList completed = new ArrayList();
        this.tickables.removeIf(prog -> {
            Pair<Boolean, Set<QuestEntry>> fulfilled = prog.tickProgress(this);
            if (!((Set)fulfilled.getSecond()).isEmpty()) {
                this.player.field_6002.method_43128(null, this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), class_3417.field_14709, this.player.method_5634(), 1.5f, 1.0f);
                ((Set)fulfilled.getSecond()).forEach(e -> this.player.method_43496((class_2561)class_2561.method_43469((String)ConfigHandler.lang.get("simplequests.task"), (Object[])new Object[]{e.translation(this.player.method_5682())}).method_27692(class_124.field_1077)));
            }
            if (prog.isCompleted("")) {
                this.completeQuest((QuestProgress)prog);
                completed.add(prog);
                return true;
            }
            return (Boolean)fulfilled.getFirst();
        });
        this.currentQuests.removeAll(completed);
        LocalDateTime now = LocalDateTime.now();
        if (this.questTrackerTime == null || this.questTrackerTime.getDayOfYear() != now.getDayOfYear()) {
            this.questTrackerTime = now;
            this.dailyQuestsTracker.forEach((r, i) -> {
                Quest quest = QuestsManager.instance().getAllQuests().get(r);
                if (quest != null && quest.isDailyQuest) {
                    this.reset((class_2960)r, true, false);
                }
            });
            this.dailyQuestsTracker.clear();
            QuestsManager.instance().getDailyQuests().forEach(quest -> {
                this.currentQuests.add(new QuestProgress((Quest)quest, this));
                this.dailyQuestsTracker.put(quest.id, 1);
            });
        }
    }

    public String formattedCooldown(Quest quest) {
        long sec = Math.max(0L, (long)quest.repeatDelay - Math.abs(this.player.field_6002.method_8510() - this.cooldownTracker.get(quest.id))) / 20L;
        if (sec > 86400L) {
            long days = sec / 86400L;
            long hours = sec % 86400L / 3600L;
            return String.format("%dd:%dh", days, hours);
        }
        if (sec >= 3600L) {
            long hours = sec / 3600L;
            long minutes = sec % 3600L / 60L;
            return String.format("%dh:%dm:%ds", hours, minutes, sec % 60L);
        }
        if (sec >= 60L) {
            long minutes = sec / 60L;
            return String.format("%dm:%ds", minutes, sec % 60L);
        }
        return String.format("%ds", sec);
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        class_2499 quests = new class_2499();
        this.currentQuests.forEach(prog -> quests.add((Object)prog.save()));
        tag.method_10566("ActiveQuests", (class_2520)quests);
        class_2487 list = new class_2487();
        this.cooldownTracker.forEach((res, time) -> list.method_10544(res.toString(), time.longValue()));
        tag.method_10566("FinishedQuests", (class_2520)list);
        if (this.questTrackerTime != null) {
            tag.method_10582("TimeTracker", this.questTrackerTime.format(PlayerData.time));
        }
        class_2487 daily = new class_2487();
        this.dailyQuestsTracker.forEach((res, amount) -> daily.method_10569(res.toString(), amount.intValue()));
        tag.method_10566("DailyQuestTracker", (class_2520)daily);
        class_2499 unlocked = new class_2499();
        this.unlockTracker.forEach(res -> unlocked.add((Object)class_2519.method_23256((String)res.toString())));
        tag.method_10566("UnlockedQuests", (class_2520)unlocked);
        return tag;
    }

    public void load(class_2487 tag) {
        if (tag.method_10545("ActiveQuests")) {
            class_2499 quests = tag.method_10554("ActiveQuests", 10);
            quests.forEach(q -> {
                try {
                    QuestProgress prog = new QuestProgress((class_2487)q, this);
                    if (prog.getQuest() != null) {
                        this.currentQuests.add(prog);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
        }
        class_2487 done = tag.method_10562("FinishedQuests");
        done.method_10541().forEach(key -> this.cooldownTracker.put(new class_2960(key), done.method_10537(key)));
        if (tag.method_10545("TimeTracker")) {
            this.questTrackerTime = LocalDateTime.parse(tag.method_10558("TimeTracker"), time);
        }
        class_2487 daily = tag.method_10562("DailyQuestTracker");
        daily.method_10541().forEach(key -> this.dailyQuestsTracker.put(new class_2960(key), done.method_10550(key)));
        class_2499 unlocked = tag.method_10554("UnlockedQuests", 8);
        unlocked.forEach(t -> this.unlockTracker.add(new class_2960(t.method_10714())));
    }

    public void clone(PlayerData data) {
        this.currentQuests = data.currentQuests;
        this.cooldownTracker = data.cooldownTracker;
        this.unlockTracker = data.unlockTracker;
    }

    public void resetAll() {
        this.currentQuests.clear();
        this.cooldownTracker.clear();
        this.unlockTracker.clear();
        this.questTrackerTime = null;
        this.dailyQuestsTracker.clear();
    }

    public void resetCooldown() {
        this.cooldownTracker.replaceAll((res, old) -> Long.MIN_VALUE);
    }

    public static enum AcceptType {
        REQUIREMENTS("simplequests.accept.requirements"),
        DAILYFULL("simplequests.accept.daily"),
        DELAY("simplequests.accept.delay"),
        ONETIME("simplequests.accept.onetime"),
        ACCEPT("simplequests.accept.yes"),
        LOCKED("simplequests.accept.locked");

        final String lang;

        private AcceptType(String id) {
            this.lang = id;
        }

        public String langKey() {
            return this.lang;
        }
    }
}

