/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.simplequests.player;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.simplequests.SimpleQuests;
import io.github.flemmli97.simplequests.api.SimpleQuestAPI;
import io.github.flemmli97.simplequests.config.ConfigHandler;
import io.github.flemmli97.simplequests.datapack.QuestsManager;
import io.github.flemmli97.simplequests.player.PlayerData;
import io.github.flemmli97.simplequests.quest.Quest;
import io.github.flemmli97.simplequests.quest.QuestEntry;
import io.github.flemmli97.simplequests.quest.QuestEntryImpls;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.Logger;

public class QuestProgress {
    private final List<String> entries = new ArrayList<String>();
    private final Map<String, Integer> killCounter = new HashMap<String, Integer>();
    private final Map<String, Set<UUID>> interactionCounter = new HashMap<String, Set<UUID>>();
    private final Map<String, Set<class_2338>> blockInteractionCounter = new HashMap<String, Set<class_2338>>();
    private final Map<String, Integer> craftingCounter = new HashMap<String, Integer>();
    private final Map<String, Function<PlayerData, Boolean>> tickables = new HashMap<String, Function<PlayerData, Boolean>>();
    private Quest quest;

    public QuestProgress(Quest quest, PlayerData data) {
        this.quest = quest;
        this.setup(data);
        if (!this.tickables.isEmpty()) {
            data.addTickableProgress(this);
        }
    }

    public QuestProgress(class_2487 tag, PlayerData data) {
        this.load(tag);
        this.setup(data);
        if (!this.tickables.isEmpty()) {
            data.addTickableProgress(this);
        }
    }

    public static SimpleQuestAPI.QuestEntryPredicate<QuestEntryImpls.KillEntry> createKillPredicate(class_3222 player, class_1309 entity) {
        return (name, entry, prog) -> {
            if (entry.predicate().method_8914(player, (class_1297)entity)) {
                int killed = prog.killCounter.compute(name, (res, i) -> {
                    int n;
                    if (i == null) {
                        n = 1;
                    } else {
                        i = i + 1;
                        n = i;
                    }
                    return n;
                });
                return killed >= entry.amount();
            }
            return false;
        };
    }

    public static SimpleQuestAPI.QuestEntryPredicate<QuestEntryImpls.EntityInteractEntry> createInteractionPredicate(class_3222 player, class_1297 entity) {
        return (name, entry, prog) -> {
            Set interacted = prog.interactionCounter.computeIfAbsent(name, s -> new HashSet());
            if (interacted.contains(entity.method_5667())) {
                player.method_43496((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.interaction.dupe")).method_27692(class_124.field_1079));
                return false;
            }
            if (entry.check(player, entity)) {
                interacted.add(entity.method_5667());
                int amount = interacted.size();
                return amount >= entry.amount();
            }
            return false;
        };
    }

    public static SimpleQuestAPI.QuestEntryPredicate<QuestEntryImpls.BlockInteractEntry> createBlockInteractionPredicate(class_3222 player, class_2338 pos, boolean use) {
        return (name, entry, prog) -> {
            Set interacted = prog.blockInteractionCounter.computeIfAbsent(name, s -> new HashSet());
            if (interacted.contains(pos)) {
                player.method_43496((class_2561)class_2561.method_43471((String)ConfigHandler.lang.get("simplequests.interaction.block.dupe." + entry.use())).method_27692(class_124.field_1079));
                return false;
            }
            if (entry.check(player, pos, use)) {
                interacted.add(pos);
                int amount = interacted.size();
                return amount >= entry.amount();
            }
            return false;
        };
    }

    public static SimpleQuestAPI.QuestEntryPredicate<QuestEntryImpls.CraftingEntry> createCraftingPredicate(class_3222 player, class_1799 stack, int amount) {
        return (name, entry, prog) -> {
            if (entry.check(player, stack)) {
                int counter = prog.craftingCounter.compute(name, (res, i) -> i == null ? amount : i + amount);
                return counter >= entry.amount();
            }
            return false;
        };
    }

    private void setup(PlayerData data) {
        this.quest.entries.forEach((s, e) -> {
            Function<PlayerData, Boolean> ticker;
            e.onAccept(data);
            if (!this.entries.contains(s) && (ticker = e.tickable()) != null) {
                this.tickables.put((String)s, ticker);
            }
        });
    }

    public Quest getQuest() {
        return this.quest;
    }

    public SubmitType submit(class_3222 player, String trigger) {
        boolean any = false;
        for (Map.Entry<String, QuestEntry> entry : this.quest.entries.entrySet()) {
            if (this.entries.contains(entry.getKey()) || !entry.getValue().submit(player)) continue;
            this.entries.add(entry.getKey());
            any = true;
        }
        boolean b = this.isCompleted(trigger);
        return b ? SubmitType.COMPLETE : (any ? SubmitType.PARTIAL : SubmitType.NOTHING);
    }

    public <T extends QuestEntry> Set<Pair<String, T>> tryFullFill(Class<T> clss, SimpleQuestAPI.QuestEntryPredicate<T> pred) {
        HashSet<Pair<String, T>> fullfilled = new HashSet<Pair<String, T>>();
        for (Map.Entry<String, QuestEntry> e : this.quest.entries.entrySet()) {
            if (this.entries.contains(e.getKey()) || !clss.isInstance(e.getValue())) continue;
            QuestEntry entry = e.getValue();
            if (!pred.matches(e.getKey(), entry, this)) continue;
            fullfilled.add(Pair.of((Object)e.getKey(), (Object)entry));
            this.entries.add(e.getKey());
        }
        return fullfilled;
    }

    public boolean isCompleted(String trigger) {
        return this.quest.questSubmissionTrigger.equals(trigger) && this.entries.containsAll(this.quest.entries.keySet());
    }

    public List<String> finishedTasks() {
        return ImmutableList.copyOf(this.entries);
    }

    public Pair<Boolean, Set<QuestEntry>> tickProgress(PlayerData data) {
        HashSet fullfilled = new HashSet();
        this.tickables.entrySet().removeIf(e -> {
            if (((Boolean)((Function)e.getValue()).apply(data)).booleanValue()) {
                fullfilled.add(this.quest.entries.get(e.getKey()));
                this.entries.add((String)e.getKey());
                return true;
            }
            return false;
        });
        return Pair.of((Object)this.tickables.isEmpty(), fullfilled);
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        tag.method_10582("Quest", this.quest.id.toString());
        class_2499 list = new class_2499();
        this.entries.forEach(res -> list.add((Object)class_2519.method_23256((String)res)));
        tag.method_10566("FinishedEntries", (class_2520)list);
        class_2487 kills = new class_2487();
        this.killCounter.forEach((arg_0, arg_1) -> ((class_2487)kills).method_10569(arg_0, arg_1));
        tag.method_10566("KillCounter", (class_2520)kills);
        class_2487 interactions = new class_2487();
        this.interactionCounter.forEach((res, i) -> {
            class_2499 l = new class_2499();
            i.forEach(uuid -> l.add((Object)class_2512.method_25929((UUID)uuid)));
            interactions.method_10566(res, (class_2520)l);
        });
        tag.method_10566("Interactions", (class_2520)interactions);
        class_2487 blockInteractions = new class_2487();
        this.blockInteractionCounter.forEach((res, i) -> {
            class_2499 l = new class_2499();
            i.forEach(pos -> l.add((Object)((class_2520)class_2338.field_25064.encodeStart((DynamicOps)class_2509.field_11560, pos).getOrThrow(false, arg_0 -> ((Logger)SimpleQuests.logger).error(arg_0)))));
            blockInteractions.method_10566(res, (class_2520)l);
        });
        tag.method_10566("BlockInteractions", (class_2520)blockInteractions);
        return tag;
    }

    public void load(class_2487 tag) {
        this.quest = QuestsManager.instance().getAllQuests().get(new class_2960(tag.method_10558("Quest")));
        if (this.quest == null) {
            SimpleQuests.logger.error("Cant find quest with id " + tag.method_10558("Quest") + ". Skipping");
            throw new IllegalStateException();
        }
        class_2499 list = tag.method_10554("FinishedEntries", 8);
        list.forEach(t -> this.entries.add(t.method_10714()));
        class_2487 kills = tag.method_10562("KillCounter");
        kills.method_10541().forEach(key -> this.killCounter.put((String)key, kills.method_10550(key)));
        class_2487 interactions = tag.method_10562("Interactions");
        interactions.method_10541().forEach(key -> {
            class_2499 l = interactions.method_10554(key, 11);
            l.forEach(t -> this.interactionCounter.computeIfAbsent((String)key, k -> new HashSet()).add(class_2512.method_25930((class_2520)t)));
        });
        class_2487 blockInteractions = tag.method_10562("BlockInteractions");
        blockInteractions.method_10541().forEach(key -> {
            class_2499 l = blockInteractions.method_10554(key, 11);
            l.forEach(t -> this.blockInteractionCounter.computeIfAbsent((String)key, k -> new HashSet()).add((class_2338)class_2338.field_25064.parse((DynamicOps)class_2509.field_11560, t).getOrThrow(true, arg_0 -> ((Logger)SimpleQuests.logger).error(arg_0))));
        });
    }

    static enum SubmitType {
        COMPLETE,
        PARTIAL,
        NOTHING;

    }
}

