/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.simplequests.quest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.simplequests.SimpleQuests;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Logger;

public class ParseHelper {
    private static final Codec<class_1799> STACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2378.field_11142.method_39673().fieldOf("item").forGetter(class_1799::method_7909), (App)Codec.INT.optionalFieldOf("count").forGetter(itemStack -> Optional.of(itemStack.method_7947())), (App)Codec.STRING.optionalFieldOf("tag").forGetter(itemStack -> Optional.ofNullable(itemStack.method_7969()).map(class_2487::toString))).apply((Applicative)instance, (item, count, tag) -> {
        class_2487 nbt = tag.map(sTag -> {
            try {
                return class_2522.method_10718((String)sTag);
            }
            catch (CommandSyntaxException e) {
                return null;
            }
        }).orElse(null);
        class_1799 stack = new class_1799((class_1935)item, count.orElse(1).intValue());
        stack.method_7980(nbt);
        return stack;
    }));
    private static final Pattern DATE_PATTERN = Pattern.compile("(?:(?<weeks>[0-9]{1,2})w)?(?:(?:^|:)(?<days>[0-9])d)?(?:(?:^|:)(?<hours>[0-9]{1,2})h)?(?:(?:^|:)(?<minutes>[0-9]{1,2})m)?(?:(?:^|:)(?<seconds>[0-9]{1,2})s)?");

    public static int tryParseTime(JsonObject obj, String name, int fallback) {
        JsonElement e = obj.get(name);
        if (e == null || !e.isJsonPrimitive()) {
            return fallback;
        }
        if (e.getAsJsonPrimitive().isNumber()) {
            return e.getAsInt();
        }
        return ParseHelper.tryParseTime(e.getAsString(), name);
    }

    public static int tryParseTime(String time, String id) {
        Matcher matcher = DATE_PATTERN.matcher(time);
        if (!matcher.matches()) {
            throw new JsonSyntaxException("Malformed date time for " + id + ".");
        }
        int ticks = 0;
        ticks += ParseHelper.asTicks(matcher, "weeks", 12096000);
        ticks += ParseHelper.asTicks(matcher, "days", 1728000);
        ticks += ParseHelper.asTicks(matcher, "hours", 72000);
        ticks += ParseHelper.asTicks(matcher, "minutes", 1200);
        return ticks += ParseHelper.asTicks(matcher, "seconds", 20);
    }

    private static int asTicks(Matcher matcher, String group, int multiplier) {
        String val = matcher.group(group);
        if (val != null) {
            try {
                return Integer.parseInt(val) * multiplier;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static class_1799 icon(JsonObject obj, String name, class_1792 fallback) {
        JsonElement element = obj.get(name);
        if (element == null) {
            return new class_1799((class_1935)fallback);
        }
        if (element.isJsonPrimitive()) {
            class_1799 stack = new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960(element.getAsString())));
            if (stack.method_7960()) {
                return new class_1799((class_1935)fallback);
            }
            return stack;
        }
        class_1799 result = STACK_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial(arg_0 -> ((Logger)SimpleQuests.logger).error(arg_0)).orElse(class_1799.field_8037);
        if (result.method_7960()) {
            return new class_1799((class_1935)fallback);
        }
        return result;
    }

    public static Optional<JsonElement> writeItemStackToJson(class_1799 stack, class_1792 defaultValue) {
        if (stack.method_7947() == 1 && !stack.method_7985()) {
            return defaultValue != null && stack.method_7909() == defaultValue ? Optional.empty() : Optional.of(new JsonPrimitive(class_2378.field_11142.method_10221((Object)stack.method_7909()).toString()));
        }
        return STACK_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)stack).resultOrPartial(arg_0 -> ((Logger)SimpleQuests.logger).error(arg_0));
    }
}

