/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.simplequests.quest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.flemmli97.simplequests.SimpleQuests;
import io.github.flemmli97.simplequests.datapack.QuestEntryRegistry;
import io.github.flemmli97.simplequests.quest.ParseHelper;
import io.github.flemmli97.simplequests.quest.QuestCategory;
import io.github.flemmli97.simplequests.quest.QuestEntry;
import io.github.flemmli97.simplequests.quest.QuestEntryImpls;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class Quest
implements Comparable<Quest> {
    public final Map<String, QuestEntry> entries;
    public final class_2960 id;
    public final QuestCategory category;
    public final List<class_2960> neededParentQuests;
    public final class_2960 loot;
    public final String command;
    public final int repeatDelay;
    public final int repeatDaily;
    private final String questTaskString;
    public final String questSubmissionTrigger;
    public final boolean redoParent;
    public final boolean needsUnlock;
    public final boolean isDailyQuest;
    public final int sortingId;
    private final class_1799 icon;
    private String repeatDelayString;
    public final class_2048 unlockCondition;

    private Quest(class_2960 id, QuestCategory category, String questTaskString, List<class_2960> parents, boolean redoParent, boolean needsUnlock, class_2960 loot, class_1799 icon, int repeatDelay, int repeatDaily, int sortingId, Map<String, QuestEntry> entries, boolean isDailyQuest, String questSubmissionTrigger, class_2048 unlockCondition, String command) {
        this.id = id;
        this.category = category == null ? QuestCategory.DEFAULT_CATEGORY : category;
        this.questTaskString = questTaskString;
        this.neededParentQuests = parents;
        this.redoParent = redoParent;
        this.needsUnlock = needsUnlock;
        this.repeatDelay = repeatDelay;
        this.repeatDaily = repeatDaily;
        this.entries = entries;
        this.loot = loot;
        this.sortingId = sortingId;
        this.icon = icon;
        this.isDailyQuest = isDailyQuest;
        this.questSubmissionTrigger = questSubmissionTrigger;
        this.unlockCondition = unlockCondition;
        this.command = command;
    }

    public static Quest of(class_2960 id, QuestCategory category, JsonObject obj) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        JsonObject entries = class_3518.method_15296((JsonObject)obj, (String)"entries");
        entries.entrySet().forEach(ent -> {
            if (!((JsonElement)ent.getValue()).isJsonObject()) {
                throw new JsonSyntaxException("Expected JsonObject for " + (String)ent.getKey() + " but was " + ent.getValue());
            }
            class_2960 entryID = new class_2960(class_3518.method_15265((JsonObject)((JsonElement)ent.getValue()).getAsJsonObject(), (String)"id"));
            builder.put((Object)((String)ent.getKey()), (Object)QuestEntryRegistry.deserialize(entryID, ((JsonElement)ent.getValue()).getAsJsonObject()));
        });
        ImmutableList.Builder parents = new ImmutableList.Builder();
        JsonElement e = obj.get("parent_id");
        if (e != null) {
            if (e.isJsonPrimitive() && !e.getAsString().isEmpty()) {
                parents.add((Object)new class_2960(e.getAsString()));
            } else if (e.isJsonArray()) {
                e.getAsJsonArray().forEach(ea -> {
                    if (ea.isJsonPrimitive() && !ea.getAsString().isEmpty()) {
                        parents.add((Object)new class_2960(ea.getAsString()));
                    }
                });
            }
        }
        return new Quest(id, category, class_3518.method_15265((JsonObject)obj, (String)"task"), (List<class_2960>)parents.build(), class_3518.method_15258((JsonObject)obj, (String)"redo_parent", (boolean)false), class_3518.method_15258((JsonObject)obj, (String)"need_unlock", (boolean)false), new class_2960(class_3518.method_15265((JsonObject)obj, (String)"loot_table")), ParseHelper.icon(obj, "icon", class_1802.field_8407), ParseHelper.tryParseTime(obj, "repeat_delay", 0), class_3518.method_15282((JsonObject)obj, (String)"repeat_daily", (int)0), class_3518.method_15282((JsonObject)obj, (String)"sorting_id", (int)0), (Map<String, QuestEntry>)builder.build(), class_3518.method_15258((JsonObject)obj, (String)"daily_quest", (boolean)false), class_3518.method_15253((JsonObject)obj, (String)"submission_trigger", (String)""), class_2048.method_8913((JsonElement)class_3518.method_15281((JsonObject)obj, (String)"unlock_condition", null)), class_3518.method_15253((JsonObject)obj, (String)"command", (String)""));
    }

    public JsonObject serialize(boolean withId, boolean full) {
        JsonObject obj = new JsonObject();
        if (withId) {
            obj.addProperty("id", this.id.toString());
        }
        if (this.category != QuestCategory.DEFAULT_CATEGORY) {
            obj.addProperty("category", this.category.id.toString());
        }
        obj.addProperty("task", this.questTaskString);
        if (!this.neededParentQuests.isEmpty() || full) {
            if (this.neededParentQuests.size() == 1) {
                obj.addProperty("parent_id", this.neededParentQuests.get(0).toString());
            } else {
                JsonArray arr = new JsonArray();
                this.neededParentQuests.forEach(r -> arr.add(r.toString()));
                obj.add("parent_id", (JsonElement)arr);
            }
        }
        if (this.redoParent || full) {
            obj.addProperty("redo_parent", Boolean.valueOf(this.redoParent));
        }
        if (this.needsUnlock || full) {
            obj.addProperty("need_unlock", Boolean.valueOf(this.needsUnlock));
        }
        if (this.unlockCondition != class_2048.field_9599 || full) {
            obj.add("unlock_condition", this.unlockCondition.method_8912());
        }
        obj.addProperty("loot_table", this.loot.toString());
        if (!this.command.isEmpty() || full) {
            obj.addProperty("command", this.command);
        }
        ParseHelper.writeItemStackToJson(this.icon, full ? null : class_1802.field_8407).ifPresent(icon -> obj.add("icon", icon));
        if (this.repeatDelayString != null) {
            obj.addProperty("repeat_delay", this.repeatDelayString);
        } else if (this.repeatDelay != 0 || full) {
            obj.addProperty("repeat_delay", (Number)this.repeatDelay);
        }
        if (this.repeatDaily != 0 || full) {
            obj.addProperty("repeat_daily", (Number)this.repeatDaily);
        }
        if (this.sortingId != 0 || full) {
            obj.addProperty("sorting_id", (Number)this.sortingId);
        }
        if (this.isDailyQuest || full) {
            obj.addProperty("daily_quest", Boolean.valueOf(this.isDailyQuest));
        }
        if (!this.questSubmissionTrigger.isEmpty() || full) {
            obj.addProperty("submission_trigger", this.questSubmissionTrigger);
        }
        JsonObject entries = new JsonObject();
        this.entries.forEach((res, entry) -> {
            JsonObject val = entry.serialize();
            val.addProperty("id", entry.getId().toString());
            entries.add(res, (JsonElement)val);
        });
        obj.add("entries", (JsonElement)entries);
        return obj;
    }

    public class_5250 getTask() {
        return class_2561.method_43471((String)this.questTaskString);
    }

    public class_5250 getFormatted(MinecraftServer server, class_124 ... subFormatting) {
        class_5250 main = class_2561.method_43470((String)"").method_10852((class_2561)this.getTask().method_27692(class_124.field_1076));
        for (class_5250 tasks : this.getFormattedTasks(server)) {
            if (subFormatting != null) {
                main.method_27693("\n").method_10852((class_2561)tasks.method_27695(subFormatting));
                continue;
            }
            main.method_27693("\n").method_10852((class_2561)tasks);
        }
        return main;
    }

    public List<class_5250> getFormattedTasks(MinecraftServer server) {
        ArrayList<class_5250> list = new ArrayList<class_5250>();
        for (Map.Entry<String, QuestEntry> e : this.entries.entrySet()) {
            list.add(class_2561.method_43470((String)" - ").method_10852((class_2561)e.getValue().translation(server)));
        }
        return list;
    }

    public List<class_5250> getFormattedGuiTasks(class_3222 player) {
        ArrayList<class_5250> list = new ArrayList<class_5250>();
        for (Map.Entry<String, QuestEntry> e : this.entries.entrySet()) {
            QuestEntry questEntry = e.getValue();
            if (!(questEntry instanceof QuestEntryImpls.ItemEntry)) {
                list.add(class_2561.method_43470((String)" - ").method_10852((class_2561)e.getValue().translation(player.method_5682())));
                continue;
            }
            QuestEntryImpls.ItemEntry ing = (QuestEntryImpls.ItemEntry)questEntry;
            List<class_5250> wrapped = SimpleQuests.getHandler().wrapForGui(player, ing);
            boolean start = true;
            for (class_5250 comp : wrapped) {
                if (start) {
                    list.add(class_2561.method_43470((String)" - ").method_10852((class_2561)comp));
                    start = false;
                    continue;
                }
                list.add(class_2561.method_43470((String)"   ").method_10852((class_2561)comp));
            }
        }
        return list;
    }

    public class_1799 getIcon() {
        return this.icon.method_7972();
    }

    private void setDelayString(String repeatDelayString) {
        this.repeatDelayString = repeatDelayString;
    }

    public String toString() {
        return String.format("[Quest:%s]", this.id);
    }

    @Override
    public int compareTo(@NotNull Quest quest) {
        if (this.sortingId == quest.sortingId) {
            if (this.neededParentQuests.isEmpty() && !quest.neededParentQuests.isEmpty()) {
                return -1;
            }
            if (!this.neededParentQuests.isEmpty() && quest.neededParentQuests.isEmpty()) {
                return 1;
            }
            return this.id.method_12833(quest.id);
        }
        return Integer.compare(this.sortingId, quest.sortingId);
    }

    public static class Builder {
        private final Map<String, QuestEntry> entries = new LinkedHashMap<String, QuestEntry>();
        private final class_2960 id;
        private QuestCategory category = QuestCategory.DEFAULT_CATEGORY;
        private final List<class_2960> neededParentQuests = new ArrayList<class_2960>();
        private final class_2960 loot;
        private int repeatDelay;
        private int repeatDaily;
        private String repeatDelayString;
        private String submissionTrigger = "";
        private final String questTaskString;
        private boolean redoParent;
        private boolean needsUnlock;
        private boolean isDailyQuest;
        private int sortingId;
        private class_2048 unlockCondition = class_2048.field_9599;
        private class_1799 icon = new class_1799((class_1935)class_1802.field_8407);
        private String command = "";

        public Builder(class_2960 id, String task, class_2960 loot) {
            this.id = id;
            this.questTaskString = task;
            this.loot = loot;
        }

        public Builder withCategory(QuestCategory category) {
            this.category = category;
            return this;
        }

        public Builder addParent(class_2960 parent) {
            this.neededParentQuests.add(parent);
            return this;
        }

        public Builder setRedoParent() {
            this.redoParent = true;
            return this;
        }

        public Builder needsUnlocking() {
            this.needsUnlock = true;
            return this;
        }

        public Builder withIcon(class_1799 stack) {
            this.icon = stack;
            return this;
        }

        public Builder setRepeatDelay(int delay) {
            this.repeatDelay = delay;
            return this;
        }

        public Builder setRepeatDelay(String delay) {
            this.repeatDelayString = delay;
            this.repeatDelay = ParseHelper.tryParseTime(this.repeatDelayString, this.repeatDelayString);
            return this;
        }

        public Builder setMaxDaily(int max) {
            this.repeatDaily = max;
            return this;
        }

        public Builder withSortingNum(int num) {
            this.sortingId = num;
            return this;
        }

        public Builder addTaskEntry(String name, QuestEntry entry) {
            this.entries.put(name, entry);
            return this;
        }

        public Builder setDailyQuest() {
            this.isDailyQuest = true;
            return this;
        }

        public Builder withSubmissionTrigger(String trigger) {
            this.submissionTrigger = trigger;
            return this;
        }

        public Builder withUnlockCondition(class_2048 unlockCondition) {
            this.unlockCondition = unlockCondition;
            return this;
        }

        public Builder setCompletionCommand(String command) {
            this.command = command;
            return this;
        }

        public Quest build() {
            Quest quest = new Quest(this.id, this.category, this.questTaskString, this.neededParentQuests, this.redoParent, this.needsUnlock, this.loot, this.icon, this.repeatDelay, this.repeatDaily, this.sortingId, this.entries, this.isDailyQuest, this.submissionTrigger, this.unlockCondition, this.command);
            quest.setDelayString(this.repeatDelayString);
            return quest;
        }
    }
}

