/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.simplequests.quest;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.flemmli97.simplequests.config.ConfigHandler;
import io.github.flemmli97.simplequests.quest.ParseHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class QuestCategory
implements Comparable<QuestCategory> {
    public static final QuestCategory DEFAULT_CATEGORY = new QuestCategory(new class_2960("simplequests", "default_category"), "Main", List.of(), new class_1799((class_1935)class_1802.field_8360), false, -1, -1, true);
    public final class_2960 id;
    private final String name;
    public final List<String> description;
    private final class_1799 icon;
    public final boolean sameCategoryOnly;
    private final int maxConcurrentQuests;
    public final int sortingId;
    public boolean canBeSelected;

    private QuestCategory(class_2960 id, String name, List<String> description, class_1799 icon, boolean sameCategoryOnly, int maxConcurrentQuests, int sortingID, boolean canBeSelected) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.sameCategoryOnly = sameCategoryOnly;
        this.maxConcurrentQuests = maxConcurrentQuests;
        this.sortingId = sortingID;
        this.canBeSelected = canBeSelected;
    }

    public int getMaxConcurrentQuests() {
        if (this.maxConcurrentQuests == -1) {
            return ConfigHandler.config.maxConcurrentQuest;
        }
        return this.maxConcurrentQuests;
    }

    public class_5250 getName() {
        return class_2561.method_43471((String)this.name);
    }

    public static QuestCategory of(class_2960 id, JsonObject obj) {
        ImmutableList.Builder description = new ImmutableList.Builder();
        JsonElement e = obj.get("description");
        if (e != null) {
            if (e.isJsonPrimitive() && !e.getAsString().isEmpty()) {
                description.add((Object)e.getAsString());
            } else if (e.isJsonArray()) {
                e.getAsJsonArray().forEach(ea -> {
                    if (ea.isJsonPrimitive() && !ea.getAsString().isEmpty()) {
                        description.add((Object)ea.getAsString());
                    }
                });
            }
        }
        return new QuestCategory(id, class_3518.method_15265((JsonObject)obj, (String)"name"), (List<String>)description.build(), ParseHelper.icon(obj, "icon", class_1802.field_8360), class_3518.method_15258((JsonObject)obj, (String)"only_same_category", (boolean)false), class_3518.method_15282((JsonObject)obj, (String)"max_concurrent_quests", (int)-1), class_3518.method_15282((JsonObject)obj, (String)"sorting_id", (int)0), class_3518.method_15258((JsonObject)obj, (String)"selectable", (boolean)true));
    }

    public JsonObject serialize(boolean full) {
        JsonObject obj = new JsonObject();
        obj.addProperty("name", this.name);
        if (!this.description.isEmpty() || full) {
            if (this.description.size() == 1) {
                obj.addProperty("description", this.description.get(0));
            } else {
                JsonArray arr = new JsonArray();
                this.description.forEach(arg_0 -> ((JsonArray)arr).add(arg_0));
                obj.add("description", (JsonElement)arr);
            }
        }
        ParseHelper.writeItemStackToJson(this.icon, full ? null : class_1802.field_8360).ifPresent(icon -> obj.add("icon", icon));
        if (this.sameCategoryOnly || full) {
            obj.addProperty("only_same_category", Boolean.valueOf(this.sameCategoryOnly));
        }
        if (this.maxConcurrentQuests != -1 || full) {
            obj.addProperty("max_concurrent_quests", (Number)this.maxConcurrentQuests);
        }
        if (this.sortingId != 0 || full) {
            obj.addProperty("sorting_id", (Number)this.sortingId);
        }
        if (!this.canBeSelected || full) {
            obj.addProperty("selectable", Boolean.valueOf(this.canBeSelected));
        }
        return obj;
    }

    public class_1799 getIcon() {
        return this.icon.method_7972();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QuestCategory) {
            QuestCategory category = (QuestCategory)obj;
            return this.id.equals((Object)category.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return String.format("[Category:%s]", this.id);
    }

    @Override
    public int compareTo(@NotNull QuestCategory category) {
        if (this.sortingId == category.sortingId) {
            return this.id.method_12833(category.id);
        }
        return Integer.compare(this.sortingId, category.sortingId);
    }

    public static class Builder {
        private final class_2960 id;
        private final String name;
        private final List<String> description = new ArrayList<String>();
        private class_1799 icon = new class_1799((class_1935)class_1802.field_8360);
        private int sortingID;
        private boolean canBeSelected = true;
        private boolean sameCategoryOnly;
        private int maxConcurrentQuests = -1;

        public Builder(class_2960 id, String name) {
            this.id = id;
            this.name = name;
        }

        public Builder addDescription(String s) {
            this.description.add(s);
            return this;
        }

        public Builder withIcon(class_1799 stack) {
            this.icon = stack;
            return this;
        }

        public Builder unselectable() {
            this.canBeSelected = false;
            return this;
        }

        public Builder withSortingNumber(int num) {
            this.sortingID = num;
            return this;
        }

        public Builder countSameCategoryOnly() {
            this.sameCategoryOnly = true;
            return this;
        }

        public Builder setMaxConcurrent(int maxConcurrent) {
            this.maxConcurrentQuests = maxConcurrent;
            return this;
        }

        public QuestCategory build() {
            return new QuestCategory(this.id, this.name, this.description, this.icon, this.sameCategoryOnly, this.maxConcurrentQuests, this.sortingID, this.canBeSelected);
        }
    }
}

