/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.simplequests.quest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.flemmli97.simplequests.config.ConfigHandler;
import io.github.flemmli97.simplequests.mixin.EntityPredicateAccessor;
import io.github.flemmli97.simplequests.mixin.ItemPredicateAccessor;
import io.github.flemmli97.simplequests.player.PlayerData;
import io.github.flemmli97.simplequests.quest.QuestEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_4550;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class QuestEntryImpls {

    public record CraftingEntry(class_2073 item, class_2048 playerPredicate, int amount, String description) implements QuestEntry
    {
        public static final class_2960 ID = new class_2960("simplequests", "crafting");

        @Override
        public boolean submit(class_3222 player) {
            return false;
        }

        @Override
        public JsonObject serialize() {
            JsonObject obj = new JsonObject();
            obj.add("item", this.item.method_8971());
            obj.add("playerPredicate", this.playerPredicate.method_8912());
            obj.addProperty("amount", (Number)this.amount);
            obj.addProperty("description", this.description);
            return obj;
        }

        @Override
        public class_2960 getId() {
            return ID;
        }

        @Override
        public class_5250 translation(MinecraftServer server) {
            return class_2561.method_43471((String)this.description);
        }

        public boolean check(class_3222 player, class_1799 stack) {
            return this.item.method_8970(stack) && this.playerPredicate.method_8914(player, (class_1297)player);
        }

        public static CraftingEntry fromJson(JsonObject obj) {
            return new CraftingEntry(class_2073.method_8969((JsonElement)class_3518.method_15296((JsonObject)obj, (String)"item")), class_2048.method_8913((JsonElement)class_3518.method_15281((JsonObject)obj, (String)"playerPredicate", null)), class_3518.method_15282((JsonObject)obj, (String)"amount", (int)1), class_3518.method_15265((JsonObject)obj, (String)"description"));
        }
    }

    public record BlockInteractEntry(class_2073 heldItem, class_4550 blockPredicate, int amount, boolean use, boolean consumeItem, String description) implements QuestEntry
    {
        public static final class_2960 ID = new class_2960("simplequests", "block_interact");

        @Override
        public boolean submit(class_3222 player) {
            return false;
        }

        @Override
        public JsonObject serialize() {
            JsonObject obj = new JsonObject();
            obj.add("item", this.heldItem.method_8971());
            obj.add("block", this.blockPredicate.method_22452());
            obj.addProperty("amount", (Number)this.amount);
            obj.addProperty("use", Boolean.valueOf(this.use));
            obj.addProperty("consumeItem", Boolean.valueOf(this.consumeItem));
            obj.addProperty("description", this.description);
            return obj;
        }

        @Override
        public class_2960 getId() {
            return ID;
        }

        @Override
        public class_5250 translation(MinecraftServer server) {
            return class_2561.method_43471((String)this.description);
        }

        public boolean check(class_3222 player, class_2338 pos, boolean use) {
            boolean b;
            if (use != this.use) {
                return false;
            }
            boolean bl = b = this.heldItem.method_8970(player.method_6047()) && this.blockPredicate.method_22454(player.method_14220(), pos);
            if (b && this.consumeItem && !player.method_7337()) {
                player.method_6047().method_7934(1);
            }
            return b;
        }

        public static BlockInteractEntry fromJson(JsonObject obj) {
            class_2073 pred = class_2073.method_8969((JsonElement)class_3518.method_15281((JsonObject)obj, (String)"item", null));
            class_4550 blockPred = class_4550.method_22453((JsonElement)class_3518.method_15281((JsonObject)obj, (String)"block", null));
            if (pred == class_2073.field_9640 && blockPred == class_4550.field_20692) {
                throw new JsonSyntaxException("Either item or block has to be defined");
            }
            return new BlockInteractEntry(pred, blockPred, class_3518.method_15282((JsonObject)obj, (String)"amount", (int)1), class_3518.method_15270((JsonObject)obj, (String)"use"), class_3518.method_15258((JsonObject)obj, (String)"consumeItem", (boolean)false), class_3518.method_15265((JsonObject)obj, (String)"description"));
        }
    }

    public record EntityInteractEntry(class_2073 heldItem, class_2048 entityPredicate, int amount, boolean consume, String description) implements QuestEntry
    {
        public static final class_2960 ID = new class_2960("simplequests", "entity_interact");

        @Override
        public boolean submit(class_3222 player) {
            return false;
        }

        @Override
        public JsonObject serialize() {
            JsonObject obj = new JsonObject();
            obj.add("item", this.heldItem.method_8971());
            obj.add("predicate", this.entityPredicate.method_8912());
            obj.addProperty("amount", (Number)this.amount);
            obj.addProperty("consume", Boolean.valueOf(this.consume));
            obj.addProperty("description", this.description);
            return obj;
        }

        @Override
        public class_2960 getId() {
            return ID;
        }

        @Override
        public class_5250 translation(MinecraftServer server) {
            return class_2561.method_43471((String)this.description);
        }

        public boolean check(class_3222 player, class_1297 entity) {
            boolean b;
            boolean bl = b = this.heldItem.method_8970(player.method_6047()) && this.entityPredicate.method_8914(player, entity);
            if (b && this.consume && !player.method_7337()) {
                player.method_6047().method_7934(1);
            }
            return b;
        }

        public static EntityInteractEntry fromJson(JsonObject obj) {
            return new EntityInteractEntry(class_2073.method_8969((JsonElement)class_3518.method_15281((JsonObject)obj, (String)"item", null)), class_2048.method_8913((JsonElement)class_3518.method_15296((JsonObject)obj, (String)"predicate")), class_3518.method_15282((JsonObject)obj, (String)"amount", (int)1), class_3518.method_15258((JsonObject)obj, (String)"consume", (boolean)false), class_3518.method_15265((JsonObject)obj, (String)"description"));
        }
    }

    public record LocationEntry(class_2090 location, String description) implements QuestEntry
    {
        public static final class_2960 ID = new class_2960("simplequests", "location");

        @Override
        public boolean submit(class_3222 player) {
            return false;
        }

        @Override
        public JsonObject serialize() {
            JsonObject obj = new JsonObject();
            obj.add("predicate", this.location.method_9019());
            obj.addProperty("description", this.description);
            return obj;
        }

        @Override
        public class_2960 getId() {
            return ID;
        }

        @Override
        public class_5250 translation(MinecraftServer server) {
            return class_2561.method_43471((String)this.description);
        }

        @Override
        public Function<PlayerData, Boolean> tickable() {
            return d -> {
                class_3222 p = d.getPlayer();
                return p.field_6012 % 20 == 0 && this.location.method_9018(p.method_14220(), p.method_23317(), p.method_23318(), p.method_23321());
            };
        }

        public static LocationEntry fromJson(JsonObject obj) {
            return new LocationEntry(class_2090.method_9021((JsonElement)class_3518.method_15296((JsonObject)obj, (String)"predicate")), class_3518.method_15265((JsonObject)obj, (String)"description"));
        }
    }

    public record PositionEntry(class_2338 pos, int minDist, String description) implements QuestEntry
    {
        public static final class_2960 ID = new class_2960("simplequests", "position");

        @Override
        public boolean submit(class_3222 player) {
            return false;
        }

        @Override
        public JsonObject serialize() {
            JsonObject obj = new JsonObject();
            obj.addProperty("x", (Number)this.pos.method_10263());
            obj.addProperty("y", (Number)this.pos.method_10264());
            obj.addProperty("z", (Number)this.pos.method_10260());
            obj.addProperty("minDist", (Number)this.minDist);
            if (!this.description.isEmpty()) {
                obj.addProperty("description", this.description);
            }
            return obj;
        }

        @Override
        public class_2960 getId() {
            return ID;
        }

        @Override
        public class_5250 translation(MinecraftServer server) {
            return class_2561.method_43469((String)(!this.description.isEmpty() ? this.description : ConfigHandler.lang.get(this.getId().toString())), (Object[])new Object[]{this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260()});
        }

        @Override
        public Function<PlayerData, Boolean> tickable() {
            return d -> {
                class_3222 p = d.getPlayer();
                return p.field_6012 % 20 == 0 && p.method_24515().method_10262((class_2382)this.pos) < (double)(this.minDist * this.minDist);
            };
        }

        public static PositionEntry fromJson(JsonObject obj) {
            return new PositionEntry(new class_2338(class_3518.method_15260((JsonObject)obj, (String)"x"), class_3518.method_15260((JsonObject)obj, (String)"y"), class_3518.method_15260((JsonObject)obj, (String)"z")), class_3518.method_15260((JsonObject)obj, (String)"minDist"), class_3518.method_15253((JsonObject)obj, (String)"description", (String)""));
        }
    }

    public record AdvancementEntry(class_2960 advancement, boolean reset) implements QuestEntry
    {
        public static final class_2960 ID = new class_2960("simplequests", "advancement");

        @Override
        public boolean submit(class_3222 player) {
            boolean ret;
            class_161 adv = player.method_5682().method_3851().method_12896(this.advancement);
            boolean bl = ret = adv != null && player.method_14236().method_12882(adv).method_740();
            if (ret && this.reset) {
                class_167 prog = player.method_14236().method_12882(adv);
                prog.method_734().forEach(s -> player.method_14236().method_12883(adv, s));
            }
            return ret;
        }

        @Override
        public JsonObject serialize() {
            JsonObject obj = new JsonObject();
            obj.addProperty("advancement", this.advancement.toString());
            obj.addProperty("reset", Boolean.valueOf(this.reset));
            return obj;
        }

        @Override
        public class_2960 getId() {
            return ID;
        }

        @Override
        public class_5250 translation(MinecraftServer server) {
            class_161 advancement = server.method_3851().method_12896(this.advancement());
            Object adv = advancement == null ? class_2561.method_43471((String)String.format(ConfigHandler.lang.get("simplequests.missing.advancement"), this.advancement())) : advancement.method_684();
            return class_2561.method_43469((String)ConfigHandler.lang.get(this.getId().toString()), (Object[])new Object[]{adv});
        }

        public static AdvancementEntry fromJson(JsonObject obj) {
            return new AdvancementEntry(new class_2960(class_3518.method_15265((JsonObject)obj, (String)"advancement")), class_3518.method_15258((JsonObject)obj, (String)"reset", (boolean)false));
        }
    }

    public record XPEntry(int amount) implements QuestEntry
    {
        public static final class_2960 ID = new class_2960("simplequests", "xp");

        @Override
        public boolean submit(class_3222 player) {
            if (player.field_7520 >= this.amount) {
                player.method_7316(-this.amount);
                return true;
            }
            return false;
        }

        @Override
        public JsonObject serialize() {
            JsonObject obj = new JsonObject();
            obj.addProperty("amount", (Number)this.amount);
            return obj;
        }

        @Override
        public class_2960 getId() {
            return ID;
        }

        @Override
        public class_5250 translation(MinecraftServer server) {
            return class_2561.method_43471((String)String.format(ConfigHandler.lang.get(this.getId().toString()), this.amount));
        }

        public static XPEntry fromJson(JsonObject obj) {
            return new XPEntry(class_3518.method_15282((JsonObject)obj, (String)"amount", (int)1));
        }
    }

    public record KillEntry(class_2048 predicate, int amount, String description) implements QuestEntry
    {
        public static final class_2960 ID = new class_2960("simplequests", "entity");

        @Override
        public boolean submit(class_3222 player) {
            return false;
        }

        @Override
        public JsonObject serialize() {
            JsonObject obj = new JsonObject();
            obj.add("predicate", this.predicate.method_8912());
            obj.addProperty("amount", (Number)this.amount);
            if (!this.description.isEmpty()) {
                obj.addProperty("description", this.description);
            }
            return obj;
        }

        @Override
        public class_2960 getId() {
            return ID;
        }

        @Override
        public class_5250 translation(MinecraftServer server) {
            EntityPredicateAccessor acc = (EntityPredicateAccessor)this.predicate;
            String s = acc.getEntityType().method_8927().getAsString();
            if (s.startsWith("#")) {
                return class_2561.method_43469((String)(!this.description.isEmpty() ? this.description : ConfigHandler.lang.get(this.getId().toString() + ".tag")), (Object[])new Object[]{class_2561.method_43470((String)s).method_27692(class_124.field_1075), this.amount});
            }
            return class_2561.method_43469((String)(!this.description.isEmpty() ? this.description : ConfigHandler.lang.get(this.getId().toString())), (Object[])new Object[]{class_2561.method_43471((String)class_156.method_646((String)"entity", (class_2960)new class_2960(s))).method_27692(class_124.field_1075), this.amount});
        }

        public static KillEntry fromJson(JsonObject obj) {
            return new KillEntry(class_2048.method_8913((JsonElement)class_3518.method_15296((JsonObject)obj, (String)"predicate")), class_3518.method_15282((JsonObject)obj, (String)"amount", (int)1), class_3518.method_15253((JsonObject)obj, (String)"description", (String)""));
        }
    }

    public static class ItemEntry
    implements QuestEntry {
        public static final class_2960 ID = new class_2960("simplequests", "item");
        public final class_2073 predicate;
        public final int amount;
        public final String description;
        public final boolean consumeItems;

        public ItemEntry(class_2073 predicate, int amount, String description, boolean consumeItems) {
            this.predicate = predicate;
            this.amount = amount;
            this.description = description;
            this.consumeItems = consumeItems;
        }

        @Override
        public boolean submit(class_3222 player) {
            ArrayList<class_1799> matching = new ArrayList<class_1799>();
            int i = 0;
            for (class_1799 stack : player.method_31548().field_7547) {
                if (!this.predicate.method_8970(stack) || stack.method_7963() && stack.method_7919() != 0 || !this.isJustRenamedItem(stack)) continue;
                matching.add(stack);
                i += stack.method_7947();
            }
            if (i < this.amount) {
                return false;
            }
            if (this.consumeItems) {
                i = this.amount;
                for (class_1799 stack : matching) {
                    if (i > stack.method_7947()) {
                        int count = stack.method_7947();
                        stack.method_7939(0);
                        i -= count;
                        continue;
                    }
                    stack.method_7934(i);
                    break;
                }
            }
            return true;
        }

        private boolean isJustRenamedItem(class_1799 stack) {
            if (!stack.method_7985()) {
                return true;
            }
            if (stack.method_7969().method_10541().stream().allMatch(s -> s.equals("Damage") || s.equals("RepairCost") || s.equals("display"))) {
                class_2487 tag = stack.method_7969().method_10562("display");
                return tag.method_10545("Name") && tag.method_10546() == 1;
            }
            return true;
        }

        @Override
        public JsonObject serialize() {
            JsonObject obj = new JsonObject();
            obj.add("predicate", this.predicate.method_8971());
            if (!this.description.isEmpty()) {
                obj.addProperty("description", this.description);
            }
            obj.addProperty("amount", (Number)this.amount);
            obj.addProperty("consumeItems", Boolean.valueOf(this.consumeItems));
            return obj;
        }

        @Override
        public class_2960 getId() {
            return ID;
        }

        @Override
        public class_5250 translation(MinecraftServer server) {
            Function<String, String> key = s -> !this.description.isEmpty() ? this.description : ConfigHandler.lang.get(this.getId().toString() + s);
            List<class_5250> formattedItems = ItemEntry.itemComponents(this.predicate);
            if (formattedItems.isEmpty()) {
                return class_2561.method_43471((String)key.apply(".empty"));
            }
            if (formattedItems.size() == 1) {
                return class_2561.method_43469((String)key.apply(".single" + (this.consumeItems ? "" : ".keep")), (Object[])new Object[]{formattedItems.get(0).method_27692(class_124.field_1075), this.amount});
            }
            class_5250 items = null;
            for (class_5250 c : formattedItems) {
                if (items == null) {
                    items = class_2561.method_43470((String)"[").method_10852((class_2561)c);
                    continue;
                }
                items.method_10852((class_2561)class_2561.method_43470((String)", ")).method_10852((class_2561)c);
            }
            items.method_27693("]");
            return class_2561.method_43469((String)key.apply(".multi" + (this.consumeItems ? "" : ".keep")), (Object[])new Object[]{items.method_27692(class_124.field_1075), this.amount});
        }

        public static ItemEntry fromJson(JsonObject obj) {
            return new ItemEntry(class_2073.method_8969((JsonElement)class_3518.method_15296((JsonObject)obj, (String)"predicate")), obj.get("amount").getAsInt(), class_3518.method_15253((JsonObject)obj, (String)"description", (String)""), class_3518.method_15258((JsonObject)obj, (String)"consumeItems", (boolean)true));
        }

        public static List<class_5250> itemComponents(class_2073 predicate) {
            ItemPredicateAccessor acc = (ItemPredicateAccessor)predicate;
            ArrayList<class_5250> formattedItems = new ArrayList<class_5250>();
            if (acc.getItems() != null) {
                acc.getItems().forEach(i -> formattedItems.add(class_2561.method_43471((String)i.method_7876())));
            }
            if (acc.getTag() != null) {
                class_2378.field_11142.method_40266(acc.getTag()).ifPresent(n -> n.forEach(h -> formattedItems.add(class_2561.method_43471((String)((class_1792)h.comp_349()).method_7876()))));
            }
            return formattedItems;
        }
    }
}

