/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.client;

import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.item.ArrowData;
import dev.xkmc.l2archery.content.item.BowData;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.content.item.IBowConfig;
import dev.xkmc.l2archery.content.item.IGeneralConfig;
import dev.xkmc.l2archery.init.data.ArcheryConfig;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2library.base.overlay.InfoSideBar;
import dev.xkmc.l2library.util.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;

public class BowInfoOverlay
extends InfoSideBar {
    public BowInfoOverlay() {
        super(40.0f, 3.0f);
    }

    protected List<Component> getText() {
        LocalPlayer player = Proxy.getClientPlayer();
        ItemStack bowStack = player.m_21205_();
        ItemStack arrowStack = player.m_6298_(bowStack);
        Item item = bowStack.m_41720_();
        if (!(item instanceof GenericBowItem)) {
            return List.of();
        }
        GenericBowItem bow = (GenericBowItem)item;
        ArrowData arrowData = bow.parseArrow(arrowStack);
        if (arrowData == null) {
            return List.of();
        }
        BowData bowData = BowData.of(bow, bowStack);
        FeatureList features = FeatureList.merge(bowData.getFeatures(), arrowData.getFeatures());
        ArrayList<Component> text = new ArrayList<Component>();
        BowInfoOverlay.addStat(text, bowData, arrowData.getItem().getConfig());
        features.addEffectsTooltip(text);
        features.addTooltip(text);
        return text;
    }

    private static void addStat(List<Component> list, BowData data, IGeneralConfig arrow) {
        IBowConfig bow = data.getConfig();
        double dmg = 2.0;
        HashMap<Enchantment, Integer> map = data.ench();
        int power = map.getOrDefault(Enchantments.f_44988_, 0);
        if (power > 0) {
            dmg += (double)power * 0.5 + 0.5;
        }
        int punch = map.getOrDefault(Enchantments.f_44989_, 0);
        dmg += (double)(bow.damage() + arrow.damage());
        dmg *= (double)bow.speed();
        dmg = Math.ceil(dmg);
        String result = ItemStack.f_41584_.format(dmg) + "~" + ItemStack.f_41584_.format(dmg + dmg / 2.0 + 2.0);
        list.add((Component)LangData.STAT_DAMAGE.getWithColor(result, ChatFormatting.GREEN));
        list.add((Component)LangData.STAT_PUNCH.getWithColor(punch + bow.punch() + arrow.punch(), ChatFormatting.GREEN));
        list.add((Component)LangData.STAT_PULL_TIME.getWithColor((double)bow.pull_time() / 20.0, ChatFormatting.GREEN));
        list.add((Component)LangData.STAT_SPEED.getWithColor(Float.valueOf(bow.speed() * 20.0f), ChatFormatting.GREEN));
        list.add((Component)LangData.STAT_FOV.getWithColor(ItemStack.f_41584_.format(1.0f / (1.0f - bow.fov())), ChatFormatting.GREEN));
    }

    public int getSignature() {
        LocalPlayer player = Proxy.getClientPlayer();
        ItemStack bowStack = player.m_21205_();
        ItemStack arrowStack = player.m_6298_(bowStack);
        return player.m_150109_().f_35977_ + arrowStack.m_41720_().hashCode();
    }

    public boolean isScreenOn() {
        LocalPlayer player = Proxy.getClientPlayer();
        if (player == null) {
            return false;
        }
        ItemStack bowStack = player.m_21205_();
        if (!(bowStack.m_41720_() instanceof BowItem)) {
            return false;
        }
        ItemStack arrowStack = player.m_6298_(bowStack);
        if (!((Boolean)ArcheryConfig.CLIENT.showInfo.get()).booleanValue()) {
            return false;
        }
        Item item = bowStack.m_41720_();
        if (!(item instanceof GenericBowItem)) {
            return false;
        }
        GenericBowItem bow = (GenericBowItem)item;
        ArrowData arrowData = bow.parseArrow(arrowStack);
        return arrowData != null;
    }
}

