/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.controller;

import dev.xkmc.l2archery.content.entity.GenericArrowEntity;
import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.feature.types.OnShootFeature;
import dev.xkmc.l2archery.content.item.ArrowData;
import dev.xkmc.l2archery.content.item.BowData;
import dev.xkmc.l2archery.content.item.GenericArrowItem;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2library.util.code.GenericItemStack;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;

public class ArrowFeatureController {
    public static boolean canBowUseArrow(GenericBowItem bow, GenericItemStack<GenericArrowItem> arrow) {
        return FeatureList.canMerge(bow.getFeatures(null), ((GenericArrowItem)arrow.item()).getFeatures());
    }

    @Nullable
    public static AbstractArrow createArrowEntity(BowArrowUseContext ctx, BowData bow, ArrowData arrow) {
        FeatureList features = FeatureList.merge(bow.getFeatures(), arrow.getFeatures());
        ArrayList list = new ArrayList();
        for (OnShootFeature e2 : features.shot()) {
            if (e2.onShoot(ctx.user, list::add)) continue;
            return null;
        }
        GenericArrowEntity ans = new GenericArrowEntity(ctx.level(), ctx.user(), new GenericArrowEntity.ArrowEntityData(bow, arrow, ctx.no_consume, ctx.power), features);
        list.forEach(e -> e.accept(ans));
        return ans;
    }

    public record BowArrowUseContext(Level level, LivingEntity user, boolean no_consume, float power) {
    }
}

