/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.energy;

import dev.xkmc.l2archery.content.energy.IEnergyContainerItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyContainerItemWrapper
implements IEnergyStorage,
ICapabilityProvider {
    private final Capability<? extends IEnergyStorage> capability;
    private final LazyOptional<IEnergyStorage> holder = LazyOptional.of(() -> this);
    protected final ItemStack container;
    protected final IEnergyContainerItem item;

    public EnergyContainerItemWrapper(ItemStack containerIn, IEnergyContainerItem itemIn, Capability<? extends IEnergyStorage> capability) {
        this.container = containerIn;
        this.item = itemIn;
        this.capability = capability;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        return this.item.receiveEnergy(this.container, maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        return this.item.extractEnergy(this.container, maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.item.getEnergyStored(this.container);
    }

    public int getMaxEnergyStored() {
        return this.item.getMaxEnergyStored(this.container);
    }

    public boolean canExtract() {
        return this.item.getExtract(this.container) > 0;
    }

    public boolean canReceive() {
        return this.item.getReceive(this.container) > 0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == this.capability) {
            return this.holder.cast();
        }
        return LazyOptional.empty();
    }
}

