/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.energy;

import dev.xkmc.l2archery.content.energy.EnergyContainerItemWrapper;
import dev.xkmc.l2archery.content.energy.IEnergyContainerItem;
import dev.xkmc.l2archery.content.feature.bow.FluxFeature;
import dev.xkmc.l2archery.init.data.LangData;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.energy.IEnergyStorage;

public interface IFluxItem
extends IEnergyContainerItem,
IForgeItem {
    @Override
    default public Capability<? extends IEnergyStorage> getEnergyCapability() {
        return ForgeCapabilities.ENERGY;
    }

    @Nullable
    public FluxFeature getFluxFeature(ItemStack var1);

    public int getStorageRank(ItemStack var1);

    public int getConsumptionRank(ItemStack var1);

    @Override
    default public int getExtract(ItemStack container) {
        FluxFeature fluxFeature = this.getFluxFeature(container);
        if (fluxFeature == null) {
            return 0;
        }
        return fluxFeature.extract();
    }

    @Override
    default public int getReceive(ItemStack container) {
        FluxFeature fluxFeature = this.getFluxFeature(container);
        if (fluxFeature == null) {
            return 0;
        }
        return fluxFeature.receive();
    }

    @Override
    default public int getMaxEnergyStored(ItemStack container) {
        FluxFeature fluxFeature = this.getFluxFeature(container);
        if (fluxFeature == null) {
            return 0;
        }
        return (int)(Math.pow(2.0, this.getStorageRank(container)) * (double)fluxFeature.maxEnergy());
    }

    default public int getEnergyPerUse(ItemStack container) {
        FluxFeature fluxFeature = this.getFluxFeature(container);
        if (fluxFeature == null) {
            return 100;
        }
        return (int)(Math.pow(2.0, this.getConsumptionRank(container)) * (double)fluxFeature.perUsed());
    }

    default public boolean hasEnergy(ItemStack stack, int amount) {
        return this.getEnergyStored(stack) >= amount;
    }

    default public boolean useEnergy(ItemStack stack, int amount, boolean simulate) {
        if (simulate) {
            return this.hasEnergy(stack, amount);
        }
        if (this.hasEnergy(stack, amount)) {
            this.extractEnergy(stack, amount, false);
            return true;
        }
        return false;
    }

    default public boolean useEnergy(ItemStack stack, int amount, Entity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return true;
        }
        return this.useEnergy(stack, amount, false);
    }

    default public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        if (this.useEnergy(stack, amount * this.getEnergyPerUse(stack), (Entity)entity)) {
            return 0;
        }
        return amount;
    }

    default public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new EnergyContainerItemWrapper(stack, this, this.getEnergyCapability());
    }

    default public void tooltipDelegate(ItemStack stack, List<Component> tooltip) {
        if (this.getFluxFeature(stack) == null) {
            return;
        }
        tooltip.add((Component)LangData.ENERGY_STORED.get(IFluxItem.getScaledNumber(this.getEnergyStored(stack)), IFluxItem.getScaledNumber(this.getMaxEnergyStored(stack))));
        tooltip.add((Component)LangData.ENERGY_CONSUME.get(IFluxItem.getScaledNumber(this.getEnergyPerUse(stack))));
    }

    public static String getScaledNumber(long number) {
        if (number >= 1000000000L) {
            return number / 1000000000L + "." + number % 1000000000L / 100000000L + number % 100000000L / 10000000L + "G";
        }
        if (number >= 1000000L) {
            return number / 1000000L + "." + number % 1000000L / 100000L + number % 100000L / 10000L + "M";
        }
        if (number >= 1000L) {
            return number / 1000L + "." + number % 1000L / 100L + number % 100L / 10L + "k";
        }
        return String.valueOf(number);
    }
}

