/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.entity;

import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.feature.types.FlightControlFeature;
import dev.xkmc.l2archery.content.item.ArrowData;
import dev.xkmc.l2archery.content.item.BowData;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.init.registrate.ArcheryItems;
import dev.xkmc.l2archery.init.registrate.ArcheryRegister;
import dev.xkmc.l2library.serial.codec.PacketCodec;
import dev.xkmc.l2library.serial.codec.TagCodec;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

@FieldsAreNonnullByDefault
public class GenericArrowEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    public ArrowEntityData data = ArrowEntityData.DEFAULT;
    public FeatureList features = new FeatureList();

    public GenericArrowEntity(EntityType<GenericArrowEntity> type, Level level) {
        super(type, level);
    }

    public GenericArrowEntity(Level level, LivingEntity user, ArrowEntityData data, FeatureList features) {
        super((EntityType)ArcheryRegister.ET_ARROW.get(), user, level);
        this.data = data;
        this.features = features;
    }

    protected void m_5790_(EntityHitResult result) {
        if (!this.f_19853_.m_5776_()) {
            this.features.hit().forEach(e -> e.onHitEntity(this, result.m_82443_(), result));
        }
        super.m_5790_(result);
    }

    public void onHurtEntity(IndirectEntityDamageSource ind) {
        if (!this.f_19853_.m_5776_()) {
            this.features.hit().forEach(e -> e.onHurtEntity(this, (DamageSource)ind));
        }
    }

    public void m_7761_(LivingEntity target) {
        if (!this.f_19853_.m_5776_()) {
            this.features.hit().forEach(e -> e.postHurtEntity(this, target));
        }
    }

    protected ItemStack m_7941_() {
        return this.data.arrow.stack();
    }

    public void m_8119_() {
        Vec3 velocity = this.m_20184_();
        super.m_8119_();
        FlightControlFeature flight = this.features.flight();
        flight.tickMotion(this, velocity);
        if (flight.life > 0 && this.f_19797_ > flight.life) {
            this.m_146870_();
        }
    }

    protected void m_6901_() {
        ++this.f_36697_;
        if (this.f_36697_ >= this.features.flight().ground_life) {
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.features.hit().forEach(e -> e.onHitBlock(this, result));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        Tag data_tag = TagCodec.valueToTag((Object)this.data);
        if (data_tag != null) {
            tag.m_128365_("l2archery", data_tag);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("l2archery")) {
            CompoundTag data_tag = tag.m_128469_("l2archery");
            ArrowEntityData temp = (ArrowEntityData)TagCodec.valueFromTag((Tag)data_tag, ArrowEntityData.class);
            this.data = temp == null ? ArrowEntityData.DEFAULT : temp;
        }
        this.features = FeatureList.merge(this.data.bow.getFeatures(), this.data.arrow().getFeatures());
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        PacketCodec.to((FriendlyByteBuf)buffer, (Object)this.data);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        ArrowEntityData temp = (ArrowEntityData)PacketCodec.from((FriendlyByteBuf)additionalData, ArrowEntityData.class, null);
        this.data = temp == null ? ArrowEntityData.DEFAULT : temp;
        this.features = FeatureList.merge(this.data.bow.getFeatures(), this.data.arrow().getFeatures());
        this.features.shot().forEach(e -> e.onClientShoot(this));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public record ArrowEntityData(BowData bow, ArrowData arrow, boolean no_consume, float power) {
        public static final ArrowEntityData DEFAULT = new ArrowEntityData(BowData.of((GenericBowItem)ArcheryItems.STARTER_BOW.get()), ArrowData.of((Item)ArcheryItems.STARTER_ARROW.get()), false, 1.0f);
    }
}

