/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.feature;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.core.PotionAggregator;
import dev.xkmc.l2archery.content.feature.core.PotionArrowFeature;
import dev.xkmc.l2archery.content.feature.core.StatFeature;
import dev.xkmc.l2archery.content.feature.types.DefaultShootFeature;
import dev.xkmc.l2archery.content.feature.types.FlightControlFeature;
import dev.xkmc.l2archery.content.feature.types.OnHitFeature;
import dev.xkmc.l2archery.content.feature.types.OnPullFeature;
import dev.xkmc.l2archery.content.feature.types.OnShootFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FeatureList {
    public Stage stage = Stage.INHERENT;
    private final List<BowArrowFeature> all = new ArrayList<BowArrowFeature>();
    private final Map<Class<?>, BowArrowFeature> map = new HashMap();
    private final List<BowArrowFeature> inherent = new ArrayList<BowArrowFeature>();
    private final List<BowArrowFeature> upgrade = new ArrayList<BowArrowFeature>();
    private final List<BowArrowFeature> enchant = new ArrayList<BowArrowFeature>();
    private final List<OnPullFeature> pull = new ArrayList<OnPullFeature>();
    private final List<OnShootFeature> shot = new ArrayList<OnShootFeature>();
    private final List<OnHitFeature> hit = new ArrayList<OnHitFeature>();
    private FlightControlFeature flight = null;

    public static boolean canMerge(FeatureList bow, FeatureList arrow) {
        if (bow.flight != null && arrow.flight != null) {
            return false;
        }
        HashMap map = new HashMap();
        List<List<BowArrowFeature>> lists = List.of(bow.all, arrow.all);
        for (List<BowArrowFeature> list : lists) {
            for (BowArrowFeature feature : list) {
                Class<?> cls = feature.getClass();
                if (map.containsKey(cls) && !((BowArrowFeature)map.get(cls)).allowDuplicate()) {
                    return false;
                }
                map.put(cls, feature);
            }
        }
        return true;
    }

    public static FeatureList merge(FeatureList bow, FeatureList arrow) {
        FeatureList ans = new FeatureList();
        ans.shot.add(DefaultShootFeature.INSTANCE);
        for (BowArrowFeature f : bow.inherent) {
            ans.add(f);
        }
        for (BowArrowFeature f : arrow.inherent) {
            ans.add(f);
        }
        ans.stage = Stage.UPGRADE;
        for (BowArrowFeature f : bow.upgrade) {
            ans.add(f);
        }
        ans.stage = Stage.ENCHANT;
        for (BowArrowFeature f : bow.enchant) {
            ans.add(f);
        }
        return ans;
    }

    public boolean allow(BowArrowFeature feature) {
        Class<?> cls = feature.getClass();
        return !this.map.containsKey(cls) || this.map.get(cls).allowDuplicate();
    }

    public FeatureList add(BowArrowFeature feature) {
        BowArrowFeature f;
        if (!this.allow(feature)) {
            return this;
        }
        this.map.put(feature.getClass(), feature);
        this.all.add(feature);
        List<BowArrowFeature> list = switch (this.stage) {
            default -> throw new IncompatibleClassChangeError();
            case Stage.INHERENT -> this.inherent;
            case Stage.UPGRADE -> this.upgrade;
            case Stage.ENCHANT -> this.enchant;
        };
        list.add(feature);
        if (feature instanceof OnPullFeature) {
            f = (OnPullFeature)feature;
            this.pull.add((OnPullFeature)f);
        }
        if (feature instanceof OnShootFeature) {
            f = (OnShootFeature)feature;
            this.shot.add((OnShootFeature)f);
        }
        if (this.flight == null && feature instanceof FlightControlFeature) {
            f = (FlightControlFeature)feature;
            this.flight = f;
        }
        if (feature instanceof OnHitFeature) {
            f = (OnHitFeature)feature;
            this.hit.add((OnHitFeature)f);
        }
        return this;
    }

    public void addEffectsTooltip(List<Component> list) {
        PotionAggregator agg = new PotionAggregator();
        for (BowArrowFeature f : this.all) {
            if (!(f instanceof PotionArrowFeature)) continue;
            PotionArrowFeature p = (PotionArrowFeature)f;
            agg.addAll(p.instances());
        }
        PotionArrowFeature.addTooltip(agg.build(), list);
    }

    public void addTooltip(List<Component> list) {
        List<Pair> lists = List.of(Pair.of(this.inherent, (Object)ChatFormatting.GREEN), Pair.of(this.upgrade, (Object)ChatFormatting.GOLD), Pair.of(this.enchant, (Object)ChatFormatting.LIGHT_PURPLE));
        for (Pair l : lists) {
            for (BowArrowFeature f : (List)l.getFirst()) {
                if (f instanceof StatFeature) continue;
                ArrayList<MutableComponent> temp = new ArrayList<MutableComponent>();
                f.addTooltip(temp);
                for (MutableComponent c : temp) {
                    if (c.m_7383_().m_131135_() == null) {
                        c.m_130940_((ChatFormatting)l.getSecond());
                    }
                    list.add((Component)c);
                }
            }
        }
    }

    public List<BowArrowFeature> all() {
        return this.all;
    }

    public List<OnPullFeature> pull() {
        return this.pull;
    }

    public List<OnShootFeature> shot() {
        return this.shot;
    }

    public FlightControlFeature flight() {
        return this.flight == null ? FlightControlFeature.INSTANCE : this.flight;
    }

    public List<OnHitFeature> hit() {
        return this.hit;
    }

    public static enum Stage {
        INHERENT,
        UPGRADE,
        ENCHANT;

    }
}

