/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.feature.arrow;

import dev.xkmc.l2archery.content.entity.GenericArrowEntity;
import dev.xkmc.l2archery.content.explosion.BaseExplosion;
import dev.xkmc.l2archery.content.explosion.BaseExplosionContext;
import dev.xkmc.l2archery.content.explosion.ExplosionHandler;
import dev.xkmc.l2archery.content.explosion.ModExplosionContext;
import dev.xkmc.l2archery.content.explosion.VanillaExplosionContext;
import dev.xkmc.l2archery.content.feature.types.OnHitFeature;
import dev.xkmc.l2archery.init.data.LangData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public record ExplodeArrowFeature(float radius, boolean hurt, boolean breakBlock) implements OnHitFeature
{
    @Override
    public void onHitLivingEntity(GenericArrowEntity arrow, LivingEntity target, EntityHitResult hit) {
        this.explode(arrow, hit.m_82450_().m_7096_(), hit.m_82450_().m_7098_(), hit.m_82450_().m_7094_());
        arrow.m_146870_();
    }

    @Override
    public void onHitBlock(GenericArrowEntity arrow, BlockHitResult result) {
        this.explode(arrow, result.m_82450_().f_82479_, result.m_82450_().f_82480_, result.m_82450_().f_82481_);
        arrow.m_146870_();
    }

    private void explode(GenericArrowEntity arrow, double x, double y, double z) {
        BaseExplosionContext base = new BaseExplosionContext(arrow.f_19853_, x, y, z, this.radius);
        Explosion.BlockInteraction type = this.breakBlock() ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE;
        VanillaExplosionContext mc = new VanillaExplosionContext((Entity)arrow, this.getSource(arrow), null, false, type);
        ModExplosionContext mod = entity -> this.onExplosionHurt(arrow, entity);
        ExplosionHandler.explode(new BaseExplosion(base, mc, mod));
    }

    private boolean onExplosionHurt(GenericArrowEntity arrow, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)target;
            Entity entity = arrow.m_37282_();
            if (entity instanceof Player) {
                Player pl = (Player)entity;
                le.m_6598_(pl);
            }
            arrow.m_7761_(le);
            return this.hurt;
        }
        if (target instanceof ItemEntity) {
            return false;
        }
        if (target instanceof ExperienceOrb) {
            return false;
        }
        if (target instanceof HangingEntity) {
            return false;
        }
        if (target instanceof Boat) {
            return false;
        }
        if (target instanceof AbstractMinecart) {
            return false;
        }
        return this.hurt;
    }

    @Nullable
    private DamageSource getSource(GenericArrowEntity arrow) {
        Entity ent = arrow.m_37282_();
        if (ent instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)ent;
            return DamageSource.m_19373_((LivingEntity)le);
        }
        return null;
    }

    @Override
    public void addTooltip(List<MutableComponent> list) {
        if (this.hurt && this.breakBlock) {
            list.add(LangData.FEATURE_EXPLOSION_ALL.get(Float.valueOf(this.radius)));
        }
        if (this.hurt && !this.breakBlock) {
            list.add(LangData.FEATURE_EXPLOSION_HURT.get(Float.valueOf(this.radius)));
        }
        if (!this.hurt && !this.breakBlock) {
            list.add(LangData.FEATURE_EXPLOSION_NONE.get(Float.valueOf(this.radius)));
        }
    }
}

