/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.item;

import dev.xkmc.l2archery.content.config.BowArrowStatConfig;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.core.PotionArrowFeature;
import dev.xkmc.l2archery.content.item.IGeneralConfig;
import dev.xkmc.l2archery.content.stats.BowArrowStatType;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2archery.init.registrate.ArcheryRegister;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public record ArrowConfig(ResourceLocation id, boolean is_inf, List<BowArrowFeature> feature) implements IGeneralConfig
{
    private double getValue(BowArrowStatType type) {
        HashMap<BowArrowStatType, Double> map = BowArrowStatConfig.get().arrow_stats.get(this.id);
        if (map == null) {
            return type.getDefault();
        }
        return map.getOrDefault((Object)type, type.getDefault());
    }

    public List<MobEffectInstance> getEffects() {
        HashMap<MobEffect, BowArrowStatConfig.Effect> map = BowArrowStatConfig.get().arrow_effects.get(this.id);
        if (map == null) {
            return List.of();
        }
        return map.entrySet().stream().map(e -> new MobEffectInstance((MobEffect)e.getKey(), ((BowArrowStatConfig.Effect)e.getValue()).duration(), ((BowArrowStatConfig.Effect)e.getValue()).amplifier())).toList();
    }

    @Override
    public float damage() {
        return (float)this.getValue((BowArrowStatType)((Object)ArcheryRegister.DAMAGE.get()));
    }

    @Override
    public int punch() {
        return (int)this.getValue((BowArrowStatType)((Object)ArcheryRegister.PUNCH.get()));
    }

    public void addTooltip(List<Component> list) {
        LangData.STAT_DAMAGE.getWithSign(list, this.damage());
        LangData.STAT_PUNCH.getWithSign(list, this.punch());
        PotionArrowFeature.addTooltip(this.getEffects(), list);
    }
}

