/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.item;

import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.feature.core.PotionArrowFeature;
import dev.xkmc.l2archery.content.item.GenericArrowItem;
import dev.xkmc.l2archery.init.registrate.ArcheryItems;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpectralArrowItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;

public record ArrowData(Item item, @Nullable CompoundTag tag) {
    public static ArrowData of(Item item) {
        return new ArrowData(item, null);
    }

    public static ArrowData of(Item item, ItemStack stack) {
        return new ArrowData(item, stack.m_41783_());
    }

    public FeatureList getFeatures() {
        Item item = this.item;
        if (item instanceof GenericArrowItem) {
            GenericArrowItem gen = (GenericArrowItem)item;
            return gen.getFeatures();
        }
        FeatureList ans = new FeatureList();
        if (this.item instanceof SpectralArrowItem) {
            ans.add(new PotionArrowFeature(List.of(new MobEffectInstance(MobEffects.f_19619_, 200, 0))));
        } else if (this.item instanceof TippedArrowItem) {
            ItemStack stack = new ItemStack((ItemLike)this.item);
            stack.m_41751_(this.tag);
            ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>();
            for (MobEffectInstance ins : PotionUtils.m_43547_((ItemStack)stack)) {
                list.add(new MobEffectInstance(ins.m_19544_(), Math.max(ins.m_19557_() / 8, 1), ins.m_19564_(), ins.m_19571_(), ins.m_19572_()));
            }
            ans.add(new PotionArrowFeature(list));
        }
        return ans;
    }

    public ItemStack stack() {
        if (this.item instanceof TippedArrowItem) {
            ItemStack ans = new ItemStack((ItemLike)this.item);
            ans.m_41751_(this.tag);
            return ans;
        }
        return this.item.m_7968_();
    }

    public GenericArrowItem getItem() {
        GenericArrowItem gen;
        Item item = this.item;
        return item instanceof GenericArrowItem ? (gen = (GenericArrowItem)item) : (GenericArrowItem)((Object)ArcheryItems.STARTER_ARROW.get());
    }
}

