/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.item;

import dev.xkmc.l2archery.content.config.BowArrowStatConfig;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.item.IBowConfig;
import dev.xkmc.l2archery.content.stats.BowArrowStatType;
import dev.xkmc.l2archery.init.registrate.ArcheryRegister;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public record BowConfig(ResourceLocation id, int rank, List<BowArrowFeature> feature) implements IBowConfig
{
    private double getValue(BowArrowStatType type) {
        HashMap<BowArrowStatType, Double> map = BowArrowStatConfig.get().bow_stats.get(this.id);
        if (map == null) {
            return type.getDefault();
        }
        return map.getOrDefault((Object)type, type.getDefault());
    }

    @Override
    public List<MobEffectInstance> getEffects() {
        HashMap<MobEffect, BowArrowStatConfig.Effect> map = BowArrowStatConfig.get().bow_effects.get(this.id);
        if (map == null) {
            return List.of();
        }
        return map.entrySet().stream().map(e -> new MobEffectInstance((MobEffect)e.getKey(), ((BowArrowStatConfig.Effect)e.getValue()).duration(), ((BowArrowStatConfig.Effect)e.getValue()).amplifier())).toList();
    }

    @Override
    public float damage() {
        return (float)this.getValue((BowArrowStatType)((Object)ArcheryRegister.DAMAGE.get()));
    }

    @Override
    public int punch() {
        return (int)this.getValue((BowArrowStatType)((Object)ArcheryRegister.PUNCH.get()));
    }

    @Override
    public int pull_time() {
        return (int)this.getValue((BowArrowStatType)((Object)ArcheryRegister.PULL_TIME.get()));
    }

    @Override
    public float speed() {
        return (float)this.getValue((BowArrowStatType)((Object)ArcheryRegister.SPEED.get()));
    }

    @Override
    public int fov_time() {
        return (int)this.getValue((BowArrowStatType)((Object)ArcheryRegister.FOV_TIME.get()));
    }

    @Override
    public float fov() {
        return (float)this.getValue((BowArrowStatType)((Object)ArcheryRegister.FOV.get()));
    }
}

