/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.item;

import dev.xkmc.l2archery.content.enchantment.BowEnchantment;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.feature.core.CompoundBowConfig;
import dev.xkmc.l2archery.content.feature.core.StatFeature;
import dev.xkmc.l2archery.content.item.GenericBowItem;
import dev.xkmc.l2archery.content.item.IBowConfig;
import dev.xkmc.l2archery.content.upgrade.Upgrade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public record BowData(Item item, ArrayList<Upgrade> upgrade, HashMap<Enchantment, Integer> ench) {
    public static BowData of(GenericBowItem item) {
        return new BowData((Item)item, new ArrayList<Upgrade>(0), new HashMap<Enchantment, Integer>(0));
    }

    public static BowData of(GenericBowItem item, List<Upgrade> upgrade, Map<Enchantment, Integer> ench) {
        return new BowData((Item)item, new ArrayList<Upgrade>(upgrade), new HashMap<Enchantment, Integer>(ench));
    }

    public static BowData of(GenericBowItem item, ItemStack stack) {
        List<Upgrade> upgrade = GenericBowItem.getUpgrades(stack);
        return BowData.of(item, upgrade, stack.getAllEnchantments());
    }

    public FeatureList getFeatures() {
        FeatureList ans = this.getItem().getFeatures(null);
        ans.stage = FeatureList.Stage.UPGRADE;
        this.upgrade.forEach(e -> ans.add(e.getFeature()));
        ans.stage = FeatureList.Stage.ENCHANT;
        this.ench.forEach((k, v) -> {
            if (k instanceof BowEnchantment) {
                BowEnchantment b = (BowEnchantment)((Object)k);
                ans.add(b.getFeature((int)v));
            }
        });
        return ans;
    }

    public GenericBowItem getItem() {
        return (GenericBowItem)this.item;
    }

    public IBowConfig getConfig() {
        Record ans = this.getItem().config;
        for (Upgrade up : this.upgrade) {
            BowArrowFeature bowArrowFeature = up.getFeature();
            if (!(bowArrowFeature instanceof StatFeature)) continue;
            StatFeature f = (StatFeature)bowArrowFeature;
            ans = new CompoundBowConfig((IBowConfig)((Object)ans), f);
        }
        return ans;
    }
}

