/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.item;

import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.feature.core.PotionArrowFeature;
import dev.xkmc.l2archery.content.item.ArrowConfig;
import dev.xkmc.l2archery.content.item.IGeneralConfig;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GenericArrowItem
extends ArrowItem {
    private final ArrowConfig config;

    public GenericArrowItem(Item.Properties properties, ArrowConfig config) {
        super(properties);
        this.config = config;
    }

    public AbstractArrow m_6394_(Level level, ItemStack stack, LivingEntity user) {
        Arrow arrow = new Arrow(level, user);
        arrow.m_36878_(stack);
        return arrow;
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, Player player) {
        int enchant = bow.getEnchantmentLevel(Enchantments.f_44952_);
        return enchant > 0 && this.config.is_inf();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        this.config.addTooltip(list);
        this.getFeatures().addTooltip(list);
    }

    public FeatureList getFeatures() {
        FeatureList list = new FeatureList();
        List<MobEffectInstance> arrow_eff = this.config.getEffects();
        if (arrow_eff.size() > 0) {
            list.add(new PotionArrowFeature(arrow_eff));
        }
        for (BowArrowFeature feature : this.config.feature()) {
            list.add(feature);
        }
        return list;
    }

    public IGeneralConfig getConfig() {
        return this.config;
    }
}

