/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2archery.content.item;

import dev.xkmc.l2archery.content.controller.ArrowFeatureController;
import dev.xkmc.l2archery.content.controller.BowFeatureController;
import dev.xkmc.l2archery.content.enchantment.BowEnchantment;
import dev.xkmc.l2archery.content.energy.IFluxItem;
import dev.xkmc.l2archery.content.feature.BowArrowFeature;
import dev.xkmc.l2archery.content.feature.FeatureList;
import dev.xkmc.l2archery.content.feature.bow.FluxFeature;
import dev.xkmc.l2archery.content.feature.bow.IGlowFeature;
import dev.xkmc.l2archery.content.feature.bow.WindBowFeature;
import dev.xkmc.l2archery.content.feature.core.CompoundBowConfig;
import dev.xkmc.l2archery.content.feature.core.PotionArrowFeature;
import dev.xkmc.l2archery.content.feature.core.StatFeature;
import dev.xkmc.l2archery.content.item.ArrowData;
import dev.xkmc.l2archery.content.item.BowConfig;
import dev.xkmc.l2archery.content.item.BowData;
import dev.xkmc.l2archery.content.item.GenericArrowItem;
import dev.xkmc.l2archery.content.item.IBowConfig;
import dev.xkmc.l2archery.content.upgrade.Upgrade;
import dev.xkmc.l2archery.init.L2ArcheryClient;
import dev.xkmc.l2archery.init.data.LangData;
import dev.xkmc.l2archery.init.registrate.ArcheryEffects;
import dev.xkmc.l2archery.init.registrate.ArcheryRegister;
import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.l2library.util.code.GenericItemStack;
import dev.xkmc.l2library.util.nbt.ItemCompoundTag;
import dev.xkmc.l2library.util.raytrace.FastItem;
import dev.xkmc.l2library.util.raytrace.IGlowingTarget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class GenericBowItem
extends BowItem
implements FastItem,
IGlowingTarget,
IFluxItem {
    private static final HashSet<Class<?>> BLACKLIST = new HashSet();
    public static final String KEY = "upgrades";
    public final BowConfig config;

    private boolean arrowIsInfinite(ArrowItem item, ItemStack arrow, ItemStack bow) {
        if (BLACKLIST.contains(item.getClass())) {
            return false;
        }
        try {
            return item.isInfinite(arrow, bow, null);
        }
        catch (NullPointerException npe) {
            BLACKLIST.add(item.getClass());
            return false;
        }
    }

    public static List<Upgrade> getUpgrades(ItemStack stack) {
        ArrayList<Upgrade> ans = new ArrayList<Upgrade>();
        if (stack.m_41784_().m_128441_(KEY)) {
            ListTag list = ItemCompoundTag.of((ItemStack)stack).getSubList(KEY, 8).getOrCreate();
            for (int i = 0; i < list.size(); ++i) {
                Upgrade up = (Upgrade)((Object)ArcheryRegister.UPGRADE.get().getValue(new ResourceLocation(list.m_128778_(i))));
                if (up == null) continue;
                ans.add(up);
            }
        }
        return ans;
    }

    public static void addUpgrade(ItemStack result, Upgrade upgrade) {
        List<Upgrade> list = GenericBowItem.getUpgrades(result);
        list.add(upgrade);
        ListTag tag = new ListTag();
        for (Upgrade up : list) {
            tag.add((Object)StringTag.m_129297_((String)up.getID()));
        }
        ItemCompoundTag.of((ItemStack)result).getSubList(KEY, 8).setTag(tag);
    }

    public GenericBowItem(Item.Properties properties, BowConfig config) {
        super(properties);
        this.config = config;
        L2ArcheryClient.BOW_LIKE.add(this);
    }

    public void m_5551_(ItemStack bow, Level level, LivingEntity user, int remaining_pull_time) {
        if (user instanceof Player) {
            Player player = (Player)user;
            Optional<AbstractArrow> arrow = this.releaseUsingAndShootArrow(bow, level, (LivingEntity)player, remaining_pull_time);
            arrow.ifPresent(arg_0 -> ((Level)level).m_7967_(arg_0));
        }
    }

    /*
     * Unable to fully structure code
     */
    public Optional<AbstractArrow> releaseUsingAndShootArrow(ItemStack bow, Level level, LivingEntity user, int remaining_pull_time) {
        if (!(user instanceof Player)) ** GOTO lbl-1000
        pl = (Player)user;
        if (pl.m_150110_().f_35937_) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        instabuild = v0;
        BowFeatureController.stopUsing(user, (GenericItemStack<GenericBowItem>)new GenericItemStack((Item)this, bow));
        has_inf = instabuild != false || bow.getEnchantmentLevel(Enchantments.f_44952_) > 0;
        arrow = user.m_6298_(bow);
        pull_time = this.m_8105_(bow) - remaining_pull_time;
        if (user instanceof Player) {
            player = (Player)user;
            pull_time = ForgeEventFactory.onArrowLoose((ItemStack)bow, (Level)level, (Player)player, (int)pull_time, (boolean)(arrow.m_41619_() == false || has_inf != false));
        }
        if (pull_time < 0) {
            return Optional.empty();
        }
        if (arrow.m_41619_() && !has_inf) {
            return Optional.empty();
        }
        if (arrow.m_41619_()) {
            arrow = new ItemStack((ItemLike)Items.f_42412_);
        }
        if ((double)(power = this.getPowerForTime(user, pull_time)) < 0.1) {
            return Optional.empty();
        }
        no_consume = instabuild;
        var12_13 = arrow.m_41720_();
        if (var12_13 instanceof ArrowItem) {
            arrowItem = (ArrowItem)var12_13;
            if (user instanceof Player) {
                player = (Player)user;
                no_consume |= arrowItem.isInfinite(arrow, bow, player);
            } else {
                no_consume = this.arrowIsInfinite(arrowItem, arrow, bow);
            }
        }
        arrowOpt = Optional.empty();
        if (!level.f_46443_ && (arrowOpt = this.shootArrowOnServer(user, level, bow, arrow, power, no_consume)).isEmpty()) {
            return Optional.empty();
        }
        pitch = 1.0f / (level.m_213780_().m_188501_() * 0.4f + 1.2f) + power * 0.5f;
        level.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, pitch);
        if (!no_consume && !level.f_46443_) {
            arrow.m_41774_(1);
            if (arrow.m_41619_() && user instanceof Player) {
                player = (Player)user;
                player.m_150109_().m_36057_(arrow);
            }
        }
        if (user instanceof Player) {
            player = (Player)user;
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        return arrowOpt;
    }

    private Optional<AbstractArrow> shootArrowOnServer(LivingEntity player, Level level, ItemStack bow, ItemStack arrow, float power, boolean no_consume) {
        AbstractArrow abstractarrow;
        ArrowData data = this.parseArrow(arrow);
        if (data != null) {
            abstractarrow = ArrowFeatureController.createArrowEntity(new ArrowFeatureController.BowArrowUseContext(level, player, no_consume, power), BowData.of(this, bow), data);
        } else {
            int k;
            int j;
            ArrowItem arrowitem = (ArrowItem)(arrow.m_41720_() instanceof ArrowItem ? arrow.m_41720_() : Items.f_42412_);
            abstractarrow = arrowitem.m_6394_(level, arrow, player);
            abstractarrow = this.customArrow(abstractarrow);
            abstractarrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, power * 3.0f, 1.0f);
            if (power == 1.0f) {
                abstractarrow.m_36762_(true);
            }
            if ((j = bow.getEnchantmentLevel(Enchantments.f_44988_)) > 0) {
                abstractarrow.m_36781_(abstractarrow.m_36789_() + (double)j * 0.5 + 0.5);
            }
            if ((k = bow.getEnchantmentLevel(Enchantments.f_44989_)) > 0) {
                abstractarrow.m_36735_(k);
            }
            if (bow.getEnchantmentLevel(Enchantments.f_44990_) > 0) {
                abstractarrow.m_20254_(100);
            }
            if (no_consume) {
                abstractarrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
        }
        if (abstractarrow == null) {
            return Optional.empty();
        }
        bow.m_41622_(1, player, pl -> pl.m_21190_(player.m_7655_()));
        return Optional.of(abstractarrow);
    }

    public float getPullForTime(LivingEntity entity, float time) {
        float f = time / (float)this.config.pull_time();
        MobEffectInstance ins = entity.m_21124_((MobEffect)ArcheryEffects.QUICK_PULL.get());
        if (ins != null) {
            f = (float)((double)f * (1.5 + 0.5 * (double)ins.m_19564_()));
        }
        return Math.min(1.0f, f);
    }

    public float getPowerForTime(LivingEntity entity, float time) {
        float f = this.getPullForTime(entity, time);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return Math.min(1.0f, f);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void onUsingTick(ItemStack stack, LivingEntity user, int count) {
        if (user instanceof Player) {
            Player player = (Player)user;
            BowFeatureController.usingTick((LivingEntity)player, (GenericItemStack<GenericBowItem>)new GenericItemStack((Item)this, stack));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack;
        boolean flag = !player.m_6298_(itemstack = player.m_21120_(hand)).m_41619_();
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!player.m_150110_().f_35937_ && !flag) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(hand);
        BowFeatureController.startUsing((LivingEntity)player, (GenericItemStack<GenericBowItem>)new GenericItemStack((Item)this, itemstack));
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public Predicate<ItemStack> m_6437_() {
        return stack -> {
            if (stack.m_150930_(Items.f_42412_) || stack.m_150930_(Items.f_42737_) || stack.m_150930_(Items.f_42738_)) {
                return true;
            }
            Item patt9687$temp = stack.m_41720_();
            if (patt9687$temp instanceof GenericArrowItem) {
                GenericArrowItem arrow = (GenericArrowItem)patt9687$temp;
                return ArrowFeatureController.canBowUseArrow(this, (GenericItemStack<GenericArrowItem>)new GenericItemStack((Item)arrow, stack));
            }
            return false;
        };
    }

    @Nullable
    public ArrowData parseArrow(ItemStack arrow) {
        ArrowData data = null;
        Item item = arrow.m_41720_();
        if (item instanceof GenericArrowItem) {
            GenericArrowItem gen = (GenericArrowItem)item;
            data = ArrowData.of((Item)gen);
        } else if (arrow.m_150930_(Items.f_42412_)) {
            data = ArrowData.of(arrow.m_41720_());
        } else if (arrow.m_150930_(Items.f_42737_)) {
            data = ArrowData.of(arrow.m_41720_());
        } else if (arrow.m_150930_(Items.f_42738_)) {
            data = ArrowData.of(arrow.m_41720_(), arrow);
        }
        return data;
    }

    public AbstractArrow customArrow(AbstractArrow arrow) {
        return arrow;
    }

    public int m_6615_() {
        return 15;
    }

    public boolean isFast(ItemStack stack) {
        if (Proxy.getPlayer().m_21023_((MobEffect)ArcheryEffects.RUN_BOW.get())) {
            return true;
        }
        return this.config.feature().stream().anyMatch(e -> e instanceof WindBowFeature);
    }

    public int getDistance(ItemStack itemStack) {
        for (BowArrowFeature feature : this.getFeatures(itemStack).all()) {
            if (!(feature instanceof IGlowFeature)) continue;
            IGlowFeature glow = (IGlowFeature)((Object)feature);
            return glow.range();
        }
        return 0;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        List<Upgrade> ups = GenericBowItem.getUpgrades(stack);
        Record config = this.config;
        for (Upgrade up : ups) {
            BowArrowFeature bowArrowFeature = up.getFeature();
            if (!(bowArrowFeature instanceof StatFeature)) continue;
            StatFeature f = (StatFeature)bowArrowFeature;
            config = new CompoundBowConfig((IBowConfig)((Object)config), f);
        }
        config.addStatTooltip(list);
        for (Upgrade up : ups) {
            list.add((Component)Component.m_237115_((String)up.getDescriptionId()).m_130940_(ChatFormatting.GOLD));
        }
        FeatureList f = this.getFeatures(stack);
        f.addEffectsTooltip(list);
        f.addTooltip(list);
        this.tooltipDelegate(stack, list);
        list.add((Component)LangData.REMAIN_UPGRADE.get(this.getUpgradeSlot(stack)));
    }

    public FeatureList getFeatures(@Nullable ItemStack stack) {
        FeatureList ans = new FeatureList();
        List<MobEffectInstance> bow_eff = this.config.getEffects();
        if (bow_eff.size() > 0) {
            ans.add(new PotionArrowFeature(bow_eff));
        }
        for (BowArrowFeature feature : this.config.feature()) {
            ans.add(feature);
        }
        if (stack != null) {
            ans.stage = FeatureList.Stage.UPGRADE;
            for (Upgrade up : GenericBowItem.getUpgrades(stack)) {
                BowArrowFeature f = up.getFeature();
                if (f instanceof StatFeature) continue;
                ans.add(f);
            }
            ans.stage = FeatureList.Stage.ENCHANT;
            stack.getAllEnchantments().forEach((k, v) -> {
                if (k instanceof BowEnchantment) {
                    BowEnchantment b = (BowEnchantment)((Object)k);
                    ans.add(b.getFeature((int)v));
                }
            });
        }
        return ans;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44975_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.values()[this.config.rank()];
    }

    public int getUpgradeSlot(ItemStack stack) {
        return this.config.rank() + this.getEnchantmentLevel(stack, Enchantments.f_44975_) - GenericBowItem.getUpgrades(stack).size();
    }

    public static void remakeEnergy(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("Energy", 0);
    }

    @Override
    @Nullable
    public FluxFeature getFluxFeature(ItemStack stack) {
        for (Upgrade upgrade : GenericBowItem.getUpgrades(stack)) {
            BowArrowFeature bowArrowFeature = upgrade.getFeature();
            if (!(bowArrowFeature instanceof FluxFeature)) continue;
            FluxFeature ff = (FluxFeature)bowArrowFeature;
            return ff;
        }
        return null;
    }

    @Override
    public int getStorageRank(ItemStack stack) {
        return this.config.rank();
    }

    @Override
    public int getConsumptionRank(ItemStack stack) {
        return this.config.rank() + Math.min(4, GenericBowItem.getUpgrades(stack).size());
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getFluxFeature(stack) != null || super.m_142522_(stack);
    }
}

